/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.tests.util.MockUI;
import java.util.Collection;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@NotThreadSafe
class PageTest {
    private MockUI ui = new MockUI();
    private Page page = this.ui.getPage();

    PageTest() {
    }

    @AfterEach
    public void tearDown() {
        UI.setCurrent(null);
    }

    @Test
    public void testAddNullStyleSheet() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.page.addStyleSheet(null));
    }

    @Test
    public void testAddNullJavaScript() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.page.addJavaScript(null));
    }

    @Test
    public void testJavasScriptExecutionCancel() {
        Assertions.assertEquals((long)0L, (long)this.countPendingInvocations());
        PendingJavaScriptResult executeJavaScript = this.page.executeJs("window.alert('$0');", new Object[]{"foobar"});
        Assertions.assertEquals((long)1L, (long)this.countPendingInvocations());
        Assertions.assertTrue((boolean)executeJavaScript.cancelExecution());
        Assertions.assertEquals((long)0L, (long)this.countPendingInvocations());
    }

    @Test
    public void testJavaScriptExecutionTooLateCancel() {
        Assertions.assertEquals((long)0L, (long)this.countPendingInvocations());
        PendingJavaScriptResult executeJavaScript = this.page.executeJs("window.alert('$0');", new Object[]{"foobar"});
        Assertions.assertEquals((long)1L, (long)this.countPendingInvocations());
        Assertions.assertEquals((int)1, (int)this.ui.getInternals().dumpPendingJavaScriptInvocations().size());
        Assertions.assertEquals((long)0L, (long)this.countPendingInvocations());
        Assertions.assertFalse((boolean)executeJavaScript.cancelExecution());
    }

    @Test
    public void addDynamicImport_dynamicDependencyIsAvaialbleViaGetPendingSendToClient() {
        this.page.addDynamicImport("foo");
        DependencyList list = this.ui.getInternals().getDependencyList();
        Collection dependencies = list.getPendingSendToClient();
        Assertions.assertEquals((int)1, (int)dependencies.size());
        Dependency dependency = (Dependency)dependencies.iterator().next();
        Assertions.assertEquals((Object)"foo", (Object)dependency.getUrl());
    }

    private long countPendingInvocations() {
        return this.ui.getInternals().getPendingJavaScriptInvocations().count();
    }
}

