/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Svg;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SvgTest {
    static String TRIVIAL_SVG = "<svg>\n    <circle cx=\"50\" cy=\"50\" r=\"40\" stroke=\"green\" stroke-width=\"4\" fill=\"yellow\" />\n</svg>";
    static String TRIVIAL_SVG2 = "<svg height=\"140\" width=\"500\">\n  <ellipse cx=\"200\" cy=\"80\" rx=\"100\" ry=\"50\"\n  style=\"fill:yellow;stroke:purple;stroke-width:2\" />\n</svg>";
    static String SVG_WITH_DOCTYPE_ET_AL = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg width=\"391\" height=\"391\" viewBox=\"-70.5 -70.5 391 391\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n<rect fill=\"#fff\" stroke=\"#000\" x=\"-70\" y=\"-70\" width=\"390\" height=\"390\"/>\n<g opacity=\"0.8\">\n     <rect x=\"25\" y=\"25\" width=\"200\" height=\"200\" fill=\"lime\" stroke-width=\"4\" stroke=\"pink\" />\n     <circle cx=\"125\" cy=\"125\" r=\"75\" fill=\"orange\" />\n     <polyline points=\"50,150 50,200 200,200 200,100\" stroke=\"red\" stroke-width=\"4\" fill=\"none\" />\n     <line x1=\"50\" y1=\"50\" x2=\"200\" y2=\"200\" stroke=\"blue\" stroke-width=\"4\" />\n</g>\n</svg>";

    SvgTest() {
    }

    @Test
    public void attachedToElement() {
        new Svg("<svg></svg>").getParent();
    }

    @Test
    public void nullStream() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Svg((InputStream)null));
    }

    @Test
    public void text() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Svg("hello"));
    }

    @Test
    public void simpleSvg() {
        Svg svg = new Svg(TRIVIAL_SVG);
        Assertions.assertEquals((Object)TRIVIAL_SVG, (Object)SvgTest.getSvgDocumentBody(svg));
    }

    @Test
    public void withDocType() {
        Svg svg = new Svg(SVG_WITH_DOCTYPE_ET_AL);
        Assertions.assertTrue((boolean)SvgTest.getSvgDocumentBody(svg).startsWith("<svg"));
    }

    @Test
    public void resetSvg() {
        Svg svg = new Svg(TRIVIAL_SVG);
        Assertions.assertEquals((Object)TRIVIAL_SVG, (Object)SvgTest.getSvgDocumentBody(svg));
        svg.setSvg(TRIVIAL_SVG2);
        Assertions.assertEquals((Object)TRIVIAL_SVG2, (Object)SvgTest.getSvgDocumentBody(svg));
    }

    @Test
    public void fromStream() {
        Svg svg = new Svg((InputStream)new ByteArrayInputStream(TRIVIAL_SVG.getBytes()));
        Assertions.assertEquals((Object)TRIVIAL_SVG, (Object)SvgTest.getSvgDocumentBody(svg));
    }

    private static String getSvgDocumentBody(Svg svg) {
        return svg.getElement().getProperty("innerHTML");
    }
}

