/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HasValueBindRequiredIndicatorVisibleTest
extends SignalsUnitTest {
    HasValueBindRequiredIndicatorVisibleTest() {
    }

    @Test
    public void bindRequired_elementAttachedBefore_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_elementAttachedAfter_bindingActive() {
        TestComponent component = new TestComponent();
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_elementAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_elementNotAttached_bindingInactive() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_elementDetached_bindingInactive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        component.removeFromParent();
        signal.set((Object)false);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_elementReAttached_bindingActivate() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        component.removeFromParent();
        signal.set((Object)false);
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_bindOrSetRequiredWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindRequiredIndicatorVisible((Signal)new ValueSignal((Object)true));
        Assertions.assertThrows(BindingActiveException.class, () -> component.bindRequiredIndicatorVisible((Signal)new ValueSignal((Object)false)));
        Assertions.assertThrows(BindingActiveException.class, () -> component.setRequiredIndicatorVisible(false));
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_nullSignal_throwsNPE() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertThrows(NullPointerException.class, () -> component.bindRequiredIndicatorVisible(null));
    }

    @Test
    public void bindRequired_nullSignalValue_setsRequiredToFalse() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindRequiredIndicatorVisible((Signal)signal);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
        signal.set(null);
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
    }

    @Test
    public void bindRequired_toggleSignalValue_requiredUpdates() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindRequiredIndicatorVisible((Signal)signal);
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.isRequiredIndicatorVisible());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.isRequiredIndicatorVisible());
    }

    @Tag(value="input")
    private static class TestComponent
    extends AbstractField<TestComponent, String> {
        public TestComponent() {
            super((Object)"");
        }

        protected void setPresentationValue(String newPresentationValue) {
        }
    }
}

