/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.operations.TransactionOperation;
import com.vaadin.flow.signals.shared.impl.MutableTreeRevision;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.StagedTransaction;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public abstract class Transaction
implements Serializable {
    private static final Transaction ROOT = new ImmediateTransaction(){

        @Override
        public TreeRevision read(SignalTree tree) {
            return tree.submitted();
        }
    };
    private static final ThreadLocal<Transaction> currentTransaction = new ThreadLocal();

    public static Transaction getCurrent() {
        Transaction transaction = currentTransaction.get();
        if (transaction == null) {
            return ROOT;
        }
        return transaction;
    }

    public static boolean inTransaction() {
        return currentTransaction.get() != null;
    }

    public static <T> TransactionOperation<T> runInTransaction(ValueSupplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask, Type.STAGED);
    }

    public static <T> TransactionOperation<T> runInTransaction(ValueSupplier<T> transactionTask, Type transactionType) {
        Transaction outer = Transaction.getCurrent();
        Transaction inner = transactionType.create(outer);
        currentTransaction.set(inner);
        try {
            T value = transactionTask.supply();
            TransactionOperation<T> op = new TransactionOperation<T>(value);
            inner.commit(op.result()::complete);
            TransactionOperation<T> transactionOperation = op;
            return transactionOperation;
        }
        catch (RuntimeException e) {
            inner.rollback();
            throw e;
        }
        finally {
            if (outer == ROOT) {
                currentTransaction.remove();
            } else {
                currentTransaction.set(outer);
            }
        }
    }

    private static ValueSupplier<Void> asSupplier(TransactionTask task) {
        return () -> {
            task.execute();
            return null;
        };
    }

    public static TransactionOperation<Void> runInTransaction(TransactionTask transactionTask, Type transactionType) {
        return Transaction.runInTransaction(Transaction.asSupplier(transactionTask), transactionType);
    }

    public static TransactionOperation<Void> runInTransaction(TransactionTask transactionTask) {
        return Transaction.runInTransaction(Transaction.asSupplier(transactionTask));
    }

    public static <T> @Nullable T runWithoutTransaction(ValueSupplier<T> task) {
        Transaction previousTransaction = currentTransaction.get();
        try {
            currentTransaction.set(null);
            T t = task.supply();
            return t;
        }
        finally {
            currentTransaction.set(previousTransaction);
        }
    }

    public static void runWithoutTransaction(TransactionTask task) {
        Transaction.runWithoutTransaction(Transaction.asSupplier(task));
    }

    public abstract void include(SignalTree var1, SignalCommand var2,  @Nullable CommandsAndHandlers.CommandResultHandler var3, boolean var4);

    public void include(SignalTree tree, SignalCommand command,  @Nullable CommandsAndHandlers.CommandResultHandler resultHandler) {
        this.include(tree, command, resultHandler, true);
    }

    public abstract TreeRevision read(SignalTree var1);

    protected abstract void commit(Consumer<SignalOperation.ResultOrError<Void>> var1);

    protected abstract void rollback();

    public static enum Type {
        STAGED{

            @Override
            Transaction create(Transaction outer) {
                return new StagedTransaction(outer);
            }
        }
        ,
        WRITE_THROUGH{

            @Override
            Transaction create(Transaction outer) {
                return new RepeatableReadTransaction(outer);
            }
        };


        abstract Transaction create(Transaction var1) throws IllegalStateException;
    }

    private static class RepeatableReadTransaction
    extends ImmediateTransaction {
        private final Map<SignalTree, MutableTreeRevision> trees = new HashMap<SignalTree, MutableTreeRevision>();
        private final Transaction outer;

        public RepeatableReadTransaction(Transaction outer) {
            assert (outer != null);
            this.outer = outer;
        }

        private MutableTreeRevision getOrCreateReadRevision(SignalTree tree) {
            return this.trees.computeIfAbsent(tree, newTree -> new MutableTreeRevision(this.outer.read((SignalTree)newTree)));
        }

        @Override
        public void include(SignalTree tree, SignalCommand command,  @Nullable CommandsAndHandlers.CommandResultHandler resultHandler, boolean applyToTree) {
            this.getOrCreateReadRevision(tree).apply(command, null);
            super.include(tree, command, resultHandler, applyToTree);
            this.outer.include(tree, command, null, false);
        }

        @Override
        public TreeRevision read(SignalTree tree) {
            return this.getOrCreateReadRevision(tree);
        }
    }

    private static abstract class ImmediateTransaction
    extends Transaction {
        private ImmediateTransaction() {
        }

        @Override
        public void include(SignalTree tree, SignalCommand command,  @Nullable CommandsAndHandlers.CommandResultHandler resultHandler, boolean applyToTree) {
            if (applyToTree) {
                tree.commitSingleCommand(command, resultHandler);
            }
        }

        @Override
        protected void commit(Consumer<SignalOperation.ResultOrError<Void>> resultHandler) {
            resultHandler.accept(new SignalOperation.Result<Object>(null));
        }

        @Override
        protected void rollback() {
        }
    }
}

