/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.internal.nodefeature.PropertyChangeDeniedException;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.node.BaseJsonNode;

public class ElementPropertyMap
extends AbstractPropertyMap {
    private static final Set<String> forbiddenProperties = Stream.of("textContent", "classList", "className").collect(Collectors.toSet());
    private static final Set<String> ALWAYS_GENERATE_CHANGE_PROPERTIES = Collections.singleton("innerHTML");
    private Map<String, List<PropertyChangeListener>> listeners;
    private SerializablePredicate<String> updateFromClientFilter = null;

    public ElementPropertyMap(StateNode node) {
        super(node);
    }

    public Runnable deferredUpdateFromClient(String key, Serializable value) throws PropertyChangeDeniedException {
        return this.doDeferredUpdateFromClient(key, value);
    }

    @Override
    public void setProperty(String name, Serializable value, boolean emitChange) {
        assert (!forbiddenProperties.contains(name)) : "Forbidden property name: " + name;
        super.setProperty(name, value, emitChange);
    }

    public void setProperty(String name, Serializable value) {
        this.setProperty(name, value, true);
    }

    @Override
    protected Serializable get(String key) {
        Serializable value = super.get(key);
        if (value instanceof NodeMap.SignalBinding) {
            return ((NodeMap.SignalBinding)value).value();
        }
        return value;
    }

    @Override
    public void setPropertyFromSignal(String name, Object value) {
        boolean valueChanged;
        assert (!forbiddenProperties.contains(name)) : "Forbidden property name: " + name;
        Object valueToSet = value == null ? JacksonUtils.nullNode() : (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof BaseJsonNode ? (Serializable)value : (value instanceof List ? JacksonUtils.listToJson((List)value) : JacksonUtils.beanToJson(value)));
        Serializable oldValue = this.get(name);
        boolean bl = valueChanged = !Objects.equals(oldValue, valueToSet);
        if (valueChanged) {
            this.setProperty(name, (Serializable)valueToSet, true);
        }
    }

    public Registration addPropertyChangeListener(String name, PropertyChangeListener listener) {
        List propertyListeners;
        assert (this.hasElement());
        Objects.requireNonNull(name, "Property name cannot be null");
        Objects.requireNonNull(listener, "Listener cannot be null");
        if (this.listeners == null) {
            propertyListeners = new ArrayList(1);
            this.listeners = Collections.singletonMap(name, propertyListeners);
        } else {
            if (this.listeners.size() == 1 && !(this.listeners instanceof HashMap)) {
                this.listeners = new HashMap<String, List<PropertyChangeListener>>(this.listeners);
            }
            propertyListeners = this.listeners.computeIfAbsent(name, key -> new ArrayList(1));
        }
        return Registration.addAndRemove(propertyListeners, listener);
    }

    @Override
    protected Serializable put(String key, Serializable value, boolean emitChange) {
        PutResult result = this.putWithDeferredChangeEvent(key, value, emitChange);
        result.run();
        return result.oldValue;
    }

    private PutResult putWithDeferredChangeEvent(String key, Serializable value, boolean emitChange) {
        boolean valueChanged;
        Serializable oldValue = super.put(key, value, emitChange);
        boolean bl = valueChanged = !Objects.equals(oldValue, value);
        PropertyChangeEvent event = this.hasElement() && valueChanged ? new PropertyChangeEvent(Element.get(this.getNode()), key, oldValue, !emitChange) : null;
        return new PutResult(oldValue, event);
    }

    @Override
    protected Serializable remove(String key) {
        Serializable oldValue = super.remove(key);
        this.fireEvent(new PropertyChangeEvent(Element.get(this.getNode()), key, oldValue, true));
        return oldValue;
    }

    @Override
    protected boolean mayUpdateFromClient(String key, Serializable value) {
        return this.allowUpdateFromClient(key);
    }

    @Override
    protected boolean producePutChange(String key, boolean hadValueEarlier, Serializable newValue) {
        if (ALWAYS_GENERATE_CHANGE_PROPERTIES.contains(key)) {
            return true;
        }
        return super.producePutChange(key, hadValueEarlier, newValue);
    }

    private boolean allowUpdateFromClient(String key) {
        AllowUpdate isAllowed = this.isUpdateFromClientAllowedBeforeFilter(key);
        if (!AllowUpdate.NO_EXPLICIT_STATUS.equals((Object)isAllowed)) {
            return AllowUpdate.EXPLICITLY_ALLOW.equals((Object)isAllowed);
        }
        isAllowed = this.isUpdateFromClientAllowedByFilter(this.getNode(), key, false);
        if (!AllowUpdate.NO_EXPLICIT_STATUS.equals((Object)isAllowed)) {
            return AllowUpdate.EXPLICITLY_ALLOW.equals((Object)isAllowed);
        }
        return false;
    }

    private boolean isDisallowedByFilter(String key) {
        AllowUpdate allowed;
        if (AllowUpdate.NO_EXPLICIT_STATUS.equals((Object)this.isUpdateFromClientAllowedBeforeFilter(key)) && !AllowUpdate.NO_EXPLICIT_STATUS.equals((Object)(allowed = this.isUpdateFromClientAllowedByFilter(this.getNode(), key, true)))) {
            assert (AllowUpdate.EXPLICITLY_DISALLOW.equals((Object)allowed)) : "Implementation error. If update for a property is allowed before the filter it's expected that the filter disallow it";
            return true;
        }
        return false;
    }

    private AllowUpdate isUpdateFromClientAllowedBeforeFilter(String property) {
        if (forbiddenProperties.contains(property)) {
            return AllowUpdate.EXPLICITLY_DISALLOW;
        }
        StateNode node = this.getNode();
        if (node.hasFeature(ElementListenerMap.class) && node.getFeature(ElementListenerMap.class).getPropertySynchronizationMode(property) != null) {
            return AllowUpdate.EXPLICITLY_ALLOW;
        }
        return AllowUpdate.NO_EXPLICIT_STATUS;
    }

    private AllowUpdate isUpdateFromClientAllowedByFilter(StateNode node, String key, boolean log) {
        ModelList list;
        ElementPropertyMap parentMap;
        Optional<String> parentProperty;
        StateNode parent;
        if (node.hasFeature(ElementPropertyMap.class)) {
            ElementPropertyMap propertyMap = node.getFeature(ElementPropertyMap.class);
            if (propertyMap.updateFromClientFilter != null) {
                boolean allow = propertyMap.updateFromClientFilter.test(key);
                if (!allow && log) {
                    ElementPropertyMap.getLogger().warn("Ignoring model update for {}. For security reasons, the property must have a two-way binding in the template, be annotated with @AllowClientUpdates in the model, or be defined as synchronized.", (Object)key);
                }
                return allow ? AllowUpdate.EXPLICITLY_ALLOW : AllowUpdate.EXPLICITLY_DISALLOW;
            }
        }
        if ((parent = node.getParent()) == null) {
            return AllowUpdate.NO_EXPLICIT_STATUS;
        }
        if (parent.hasFeature(ElementPropertyMap.class) && (parentProperty = (parentMap = parent.getFeature(ElementPropertyMap.class)).getPropertyNames().filter(property -> node.equals(parentMap.get((String)property))).findFirst()).isPresent()) {
            String property2 = parentProperty.get() + '.' + key;
            return this.isUpdateFromClientAllowedByFilter(parent, property2, log);
        }
        if (parent.hasFeature(ModelList.class) && (list = parent.getFeature(ModelList.class)).contains(node)) {
            return this.isUpdateFromClientAllowedByFilter(parent, key, log);
        }
        return AllowUpdate.NO_EXPLICIT_STATUS;
    }

    public void setUpdateFromClientFilter(SerializablePredicate<String> updateFromClientFilter) {
        this.updateFromClientFilter = updateFromClientFilter;
    }

    private ElementPropertyMap getOrCreateModelMap(String key) {
        Serializable value = this.getProperty(key);
        if (value == null) {
            value = new StateNode(Collections.singletonList(ElementPropertyMap.class), new Class[0]);
            this.setProperty(key, value);
        }
        assert (value instanceof StateNode);
        assert (((StateNode)value).hasFeature(ElementPropertyMap.class));
        return ((StateNode)value).getFeature(ElementPropertyMap.class);
    }

    private ModelList getOrCreateModelList(String key) {
        Serializable value = this.getProperty(key);
        if (value == null) {
            value = new StateNode(Collections.singletonList(ModelList.class), new Class[0]);
            this.setProperty(key, value);
        }
        assert (value instanceof StateNode);
        assert (((StateNode)value).hasFeature(ModelList.class));
        return ((StateNode)value).getFeature(ModelList.class);
    }

    public ElementPropertyMap resolveModelMap(String modelPath) {
        if ("".equals(modelPath)) {
            return this;
        }
        return this.resolve(modelPath, ElementPropertyMap.class);
    }

    public ModelList resolveModelList(String modelPath) {
        return this.resolve(modelPath, ModelList.class);
    }

    private <T extends NodeFeature> T resolve(String modelPath, Class<T> leafType) {
        assert (modelPath != null);
        assert (!"".equals(modelPath));
        assert (!modelPath.startsWith("."));
        assert (!modelPath.endsWith("."));
        assert (leafType == ElementPropertyMap.class || leafType == ModelList.class);
        int dotLocation = modelPath.indexOf(46);
        if (dotLocation == -1) {
            if (leafType == ElementPropertyMap.class) {
                return (T)this.getOrCreateModelMap(modelPath);
            }
            return (T)this.getOrCreateModelList(modelPath);
        }
        String firstKey = modelPath.substring(0, dotLocation);
        String remainingPath = modelPath.substring(dotLocation + 1);
        ElementPropertyMap subMap = this.getOrCreateModelMap(firstKey);
        return subMap.resolve(remainingPath, leafType);
    }

    public static ElementPropertyMap getModel(StateNode node) {
        assert (node != null);
        return node.getFeature(ElementPropertyMap.class);
    }

    private void fireEvent(PropertyChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        List<PropertyChangeListener> propertyListeners = this.listeners.get(event.getPropertyName());
        if (propertyListeners != null && !propertyListeners.isEmpty()) {
            new ArrayList<PropertyChangeListener>(propertyListeners).forEach(listener -> listener.propertyChange(event));
        }
    }

    private boolean hasElement() {
        return this.getNode().hasFeature(ElementData.class);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ElementPropertyMap.class);
    }

    private Runnable doDeferredUpdateFromClient(String key, Serializable value) throws PropertyChangeDeniedException {
        if (!this.allowUpdateFromClient(key)) {
            if (this.isDisallowedByFilter(key)) {
                return () -> {};
            }
            throw new PropertyChangeDeniedException(String.format("Feature '%s' doesn't allow the client to update '%s'. For security reasons, the property must be defined as synchronized through the Element's API.", this.getClass().getName(), key));
        }
        PutResult putResult = null;
        if (this.hasSignal(key)) {
            NodeMap.SignalBinding binding = (NodeMap.SignalBinding)super.get(key);
            AtomicReference<Serializable> putValue = new AtomicReference<Serializable>(value);
            SignalBindingFeature feat = new SignalBindingFeature(this.getNode());
            feat.setBinding("value", binding.registration(), binding.signal(), binding.writeCallback());
            feat.updateSignalByWriteCallback("value", this.get(key), value, Objects::equals, putValue::set);
            Serializable oldValue = super.put(key, new NodeMap.SignalBinding(binding.signal(), binding.registration(), putValue.get(), binding.writeCallback()), false);
            putResult = new PutResult(oldValue, null);
        } else {
            putResult = this.putWithDeferredChangeEvent(key, value, false);
        }
        return putResult;
    }

    private class PutResult
    implements Runnable {
        private final Serializable oldValue;
        private final PropertyChangeEvent eventToFire;

        public PutResult(Serializable oldValue, PropertyChangeEvent eventToFire) {
            this.oldValue = oldValue;
            this.eventToFire = eventToFire;
        }

        @Override
        public void run() {
            if (this.eventToFire != null) {
                ElementPropertyMap.this.fireEvent(this.eventToFire);
            }
        }
    }

    private static enum AllowUpdate {
        EXPLICITLY_ALLOW,
        EXPLICITLY_DISALLOW,
        NO_EXPLICIT_STATUS;

    }
}

