/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueModifier;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueSignalTest
extends SignalTestBase {
    @Test
    void constructor_noArgs_nullValue() {
        ValueSignal signal = new ValueSignal();
        Assertions.assertNull((Object)signal.get());
    }

    @Test
    void constructor_initialValue_initialValueUsed() {
        ValueSignal signal = new ValueSignal((Object)"value");
        Assertions.assertEquals((Object)"value", (Object)signal.get());
    }

    @Test
    void setValue_valueUsed() {
        ValueSignal signal = new ValueSignal();
        signal.set((Object)"value");
        Assertions.assertEquals((Object)"value", (Object)signal.get());
    }

    @Test
    void replace_expectedValue_valueUpdated() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        SignalOperation operation = signal.replace((Object)"initial", (Object)"update");
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"update", (Object)signal.get());
    }

    @Test
    void replace_otherValue_valueNotUpdated() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        SignalOperation operation = signal.replace((Object)"other", (Object)"update");
        TestUtil.assertFailure(operation);
        Assertions.assertEquals((Object)"initial", (Object)signal.get());
    }

    @Test
    void update_updatesTheValue() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        CancelableOperation operation = signal.update((SignalUpdater & Serializable)oldValue -> {
            Assertions.assertEquals((Object)"initial", (Object)oldValue);
            return "update";
        });
        String oldValue2 = (String)TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"initial", (Object)oldValue2);
        Assertions.assertEquals((Object)"update", (Object)signal.get());
    }

    @Test
    void update_callbackThrows_exceptionPropagated() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        RuntimeException theException = new RuntimeException();
        RuntimeException caught = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> signal.update((SignalUpdater & Serializable)ignore -> {
            throw theException;
        }));
        Assertions.assertSame((Object)theException, (Object)caught);
    }

    @Test
    void modify_modifiesValue_valueModified() {
        String[] holder = new String[]{"initial"};
        ValueSignal signal = new ValueSignal((Object)holder);
        signal.modify((ValueModifier & Serializable)value -> {
            Assertions.assertSame((Object)holder, (Object)value);
            holder[0] = "update";
        });
        Assertions.assertEquals((Object)"update", (Object)holder[0]);
        Assertions.assertSame((Object)holder, (Object)signal.get());
    }

    @Test
    void asReadonly_notWritable() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        Signal readonly = signal.asReadonly();
        Assertions.assertFalse((boolean)(readonly instanceof ValueSignal));
    }

    @Test
    void asReadonly_changeSignal_readonlyUpdated() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        Signal readonly = signal.asReadonly();
        signal.set((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)readonly.get());
    }

    @Test
    void usageTracker_setNewValue_changeDetected() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        Assertions.assertFalse((boolean)usage.hasChanges());
        AtomicBoolean invoked = new AtomicBoolean(false);
        usage.onNextChange((TransientListener & Serializable)initial -> {
            Assertions.assertFalse((boolean)initial);
            invoked.set(true);
            return false;
        });
        signal.set((Object)"update");
        Assertions.assertTrue((boolean)usage.hasChanges());
        Assertions.assertTrue((boolean)invoked.get());
    }

    @Test
    void usageTracker_updateSameValue_noChangeDetected() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        AtomicBoolean invoked = new AtomicBoolean(false);
        usage.onNextChange((TransientListener & Serializable)initial -> {
            Assertions.assertFalse((boolean)initial);
            invoked.set(true);
            return false;
        });
        signal.update((SignalUpdater & Serializable)x -> x);
        Assertions.assertFalse((boolean)usage.hasChanges());
        Assertions.assertFalse((boolean)invoked.get());
    }

    @Test
    void usageTracker_listenToChangedUsage_initialFlagSet() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.set((Object)"update");
        AtomicBoolean invoked = new AtomicBoolean(false);
        usage.onNextChange((TransientListener & Serializable)initial -> {
            Assertions.assertTrue((boolean)initial);
            invoked.set(true);
            return false;
        });
        Assertions.assertTrue((boolean)invoked.get());
    }

    @Test
    void usageTracker_keepListening_listenerKept() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.set((Object)"update1");
        AtomicInteger count = new AtomicInteger();
        usage.onNextChange((TransientListener & Serializable)ignore -> {
            count.incrementAndGet();
            return true;
        });
        signal.set((Object)"update2");
        Assertions.assertEquals((int)2, (int)count.get());
        signal.set((Object)"update3");
        Assertions.assertEquals((int)3, (int)count.get());
    }

    @Test
    void usageTracker_stopAfterInitial_stopped() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.set((Object)"update1");
        AtomicInteger count = new AtomicInteger();
        usage.onNextChange((TransientListener & Serializable)ignore -> {
            count.incrementAndGet();
            return false;
        });
        Assertions.assertEquals((int)1, (int)count.intValue());
        signal.set((Object)"update2");
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void usageTracker_stopAfterSubsequent_stopped() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        AtomicInteger count = new AtomicInteger();
        usage.onNextChange((TransientListener & Serializable)ignore -> {
            count.incrementAndGet();
            return false;
        });
        signal.set((Object)"update1");
        Assertions.assertEquals((int)1, (int)count.intValue());
        signal.set((Object)"update2");
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void usageTracker_anyModify_detectedAsAChange() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.modify((ValueModifier & Serializable)value -> {});
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void usageTracker_peek_noUsageDetected() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.peek());
        Assertions.assertSame((Object)UsageTracker.NO_USAGE, (Object)usage);
    }

    @Test
    void concurrency_updateHoldsLock() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        signal.update((SignalUpdater & Serializable)value -> {
            Assertions.assertTrue((boolean)signal.getLock().isHeldByCurrentThread());
            return value;
        });
        Assertions.assertFalse((boolean)signal.getLock().isHeldByCurrentThread());
    }

    @Test
    void concurrency_lockHeld_operationsAreBlocked() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        signal.getLock().lock();
        AtomicInteger completed = new AtomicInteger();
        Thread.startVirtualThread(() -> {
            signal.get();
            completed.incrementAndGet();
        });
        Thread.startVirtualThread(() -> {
            signal.peek();
            completed.incrementAndGet();
        });
        Thread.startVirtualThread(() -> {
            signal.set((Object)"update");
            completed.incrementAndGet();
        });
        Thread.startVirtualThread(() -> {
            signal.replace((Object)"foo", (Object)"bar");
            completed.incrementAndGet();
        });
        Thread.startVirtualThread(() -> {
            signal.update((SignalUpdater & Serializable)x -> x);
            completed.incrementAndGet();
        });
        ValueSignalTest.assertEventually(() -> signal.getLock().getQueueLength() == 5);
        Assertions.assertEquals((int)0, (int)completed.get());
        signal.getLock().unlock();
        ValueSignalTest.assertEventually(() -> completed.get() == 5);
        Assertions.assertEquals((int)0, (int)signal.getLock().getQueueLength());
    }

    @Test
    void concurrency_modifyWhileLocked_modifyThrowsEagerly() throws InterruptedException {
        ValueSignal signal = new ValueSignal((Object)"initial");
        Thread lockThread = Thread.startVirtualThread(() -> signal.getLock().lock());
        lockThread.join();
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.modify((ValueModifier & Serializable)x -> Assertions.fail((String)"Should never get here")));
    }

    @Test
    void concurrency_otherUsageWhileModifying_otherUsageThrows() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        Semaphore modifyStarted = new Semaphore(0);
        Semaphore modifyCanProceed = new Semaphore(0);
        Thread.startVirtualThread(() -> signal.modify((ValueModifier & Serializable)value -> {
            modifyStarted.release();
            modifyCanProceed.acquireUninterruptibly();
        }));
        modifyStarted.acquireUninterruptibly();
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.get());
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.peek());
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.set((Object)"update"));
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.replace((Object)"foo", (Object)"bar"));
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.update((SignalUpdater & Serializable)x -> x));
        Assertions.assertThrows(ConcurrentModificationException.class, () -> signal.modify((ValueModifier & Serializable)x -> {}));
        modifyCanProceed.release();
    }

    @Test
    void transactions_readSignalInTransaction_throws() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        Assertions.assertThrows(IllegalStateException.class, () -> Signal.runInTransaction((TransactionTask & Serializable)() -> signal.get()));
    }

    @Test
    void transactions_writeSignalInTransaction_throws() {
        ValueSignal signal = new ValueSignal((Object)"initial");
        Assertions.assertThrows(IllegalStateException.class, () -> Signal.runInTransaction((TransactionTask & Serializable)() -> signal.set((Object)"update")));
    }

    private static void assertEventually(BooleanSupplier test) {
        for (int i = 0; i < 10; ++i) {
            if (test.getAsBoolean()) {
                return;
            }
            try {
                Thread.sleep(i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assertions.fail();
    }
}

