/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.FileDownloadHandler;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FileDownloadHandlerTest {
    private static final String PATH_TO_FILE = "downloads/generated_binary_file.bin";
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private VaadinService service;
    private DownloadEvent downloadEvent;
    private OutputStream outputStream;
    private Element owner;

    FileDownloadHandlerTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        UI ui = (UI)Mockito.mock(UI.class);
        ((UI)Mockito.doAnswer(invocation -> {
            Command command = (Command)invocation.getArgument(0);
            command.execute();
            return null;
        }).when((Object)ui)).access((Command)Mockito.any(Command.class));
        this.owner = (Element)Mockito.mock(Element.class);
        Component componentOwner = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.owner.getComponent()).thenReturn(Optional.of(componentOwner));
        Mockito.when((Object)componentOwner.getUI()).thenReturn(Optional.of(ui));
        this.downloadEvent = new DownloadEvent(this.request, this.response, this.session, this.owner);
        this.outputStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
    }

    @Test
    public void transferProgressListener_addListener_listenersInvoked() throws URISyntaxException, IOException {
        final ArrayList invocations = new ArrayList();
        final ArrayList transferredBytesRecords = new ArrayList();
        URL resource = this.getClass().getClassLoader().getResource(PATH_TO_FILE);
        FileDownloadHandler handler = DownloadHandler.forFile((File)new File(resource.toURI()), (String)"download", (TransferProgressListener)new TransferProgressListener(){

            public void onStart(TransferContext context) {
                Assertions.assertEquals((long)165000L, (long)context.contentLength());
                Assertions.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                transferredBytesRecords.add(transferredBytes);
                Assertions.assertEquals((long)165000L, (long)totalBytes);
                Assertions.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                Assertions.assertEquals((long)165000L, (long)context.contentLength());
                Assertions.assertEquals((long)165000L, (long)transferredBytes);
                Assertions.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
            }
        });
        handler.handleDownloadRequest(this.downloadEvent);
        Assertions.assertEquals(List.of("onStart", "onProgress", "onProgress", "onComplete"), invocations);
        Assertions.assertArrayEquals((long[])new long[]{65536L, 131072L}, (long[])transferredBytesRecords.stream().mapToLong(Long::longValue).toArray());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/octet-stream");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentLengthLong(165000L);
        Assertions.assertNull((Object)this.downloadEvent.getException());
    }

    @Test
    public void transferProgressListener_addListener_errorOccured_errorlistenerInvoked() throws URISyntaxException {
        final ArrayList invocations = new ArrayList();
        FileDownloadHandler handler = DownloadHandler.forFile((File)new File("non-existing-file"), (String)"download", (TransferProgressListener)new TransferProgressListener(){

            public void onStart(TransferContext context) {
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
                String expectedMessage = "non-existing-file (No such file or directory)";
                if (FrontendUtils.isWindows()) {
                    expectedMessage = "non-existing-file (The system cannot find the file specified)";
                }
                Assertions.assertEquals((Object)expectedMessage, (Object)reason.getMessage());
                Assertions.assertNotNull((Object)context.exception());
                Assertions.assertEquals(FileNotFoundException.class, context.exception().getClass());
            }
        });
        try {
            handler.handleDownloadRequest(this.downloadEvent);
            Assertions.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals(List.of("onError"), invocations);
        Assertions.assertNotNull((Object)this.downloadEvent.getException());
        Assertions.assertEquals(FileNotFoundException.class, this.downloadEvent.getException().getClass());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(500);
    }

    @Test
    public void inline_setFileNameInvokedByDefault() throws IOException, URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource(PATH_TO_FILE);
        FileDownloadHandler handler = DownloadHandler.forFile((File)new File(resource.toURI()), (String)"my-download.bin");
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event);
        ((DownloadEvent)Mockito.verify((Object)event)).setFileName("my-download.bin");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentType("application/octet-stream");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentLength(165000L);
    }

    @Test
    public void attachment_doesNotSetFileNameWhenInlined() throws IOException, URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource(PATH_TO_FILE);
        AbstractDownloadHandler handler = DownloadHandler.forFile((File)new File(resource.toURI()), (String)"my-download.bin").inline();
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event);
        ((DownloadEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)0))).setFileName("my-download.bin");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentType("application/octet-stream");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentLength(165000L);
    }

    @Test
    public void handleSetToInline_contentDispositionIsInlineWithFilename() throws IOException, URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource(PATH_TO_FILE);
        AbstractDownloadHandler handler = DownloadHandler.forFile((File)new File(resource.toURI()), (String)"my-download.bin").inline();
        DownloadEvent event = new DownloadEvent(this.request, this.response, this.session, new Element("t"));
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline; filename=\"my-download.bin\"");
    }
}

