/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.experimental.CoreFeatureFlagProvider;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.DefaultApplicationConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class DefaultApplicationConfigurationFactoryTest {
    @Rule
    @TempDir
    Path temporaryFolder;

    DefaultApplicationConfigurationFactoryTest() {
    }

    @Test
    public void create_tokenFileIsReadFromClassloader_externalStatsFileIsReadFromTokenFile_predefinedContext() throws MalformedURLException, IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        ResourceProvider resourceProvider = this.mockResourceProvider(config, context);
        String content = "{ \"externalStatsFile\":true }";
        this.mockClassPathTokenFile(resourceProvider, content);
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        ArrayList propertyNames = Collections.list(configuration.getPropertyNames());
        Assertions.assertTrue((boolean)propertyNames.contains("external.stats.file"));
        Assertions.assertTrue((boolean)configuration.getBooleanProperty("external.stats.file", false));
        Assertions.assertFalse((boolean)configuration.isProductionMode());
    }

    @Test
    public void create_tokenFileIsSetViaContext_externalStatsFileIsReadFromTokenFile_predefinedContext() throws MalformedURLException, IOException {
        String content = "{ \"externalStatsFile\":true }";
        VaadinContext context = this.mockTokenFileViaContextParam(content);
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        ArrayList propertyNames = Collections.list(configuration.getPropertyNames());
        Assertions.assertTrue((boolean)propertyNames.contains("external.stats.file"));
        Assertions.assertTrue((boolean)configuration.getBooleanProperty("external.stats.file", false));
        Assertions.assertFalse((boolean)configuration.isProductionMode());
    }

    @Test
    public void create_tokenFileIsSetViaContext_externalStatsUrlIsReadFromTokenFile_predefinedContext() throws MalformedURLException, IOException {
        String content = "{ \"externalStatsUrl\": \"http://my.server/static/stats.json\"}";
        VaadinContext context = this.mockTokenFileViaContextParam(content);
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        ArrayList propertyNames = Collections.list(configuration.getPropertyNames());
        Assertions.assertTrue((boolean)propertyNames.contains("external.stats.url"));
        Assertions.assertTrue((boolean)configuration.getBooleanProperty("external.stats.file", false));
        Assertions.assertEquals((Object)"http://my.server/static/stats.json", (Object)configuration.getStringProperty("external.stats.url", null));
        Assertions.assertFalse((boolean)configuration.isProductionMode());
    }

    @Test
    public void create_tokenFileIsReadFromClassloader_externalStatsUrlIsReadFromTokenFile_predefinedContext() throws IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        ResourceProvider resourceProvider = this.mockResourceProvider(config, context);
        this.mockClassPathTokenFile(resourceProvider, "{ \"externalStatsUrl\": \"http://my.server/static/stats.json\"}");
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        ArrayList propertyNames = Collections.list(configuration.getPropertyNames());
        Assertions.assertTrue((boolean)propertyNames.contains("external.stats.url"));
        Assertions.assertTrue((boolean)configuration.getBooleanProperty("external.stats.file", false));
        Assertions.assertEquals((Object)"http://my.server/static/stats.json", (Object)configuration.getStringProperty("external.stats.url", null));
        Assertions.assertFalse((boolean)configuration.isProductionMode());
    }

    @Test
    public void create_propertiesAreReadFromContext() throws IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        ResourceProvider resourceProvider = this.mockResourceProvider(config, context);
        Mockito.when((Object)context.getContextParameterNames()).thenReturn(Collections.enumeration(Collections.singleton("foo")));
        Mockito.when((Object)context.getContextParameter("foo")).thenReturn((Object)"bar");
        this.mockClassPathTokenFile(resourceProvider, "{}");
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        ArrayList propertyNames = Collections.list(configuration.getPropertyNames());
        Assertions.assertEquals((int)1, (int)propertyNames.size());
        Assertions.assertEquals((Object)"foo", propertyNames.get(0));
        Assertions.assertEquals((Object)"bar", (Object)configuration.getStringProperty("foo", null));
    }

    @Test
    public void create_tokenFileWithPremiumFlag_premiumFlagIsPropagatedToDeploymentConfiguration() throws IOException {
        this.assertTokenAttributeIsPropagatedToDeploymentConfiguration("premiumFeatures.enable", true);
    }

    @Test
    public void create_tokenFileWithCommercialBannerFlag_commercialBannerFlagIsPropagatedToDeploymentConfiguration() throws IOException {
        this.assertTokenAttributeIsPropagatedToDeploymentConfiguration("commercialBanner.enable", true);
    }

    @Test
    public void getMode_returnsLivereload_tailwindCssIsEnabled() throws IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        ResourceProvider resourceProvider = this.mockResourceProvider(config, context);
        this.mockClassPathTokenFile(resourceProvider, "{}");
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        FeatureFlags featureFlags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        try (MockedStatic flags = Mockito.mockStatic(FeatureFlags.class);){
            flags.when(() -> FeatureFlags.get((VaadinContext)context)).thenReturn((Object)featureFlags);
            Assertions.assertEquals((Object)Mode.DEVELOPMENT_BUNDLE, (Object)configuration.getMode(), (String)"Should have bundle mode by default");
            Mockito.when((Object)featureFlags.isEnabled(CoreFeatureFlagProvider.TAILWIND_CSS)).thenReturn((Object)true);
            Assertions.assertEquals((Object)Mode.DEVELOPMENT_FRONTEND_LIVERELOAD, (Object)configuration.getMode(), (String)"Should have livereload mode when TailwindCSS is enabled");
        }
    }

    private void assertTokenAttributeIsPropagatedToDeploymentConfiguration(String attributeName, Object value) throws IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        ResourceProvider resourceProvider = this.mockResourceProvider(config, context);
        String content = JacksonUtils.mapToJson(Map.of(attributeName, value)).toString();
        this.mockClassPathTokenFile(resourceProvider, content);
        DefaultApplicationConfigurationFactory factory = new DefaultApplicationConfigurationFactory();
        ApplicationConfiguration configuration = factory.create(context);
        ArrayList propertyNames = Collections.list(configuration.getPropertyNames());
        Assertions.assertTrue((boolean)propertyNames.contains(attributeName));
        if (value instanceof Boolean) {
            Assertions.assertTrue((boolean)configuration.getBooleanProperty(attributeName, false));
        } else {
            Assertions.assertEquals((Object)configuration.getStringProperty(attributeName, null), (Object)value.toString());
        }
    }

    private void mockClassPathTokenFile(ResourceProvider resourceProvider, String content) throws IOException, MalformedURLException {
        String path = "META-INF/VAADIN/config/flow-build-info.json";
        final File tmpFile = Files.createTempFile(this.temporaryFolder, "tmp", null, new FileAttribute[0]).toFile();
        Files.write(tmpFile.toPath(), Collections.singletonList(content), new OpenOption[0]);
        URLStreamHandler handler = new URLStreamHandler(this){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return tmpFile.toURI().toURL().openConnection();
            }
        };
        URL url = new URL("file", "", -1, "foo.jar!/" + path, handler);
        Mockito.when((Object)resourceProvider.getApplicationResources(path)).thenReturn(Collections.singletonList(url));
    }

    private ResourceProvider mockResourceProvider(VaadinConfig config, VaadinContext context) {
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getContextParameterNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)config.getConfigParameterNames()).thenReturn(Collections.emptyEnumeration());
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)((ApplicationConfiguration)context.getAttribute(ApplicationConfiguration.class))).thenReturn((Object)appConfig);
        Mockito.when((Object)((ApplicationConfiguration)context.getAttribute((Class)Mockito.eq(ApplicationConfiguration.class), (Supplier)Mockito.any()))).thenReturn((Object)appConfig);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        ResourceProvider resourceProvider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Mockito.when((Object)((ResourceProvider)lookup.lookup(ResourceProvider.class))).thenReturn((Object)resourceProvider);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        return resourceProvider;
    }

    private VaadinContext mockTokenFileViaContextParam(String content) throws IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)context.getContextParameterNames()).thenReturn(Collections.enumeration(Collections.singleton("vaadin.frontend.token.file")));
        File tmpFile = Files.createTempFile(this.temporaryFolder, "tmp", null, new FileAttribute[0]).toFile();
        Files.write(tmpFile.toPath(), Collections.singletonList(content), new OpenOption[0]);
        Mockito.when((Object)context.getContextParameter("vaadin.frontend.token.file")).thenReturn((Object)tmpFile.getPath());
        return context;
    }
}

