/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.StringToNumberDecoder;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringToNumberDecoderTest {
    private StringToNumberDecoder decoder = new StringToNumberDecoder();

    StringToNumberDecoderTest() {
    }

    @Test
    public void isApplicable_applicableToStringAndNumber() {
        Assertions.assertTrue((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), Number.class));
    }

    @Test
    public void isApplicable_notApplicableToBooleanAndNumber() {
        Assertions.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)true), Number.class));
    }

    @Test
    public void isApplicable_notApplicableToStringAndString() {
        Assertions.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), String.class));
    }

    @Test
    public void isApplicable_notApplicableToStringAndAtomicInteger() {
        Assertions.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), AtomicInteger.class));
    }

    @Test
    public void isApplicable_applicableToStringAndLong() {
        Assertions.assertTrue((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), Long.class));
    }

    @Test
    public void stringToInteger_convertableString_valueIsConverted() throws RpcDecodeException {
        Integer expected = 37;
        Integer value = (Integer)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Integer.class);
        Assertions.assertEquals((Integer)expected, (Integer)value);
    }

    @Test
    public void stringToInteger_nonConvertableString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"abc"), Integer.class));
    }

    @Test
    public void stringToInteger_doubleString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"4.2"), Integer.class));
    }

    @Test
    public void stringToInteger_longString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(Long.MAX_VALUE)), Integer.class));
    }

    @Test
    public void stringToLong_convertableString_valueIsConverted() throws RpcDecodeException {
        Long expected = 37L;
        Long value = (Long)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Long.class);
        Assertions.assertEquals((Long)expected, (Long)value);
    }

    @Test
    public void stringToLong_nonConvertableString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"abc"), Long.class));
    }

    @Test
    public void stringToLong_doubleString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"4.2"), Long.class));
    }

    @Test
    public void stringToShort_convertableString_valueIsConverted() throws RpcDecodeException {
        Short expected = 37;
        Short value = (Short)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Short.class);
        Assertions.assertEquals((Short)expected, (Short)value);
    }

    @Test
    public void stringToShort_nonConvertableString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"abc"), Short.class));
    }

    @Test
    public void stringToShort_intString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)Integer.MAX_VALUE), Short.class));
    }

    @Test
    public void stringToShort_doubleString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"4.2"), Short.class));
    }

    @Test
    public void stringToByte_convertableString_valueIsConverted() throws RpcDecodeException {
        Byte expected = 37;
        Byte value = (Byte)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Byte.class);
        Assertions.assertEquals((Byte)expected, (Byte)value);
    }

    @Test
    public void stringToByte_nonConvertableString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"abc"), Byte.class));
    }

    @Test
    public void stringToByte_intString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)Short.MAX_VALUE), Byte.class));
    }

    @Test
    public void stringToByte_doubleString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"4.2"), Byte.class));
    }

    @Test
    public void stringToFloat_convertableString_valueIsConverted() throws RpcDecodeException {
        Float expected = Float.valueOf(37.72f);
        Float value = (Float)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Float.class);
        Assertions.assertEquals((Float)expected, (Float)value);
    }

    @Test
    public void stringToFloat_doubleString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(Double.MIN_NORMAL)), Float.class));
    }

    @Test
    public void stringToFloat_nonConvertableString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"abc"), Float.class));
    }

    @Test
    public void stringToDouble_convertableString_valueIsConverted() throws RpcDecodeException {
        Double expected = 823.6349;
        Double value = (Double)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Double.class);
        Assertions.assertEquals((Double)expected, (Double)value);
    }

    @Test
    public void stringToDouble_minDoubleString_valueIsConverted() throws RpcDecodeException {
        Double expected = Double.MIN_NORMAL;
        Double value = (Double)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Double.class);
        Assertions.assertEquals((Double)expected, (Double)value);
    }

    @Test
    public void stringToDoublet_nonConvertableString_exceptionIsThrown() throws RpcDecodeException {
        Assertions.assertThrows(RpcDecodeException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"abc"), Double.class));
    }

    @Test
    public void stringToNumber_convertableString_valueIsConverted() throws RpcDecodeException {
        Double expected = 823.6349;
        Number value = (Number)this.decoder.decode(JacksonUtils.createNode((Object)String.valueOf(expected)), Number.class);
        Assertions.assertEquals((Object)expected, (Object)value);
    }
}

