/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.communication.AtmospherePushConnection;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FragmentedMessageTest {
    FragmentedMessageTest() {
    }

    @Test
    public void shortMessageCompleteImmediately() throws IOException {
        AtmospherePushConnection.FragmentedMessage msg = new AtmospherePushConnection.FragmentedMessage();
        Assertions.assertTrue((boolean)msg.append((Reader)new StringReader("Hello".length() + "|Hello")));
        Assertions.assertEquals((Object)"Hello", (Object)IOUtils.toString((Reader)msg.getReader()));
    }

    @Test
    public void longMessageConcatenated() throws IOException {
        AtmospherePushConnection.FragmentedMessage msg = new AtmospherePushConnection.FragmentedMessage();
        String text = "HelloWorld".repeat(1700);
        String textWithLength = text.length() + "|" + text;
        String part1 = textWithLength.substring(0, 16384);
        String part2 = textWithLength.substring(16384);
        Assertions.assertEquals((int)16384, (int)part1.length());
        Assertions.assertEquals((int)(textWithLength.length() - 16384), (int)part2.length());
        StringReader messageReader = new StringReader(part1);
        Assertions.assertFalse((boolean)msg.append((Reader)messageReader));
        StringReader messageReader2 = new StringReader(part2);
        Assertions.assertTrue((boolean)msg.append((Reader)messageReader2));
        Assertions.assertEquals((Object)text, (Object)IOUtils.toString((Reader)msg.getReader()));
    }

    @Test
    public void lengthEqualsLimitHandledCorrectly() throws IOException {
        AtmospherePushConnection.FragmentedMessage msg = new AtmospherePushConnection.FragmentedMessage();
        int length = 16384 - String.valueOf(16384).length() - 1;
        String text = "A".repeat(length);
        String textWithLength = length + "|" + text;
        Assertions.assertEquals((int)16384, (int)textWithLength.length());
        StringReader messageReader = new StringReader(textWithLength);
        Assertions.assertTrue((boolean)msg.append((Reader)messageReader));
        Assertions.assertEquals((Object)text, (Object)IOUtils.toString((Reader)msg.getReader()));
    }
}

