/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.InvalidMenuAccessControlException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.CustomMenuAccessControl;
import com.vaadin.flow.server.auth.DefaultMenuAccessControl;
import com.vaadin.flow.server.auth.MenuAccessControl;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;

@NotThreadSafe
class DefaultInstantiatorMenuAccessControlTest {
    private ClassLoader contextClassLoader;
    private ClassLoader classLoader;

    DefaultInstantiatorMenuAccessControlTest() {
    }

    @BeforeEach
    public void init() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        DefaultInstantiatorMenuAccessControlTest.clearMenuAccessControlField();
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.classLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when(this.classLoader.loadClass((String)Mockito.any())).thenAnswer(AdditionalAnswers.delegatesTo((Object)this.contextClassLoader));
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    @AfterEach
    public void destroy() throws NoSuchFieldException, IllegalAccessException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
    }

    @Test
    public void defaultInstantiator_getMenuAccessControl_defaultMenuAccessControl() throws ClassNotFoundException {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service);
        MenuAccessControl menuAccessControl = defaultInstantiator.getMenuAccessControl();
        Assertions.assertNotNull((Object)menuAccessControl);
        Assertions.assertTrue((boolean)(menuAccessControl instanceof DefaultMenuAccessControl));
        Assertions.assertSame((Object)menuAccessControl.getPopulateClientSideMenu(), (Object)MenuAccessControl.PopulateClientMenu.AUTOMATIC);
    }

    @Test
    public void defaultInstantiator_getMenuAccessControl_customMenuAccessControl() throws ClassNotFoundException {
        final String customMenuAccessControlClassName = "com.vaadin.flow.server.auth.CustomMenuAccessControl";
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service){

            protected String getInitProperty(String propertyName) {
                return customMenuAccessControlClassName;
            }
        };
        MenuAccessControl menuAccessControl = defaultInstantiator.getMenuAccessControl();
        Assertions.assertNotNull((Object)menuAccessControl);
        Assertions.assertTrue((boolean)(menuAccessControl instanceof CustomMenuAccessControl));
        Assertions.assertSame((Object)menuAccessControl.getPopulateClientSideMenu(), (Object)MenuAccessControl.PopulateClientMenu.ALWAYS);
        ((ClassLoader)Mockito.verify((Object)this.classLoader)).loadClass(customMenuAccessControlClassName);
    }

    @Test
    public void defaultInstantiator_getMenuAccessControlWithInvalidType_throwException() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service){

            protected String getInitProperty(String propertyName) {
                return "com.vaadin.flow.server.auth.InvalidMenuAccessControl";
            }
        };
        String errorMessage = ((InvalidMenuAccessControlException)Assertions.assertThrows(InvalidMenuAccessControlException.class, () -> defaultInstantiator.getMenuAccessControl())).getMessage();
        Assertions.assertEquals((Object)("Menu access control implementation class property 'menu.access.control' is set to 'com.vaadin.flow.server.auth.InvalidMenuAccessControl' but it's not " + MenuAccessControl.class.getSimpleName() + " implementation"), (Object)errorMessage);
    }

    public static void clearMenuAccessControlField() throws NoSuchFieldException, IllegalAccessException {
        Field field = DefaultInstantiator.class.getDeclaredField("menuAccessControl");
        field.setAccessible(true);
        ((AtomicReference)field.get(null)).set(null);
        field.setAccessible(false);
    }

    private Lookup mockLookup(VaadinService service) {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        return lookup;
    }
}

