/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.DevToolsToken;
import com.vaadin.flow.server.VaadinService;
import java.lang.reflect.Field;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class DevToolsTokenTest {
    @Rule
    public TemporaryFolder projectFolder = new TemporaryFolder();
    private VaadinService service;
    private DeploymentConfiguration configuration;
    private String initialToken;
    private String systemTempDir;

    @Before
    public void setUp() throws Exception {
        this.configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)this.configuration.getProjectFolder()).thenReturn((Object)this.projectFolder.getRoot());
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        this.initialToken = DevToolsToken.getToken();
        this.systemTempDir = System.getProperty("java.io.tmpdir");
        System.setProperty("java.io.tmpdir", this.projectFolder.getRoot().getAbsolutePath());
    }

    @After
    public void tearDown() {
        this.overwriteToken(this.initialToken);
        System.setProperty("java.io.tmpdir", this.systemTempDir);
    }

    @Test
    public void init_tokenFileNotExising_createTokenFile() {
        DevToolsToken.init((VaadinService)this.service);
        Assert.assertEquals((Object)this.initialToken, (Object)DevToolsToken.getToken());
        this.overwriteToken("EMPTY");
        DevToolsToken.init((VaadinService)this.service);
        Assert.assertEquals((Object)this.initialToken, (Object)DevToolsToken.getToken());
    }

    @Test
    public void init_nullProjectFolder_useInMemoryToken() {
        Mockito.when((Object)this.configuration.getProjectFolder()).thenReturn(null);
        String testToken = UUID.randomUUID().toString();
        this.overwriteToken(testToken);
        DevToolsToken.init((VaadinService)this.service);
        Assert.assertEquals((Object)testToken, (Object)DevToolsToken.getToken());
    }

    private void overwriteToken(String token) {
        try {
            ReflectTools.setJavaFieldValue(null, (Field)DevToolsToken.class.getDeclaredField("randomDevToolsToken"), (Object)token);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

