/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.internal.PathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PathUtilTest {
    @Test
    public void methods_output_expected_values() {
        List<String> segments = Arrays.asList("path", "to", "foo");
        String path = "path/to/foo";
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.getPath(segments));
        Assert.assertEquals((String)"Unexpected result", (Object)"", (Object)PathUtil.getPath(null));
        Assert.assertEquals((String)"Unexpected result", (Object)"", (Object)PathUtil.getPath(Collections.emptyList()));
        Assert.assertEquals((String)"Unexpected result", (Object)"prefix/path/to/foo", (Object)PathUtil.getPath((String)"prefix", segments));
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.getPath((String)"", segments));
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.getPath(null, segments));
        Assert.assertEquals((String)"Unexpected result", segments, (Object)PathUtil.getSegmentsList((String)"path/to/foo"));
        Assert.assertEquals((String)"Unexpected result", segments, (Object)PathUtil.getSegmentsList((String)"path/to/foo/"));
        ArrayList<String> emptyStartSegment = new ArrayList<String>();
        emptyStartSegment.add("");
        emptyStartSegment.addAll(segments);
        Assert.assertEquals((String)"Unexpected result", emptyStartSegment, (Object)PathUtil.getSegmentsList((String)"/path/to/foo"));
        Assert.assertEquals((String)"Unexpected result", emptyStartSegment, (Object)PathUtil.getSegmentsList((String)"/path/to/foo/"));
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.trimPath((String)"path/to/foo"));
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.trimPath((String)"/path/to/foo"));
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.trimPath((String)"path/to/foo/"));
        Assert.assertEquals((String)"Unexpected result", (Object)"path/to/foo", (Object)PathUtil.trimPath((String)"/path/to/foo/"));
    }

    @Test
    public void getSegmentsListWithDecoding_decodesEncodedSlashes() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"path%2Fwith%2Fslashes");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Should decode %2F to /", (Object)"path/with/slashes", segments.get(0));
    }

    @Test
    public void getSegmentsListWithDecoding_decodesSpaces() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"hello%20world");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Should decode %20 to space", (Object)"hello world", segments.get(0));
    }

    @Test
    public void getSegmentsListWithDecoding_decodesSpecialCharacters() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"test%3Fquestion/value%26data");
        Assert.assertEquals((String)"Should have two segments", (long)2L, (long)segments.size());
        Assert.assertEquals((String)"Should decode %3F to ?", (Object)"test?question", segments.get(0));
        Assert.assertEquals((String)"Should decode %26 to &", (Object)"value&data", segments.get(1));
    }

    @Test
    public void getSegmentsListWithDecoding_decodesPlus() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"a%2Bb/c%2Bd");
        Assert.assertEquals((String)"Should have two segments", (long)2L, (long)segments.size());
        Assert.assertEquals((String)"Should decode %2B to +", (Object)"a+b", segments.get(0));
        Assert.assertEquals((String)"Should decode %2B to +", (Object)"c+d", segments.get(1));
    }

    @Test
    public void getSegmentsListWithDecoding_decodesHash() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"item%23123");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Should decode %23 to #", (Object)"item#123", segments.get(0));
    }

    @Test
    public void getSegmentsListWithDecoding_decodesPercent() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"50%25off");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Should decode %25 to %", (Object)"50%off", segments.get(0));
    }

    @Test
    public void getSegmentsListWithDecoding_handlesMultipleEncodedSegments() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"path%2Fwith%2Fslashes/normal/another%2Fencoded");
        Assert.assertEquals((String)"Should have three segments", (long)3L, (long)segments.size());
        Assert.assertEquals((String)"First segment should be decoded", (Object)"path/with/slashes", segments.get(0));
        Assert.assertEquals((String)"Second segment should be normal", (Object)"normal", segments.get(1));
        Assert.assertEquals((String)"Third segment should be decoded", (Object)"another/encoded", segments.get(2));
    }

    @Test
    public void getSegmentsListWithDecoding_handlesEmptyPath() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"");
        Assert.assertTrue((String)"Empty path should return empty list", (boolean)segments.isEmpty());
    }

    @Test
    public void getSegmentsListWithDecoding_handlesNullPath() {
        List segments = PathUtil.getSegmentsListWithDecoding(null);
        Assert.assertTrue((String)"Null path should return empty list", (boolean)segments.isEmpty());
    }

    @Test
    public void getSegmentsListWithDecoding_handlesLeadingSlash() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"/path%2Fencoded/normal");
        Assert.assertEquals((String)"Should have three segments", (long)3L, (long)segments.size());
        Assert.assertEquals((String)"First segment should be empty", (Object)"", segments.get(0));
        Assert.assertEquals((String)"Second segment should be decoded", (Object)"path/encoded", segments.get(1));
        Assert.assertEquals((String)"Third segment should be normal", (Object)"normal", segments.get(2));
    }

    @Test
    public void getSegmentsListWithDecoding_handlesTrailingSlash() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"path%2Fencoded/");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Segment should be decoded", (Object)"path/encoded", segments.get(0));
    }

    @Test
    public void getSegmentsListWithDecoding_handlesUtf8Characters() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"hello%C3%A4%C3%B6%C3%BC");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Should decode UTF-8 characters", (Object)"hello\u00e4\u00f6\u00fc", segments.get(0));
    }

    @Test
    public void getSegmentsList_doesNotDecode() {
        List segments = PathUtil.getSegmentsList((String)"path%2Fwith%2Fslashes");
        Assert.assertEquals((String)"Should have one segment", (long)1L, (long)segments.size());
        Assert.assertEquals((String)"Should NOT decode %2F", (Object)"path%2Fwith%2Fslashes", segments.get(0));
    }
}

