/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ConfigureRoutesTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void mutableConfiguration_canSetRouteTarget() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        Assert.assertTrue((String)"Configuration should have \"\" route registered", (boolean)mutable.hasTemplate(""));
        Assert.assertEquals((String)"Configuration should have registered base target.", BaseTarget.class, mutable.getTarget("").get());
    }

    @Test
    public void mutableConfiguration_canSetTargetRoute() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        Assert.assertTrue((String)"", (boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assert.assertEquals((String)"Configuration should have registered base target.", (Object)"", (Object)mutable.getTemplate(BaseTarget.class));
    }

    @Test
    public void mutableConfigurationClear_removesRegisteredRoutes() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        this.assertSetRoutes(mutable);
        mutable.clear();
        Assert.assertFalse((boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assert.assertFalse((boolean)mutable.hasRouteTarget(ParamTarget.class));
        Assert.assertNull((Object)mutable.getNavigationRouteTarget("").getRouteTarget());
        Assert.assertNull((Object)mutable.getNavigationRouteTarget("123").getRouteTarget());
        this.assertSetRoutes(mutable);
    }

    @Test
    public void mutableConfigurationClear_preservesErrorRoute() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setErrorRoute(IndexOutOfBoundsException.class, BaseError.class);
        mutable.clear();
        Assert.assertEquals((String)"ErrorRoute shouldn't be cleared.", BaseError.class, (Object)mutable.getExceptionHandlerByClass(IndexOutOfBoundsException.class));
    }

    @Test
    public void duplicateRootPathRegistration_throwsException() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        Assert.assertTrue((boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assert.assertEquals(BaseTarget.class, (Object)mutable.getNavigationRouteTarget("").getRouteTarget().getTarget());
        this.exceptionRule.expect(AmbiguousRouteConfigurationException.class);
        this.exceptionRule.reportMissingExceptionWithMessage("Duplicate routes shouldn't be accepted.");
        this.exceptionRule.expectMessage(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", "com.vaadin.flow.router.internal.ConfigureRoutesTest$BaseTarget", "com.vaadin.flow.router.internal.ConfigureRoutesTest$BaseTarget"));
        mutable.setRoute("", BaseTarget.class);
    }

    @Test
    public void duplicateParameterPathRegistration_throwsException() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute(":param", ParamTarget.class);
        Assert.assertTrue((boolean)mutable.hasRouteTarget(ParamTarget.class));
        Assert.assertEquals(ParamTarget.class, (Object)mutable.getNavigationRouteTarget("123").getRouteTarget().getTarget());
        this.exceptionRule.expect(AmbiguousRouteConfigurationException.class);
        this.exceptionRule.reportMissingExceptionWithMessage("Duplicate parameter routes shouldn't be accepted.");
        this.exceptionRule.expectMessage(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' with parameter having the same route.", "com.vaadin.flow.router.internal.ConfigureRoutesTest$ParamTarget", "com.vaadin.flow.router.internal.ConfigureRoutesTest$ParamTarget"));
        mutable.setRoute(":param", ParamTarget.class);
    }

    @Test
    public void mutableConfiguration_makingImmutableHasCorrectData() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        ConfiguredRoutes immutable = new ConfiguredRoutes(mutable);
        Assert.assertTrue((String)"Configuration should have \"\" route registered", (boolean)immutable.hasTemplate(""));
        Assert.assertEquals((String)"Configuration should have registered base target.", BaseTarget.class, immutable.getTarget("").get());
        Assert.assertTrue((String)"", (boolean)immutable.hasRouteTarget(BaseTarget.class));
        Assert.assertEquals((String)"Configuration should have registered base target.", (Object)"", (Object)immutable.getTemplate(BaseTarget.class));
    }

    @Test
    public void mutableConfiguration_canSetErrorTargets() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setErrorRoute(IndexOutOfBoundsException.class, BaseError.class);
        Assert.assertFalse((String)"Exception targets should be available", (boolean)mutable.getExceptionHandlers().isEmpty());
        Assert.assertEquals((String)"Given exception returned unexpected handler class", BaseError.class, (Object)mutable.getExceptionHandlerByClass(IndexOutOfBoundsException.class));
    }

    @Test
    public void populatedMutableConfiguration_clearRemovesAllContent() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        mutable.setErrorRoute(IndexOutOfBoundsException.class, BaseError.class);
        Assert.assertFalse((String)"Configuration should have routes.", (boolean)mutable.getRoutes().isEmpty());
        Assert.assertFalse((String)"Configuration should have exceptions.", (boolean)mutable.getExceptionHandlers().isEmpty());
        mutable.clear();
        Assert.assertTrue((String)"After clear all routes should have been removed.", (boolean)mutable.getRoutes().isEmpty());
        Assert.assertTrue((String)"After clear all targetRoutes should have been removed. ", (boolean)mutable.getTargetRoutes().isEmpty());
        Assert.assertFalse((String)"After clear  exception targets should still be available.", (boolean)mutable.getExceptionHandlers().isEmpty());
    }

    private void assertSetRoutes(ConfigureRoutes mutable) {
        mutable.setRoute("", BaseTarget.class);
        mutable.setRoute(":param", ParamTarget.class);
        Assert.assertTrue((boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assert.assertTrue((boolean)mutable.hasRouteTarget(ParamTarget.class));
        Assert.assertEquals(BaseTarget.class, (Object)mutable.getNavigationRouteTarget("").getRouteTarget().getTarget());
        Assert.assertEquals(ParamTarget.class, (Object)mutable.getNavigationRouteTarget("123").getRouteTarget().getTarget());
    }

    @Tag(value="div")
    public static class BaseTarget
    extends Component {
    }

    @Tag(value="div")
    public static class ParamTarget
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Tag(value="div")
    public static class BaseError
    extends Component
    implements HasErrorParameter<IndexOutOfBoundsException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<IndexOutOfBoundsException> parameter) {
            return 0;
        }
    }
}

