/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.ErrorParameter;
import org.junit.Assert;
import org.junit.Test;

public class ErrorParameterTest {
    @Test
    public void matchingExceptionType() {
        NullPointerException exception = new NullPointerException();
        ErrorParameter errorParameter = new ErrorParameter(NullPointerException.class, (Exception)exception);
        Assert.assertSame((Object)exception, (Object)errorParameter.getException());
        Assert.assertSame((Object)exception, (Object)errorParameter.getCaughtException());
    }

    @Test
    public void superExceptionType() {
        NullPointerException exception = new NullPointerException();
        ErrorParameter errorParameter = new ErrorParameter(RuntimeException.class, (Exception)exception);
        Assert.assertSame((Object)exception, (Object)errorParameter.getException());
        Assert.assertSame((Object)exception, (Object)errorParameter.getCaughtException());
    }

    @Test
    public void matchingCauseType() {
        NullPointerException cause = new NullPointerException();
        IllegalStateException exception = new IllegalStateException(cause);
        ErrorParameter errorParameter = new ErrorParameter(NullPointerException.class, (Exception)exception);
        Assert.assertSame((Object)cause, (Object)errorParameter.getException());
        Assert.assertSame((Object)exception, (Object)errorParameter.getCaughtException());
    }

    @Test
    public void superMatchingCauseType() {
        NullPointerException cause = new NullPointerException(){};
        IllegalStateException exception = new IllegalStateException(cause);
        ErrorParameter errorParameter = new ErrorParameter(NullPointerException.class, (Exception)exception);
        Assert.assertSame((Object)cause, (Object)errorParameter.getException());
        Assert.assertSame((Object)exception, (Object)errorParameter.getCaughtException());
    }
}

