/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.TestUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@NotThreadSafe
class CurrentInstanceTest {
    CurrentInstanceTest() {
    }

    @BeforeEach
    public void clearExistingThreadLocals() {
        CurrentInstance.clearAll();
    }

    @Test
    public void testInitiallyCleared() throws Exception {
        this.assertCleared();
    }

    @Test
    public void testClearedAfterRemove() throws Exception {
        CurrentInstance.set(CurrentInstanceTest.class, (Object)this);
        Assertions.assertEquals((Object)this, (Object)CurrentInstance.get(CurrentInstanceTest.class));
        CurrentInstance.set(CurrentInstanceTest.class, null);
        this.assertCleared();
    }

    @Test
    public void testClearedWithClearAll() throws Exception {
        CurrentInstance.set(CurrentInstanceTest.class, (Object)this);
        Assertions.assertEquals((Object)this, (Object)CurrentInstance.get(CurrentInstanceTest.class));
        CurrentInstance.clearAll();
        this.assertCleared();
    }

    private void assertCleared() throws SecurityException, NoSuchFieldException, IllegalAccessException {
        Assertions.assertNull(this.getInternalCurrentInstanceVariable().get());
    }

    private ThreadLocal<Map<Class<?>, CurrentInstance>> getInternalCurrentInstanceVariable() throws SecurityException, NoSuchFieldException, IllegalAccessException {
        Field f = CurrentInstance.class.getDeclaredField("instances");
        f.setAccessible(true);
        return (ThreadLocal)f.get(null);
    }

    public void testInheritedClearedAfterRemove() {
    }

    @Test
    public void testRestoringNullUIWorks() throws Exception {
        CurrentInstance.clearAll();
        Map old = CurrentInstance.setCurrent((UI)new UIStoredInCurrentInstance());
        CurrentInstance.restoreInstances((Map)old);
        Assertions.assertNull((Object)CurrentInstance.get(UI.class));
    }

    @Test
    public void testRestoringNullSessionWorks() throws Exception {
        CurrentInstance.clearAll();
        Map old = CurrentInstance.setCurrent((VaadinSession)new SessionStoredInCurrentInstance((VaadinService)new MockVaadinServletService()));
        CurrentInstance.restoreInstances((Map)old);
        Assertions.assertNull((Object)CurrentInstance.get(VaadinSession.class));
        Assertions.assertNull((Object)CurrentInstance.get(VaadinService.class));
    }

    @Test
    public void testRestoreWithGarbageCollectedValue() throws InterruptedException {
        VaadinSession session1 = new VaadinSession((VaadinService)new MockVaadinServletService()){

            public String toString() {
                return "First session";
            }
        };
        VaadinSession session2 = new VaadinSession((VaadinService)new MockVaadinServletService()){

            public String toString() {
                return "Second session";
            }
        };
        VaadinSession.setCurrent((VaadinSession)session1);
        Map previous = CurrentInstance.setCurrent((VaadinSession)session2);
        WeakReference<1> ref = new WeakReference<1>(session1);
        session1 = null;
        Assertions.assertTrue((boolean)TestUtil.isGarbageCollected(ref));
        CurrentInstance.restoreInstances((Map)previous);
        Assertions.assertNull((Object)VaadinSession.getCurrent());
    }

    @Test
    public void nonInheritableThreadLocals() throws InterruptedException, ExecutionException {
        CurrentInstance.clearAll();
        CurrentInstance.set(CurrentInstanceTest.class, (Object)this);
        Assertions.assertNotNull((Object)CurrentInstance.get(CurrentInstanceTest.class));
        Callable<Void> runnable = () -> {
            Assertions.assertNull((Object)CurrentInstance.get(CurrentInstanceTest.class));
            return null;
        };
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<Void> future = service.submit(runnable);
        future.get();
    }

    private static class UIStoredInCurrentInstance
    extends UI {
        private UIStoredInCurrentInstance() {
        }

        protected void init(VaadinRequest request) {
        }
    }

    private static class SessionStoredInCurrentInstance
    extends VaadinSession {
        public SessionStoredInCurrentInstance(VaadinService service) {
            super(service);
        }
    }
}

