/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HasComponentsTest {
    private static MockVaadinServletService service;

    @BeforeClass
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Test
    public void addStringToComponent() {
        String text = "Add text";
        TestComponent component = new TestComponent();
        component.add(text);
        Assert.assertEquals((Object)text, (Object)component.getElement().getText());
    }

    @Test
    public void insertComponentAtFirst() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-first");
        component.addComponentAsFirst(innerComponent);
        this.checkChildren(4, component);
        Assert.assertEquals((Object)innerComponent.getId(), (Object)((Component)component.getChildren().findFirst().get()).getId());
    }

    @Test
    public void insertComponentAtIndex() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-index");
        component.addComponentAtIndex(2, innerComponent);
        this.checkChildren(4, component);
        Assert.assertEquals((Object)innerComponent.getId(), (Object)((Component)component.getElement().getChild(2).getComponent().get()).getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void insertComponentIndexLessThanZero() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-index-less");
        component.addComponentAtIndex(-5, innerComponent);
    }

    @Test(expected=IllegalArgumentException.class)
    public void insertComponentIndexGreaterThanChildrenNumber() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-index-greater");
        component.addComponentAtIndex(100, innerComponent);
    }

    @Test
    public void remove_removeComponentWithNoParent() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        component.remove(new Component[]{innerComponent});
    }

    @Test
    public void remove_removeSeveralComponents_oneHasParent_nothingRemovedAndThrows() {
        TestComponent component = this.createTestStructure();
        TestComponent child = new TestComponent();
        component.add(new Component[]{child});
        TestComponent another = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        another.add(new Component[]{innerComponent});
        try {
            component.remove(new Component[]{child, innerComponent});
            Assert.fail();
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)((Object)component), child.getParent().get());
        }
    }

    @Test
    public void remove_removeSeveralComponents_oneHasNoParent_childIsRemoved() {
        TestComponent component = this.createTestStructure();
        TestComponent child = new TestComponent();
        component.add(new Component[]{child});
        TestComponent notAChild = new TestComponent();
        component.remove(new Component[]{notAChild, child});
        Assert.assertFalse((boolean)child.getParent().isPresent());
        Assert.assertFalse((boolean)component.getChildren().filter(comp -> comp.equals((Object)child)).findAny().isPresent());
    }

    @Test
    public void remove_removeComponentWithCorrectParent() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        long size = component.getChildren().count();
        component.add(new Component[]{innerComponent});
        component.remove(new Component[]{innerComponent});
        Assert.assertEquals((long)size, (long)component.getChildren().count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void remove_removeComponentWithDifferentParent() {
        TestComponent component = this.createTestStructure();
        TestComponent another = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        another.add(new Component[]{innerComponent});
        component.remove(new Component[]{innerComponent});
    }

    private TestComponent createTestStructure() {
        TestComponent component = new TestComponent();
        this.checkChildren(0, component);
        component.add(new Component[]{new TestComponent(), new TestComponent(), new TestComponent()});
        this.checkChildren(3, component);
        return component;
    }

    private void checkChildren(int number, TestComponent component) {
        Assert.assertEquals((long)number, (long)component.getChildren().count());
    }

    @Test
    public void bindChildren_addsChildrenFromListSignal() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        SharedListSignal items = new SharedListSignal(String.class);
        items.insertFirst((Object)"first");
        items.insertLast((Object)"second");
        items.insertLast((Object)"third");
        container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get()));
        Assert.assertEquals((long)3L, (long)container.getChildren().count());
        Assert.assertEquals((Object)"first", ((Component)container.getChildren().toList().get(0)).getId().orElse(null));
        Assert.assertEquals((Object)"second", ((Component)container.getChildren().toList().get(1)).getId().orElse(null));
        Assert.assertEquals((Object)"third", ((Component)container.getChildren().toList().get(2)).getId().orElse(null));
    }

    @Test
    public void bindChildren_updatesChildrenOnListChange() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        SharedListSignal items = new SharedListSignal(String.class);
        items.insertFirst((Object)"first");
        container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get()));
        Assert.assertEquals((long)1L, (long)container.getChildren().count());
        items.insertLast((Object)"second");
        Assert.assertEquals((long)2L, (long)container.getChildren().count());
        Assert.assertEquals((Object)"second", ((Component)container.getChildren().toList().get(1)).getId().orElse(null));
        items.remove((SharedValueSignal)((List)items.get()).get(0));
        Assert.assertEquals((long)1L, (long)container.getChildren().count());
        Assert.assertEquals((Object)"second", ((Component)container.getChildren().toList().get(0)).getId().orElse(null));
    }

    @Test
    public void bindChildren_removeBindingViaFeature_stopsUpdatesAndAllowsManualAddRemove() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        SharedListSignal items = new SharedListSignal(String.class);
        items.insertFirst((Object)"first");
        container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get()));
        Assert.assertEquals((long)1L, (long)container.getChildren().count());
        SignalBindingFeature feature = (SignalBindingFeature)container.getElement().getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("children");
        items.insertLast((Object)"second");
        Assert.assertEquals((long)1L, (long)container.getChildren().count());
        TestComponent newChild = new TestComponent("manual");
        container.add(new Component[]{newChild});
        Assert.assertEquals((long)2L, (long)container.getChildren().count());
        Component firstChild = (Component)container.getChildren().toList().get(0);
        container.remove(new Component[]{firstChild});
        Assert.assertEquals((long)1L, (long)container.getChildren().count());
    }

    @Test
    public void bindChildren_throwsIfContainerNotEmpty() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        container.add(new Component[]{new TestComponent("existing")});
        SharedListSignal items = new SharedListSignal(String.class);
        Assert.assertThrows(IllegalStateException.class, () -> container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get())));
    }

    @Test
    public void bindChildren_throwsIfBindingAlreadyExists() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        SharedListSignal items = new SharedListSignal(String.class);
        container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get()));
        SharedListSignal otherItems = new SharedListSignal(String.class);
        Assert.assertThrows(BindingActiveException.class, () -> container.bindChildren((Signal)otherItems, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get())));
    }

    @Test
    public void bindChildren_addThrowsWhileBindingActive() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        SharedListSignal items = new SharedListSignal(String.class);
        items.insertFirst((Object)"first");
        container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get()));
        Assert.assertThrows((String)"add should throw while binding is active", BindingActiveException.class, () -> container.add(new Component[]{new TestComponent("manual")}));
    }

    @Test
    public void bindChildren_removeThrowsWhileBindingActive() {
        CurrentInstance.clearAll();
        TestComponent container = new TestComponent();
        new MockUI().add(new Component[]{container});
        SharedListSignal items = new SharedListSignal(String.class);
        items.insertFirst((Object)"first");
        container.bindChildren((Signal)items, (SerializableFunction & Serializable)item -> new TestComponent((String)item.get()));
        Component child = (Component)container.getChildren().toList().get(0);
        Assert.assertThrows((String)"remove should throw while binding is active", BindingActiveException.class, () -> container.remove(new Component[]{child}));
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasComponents {
        public TestComponent() {
        }

        public TestComponent(String id) {
            this.setId(id);
        }
    }
}

