/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public sealed interface CommandResult
extends Serializable {
    public boolean accepted();

    public static Map<Id, CommandResult> rejectAll(Map<Id, CommandResult> results, String reason) {
        HashMap<Id, CommandResult> failed = new HashMap<Id, CommandResult>();
        results.forEach((key, original) -> {
            if (original instanceof Reject) {
                Reject failure = (Reject)original;
                failed.put((Id)key, failure);
            } else {
                failed.put((Id)key, CommandResult.fail(reason));
            }
        });
        return failed;
    }

    public static Accept ok() {
        return new Accept(Map.of(), Map.of());
    }

    public static Reject fail(String reason) {
        return new Reject(reason);
    }

    public static CommandResult conditional(boolean condition, String reasonIfFailed) {
        return condition ? CommandResult.ok() : CommandResult.fail(reasonIfFailed);
    }

    public record Accept(Map<Id, NodeModification> updates, Map<Id, SignalCommand.ScopeOwnerCommand> originalInserts) implements CommandResult
    {
        @Override
        public boolean accepted() {
            return true;
        }

        public NodeModification onlyUpdate() {
            assert (this.updates.size() == 1);
            return this.updates.values().iterator().next();
        }
    }

    public record Reject(String reason) implements CommandResult
    {
        @Override
        public boolean accepted() {
            return false;
        }
    }

    public record NodeModification(Node oldNode, Node newNode) {
    }
}

