/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlers;
import com.vaadin.flow.signals.shared.impl.MutableTreeRevision;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.Snapshot;
import java.util.List;
import java.util.Map;

public abstract class AsynchronousSignalTree
extends SignalTree {
    private final CommandsAndHandlers unconfirmedCommands = new CommandsAndHandlers();
    private Snapshot confirmed = new Snapshot(this.id(), true);
    private Snapshot submitted = new Snapshot(this.id(), true);

    protected AsynchronousSignalTree() {
        super(SignalTree.Type.ASYNCHRONOUS);
    }

    protected abstract void submit(List<SignalCommand> var1);

    public void confirm(List<SignalCommand> commands) {
        this.runWithLock(() -> {
            MutableTreeRevision builder = new MutableTreeRevision(this.confirmed);
            Map<Id, CommandResult> results = builder.applyAndGetResults(commands);
            this.confirmed = new Snapshot(builder);
            this.unconfirmedCommands.removeHandledCommands(results.keySet());
            Snapshot oldSubmitted = this.submitted;
            if (!this.unconfirmedCommands.isEmpty()) {
                builder.apply(this.unconfirmedCommands.getCommands());
                this.submitted = new Snapshot(builder);
            } else {
                this.submitted = this.confirmed;
            }
            this.notifyObservers(oldSubmitted, this.submitted);
            this.unconfirmedCommands.notifyResultHandlers(results, commands);
            this.notifyProcessedCommandSubscribers(commands, results);
        });
    }

    @Override
    public SignalTree.PendingCommit prepareCommit(final CommandsAndHandlers changes) {
        assert (this.hasLock());
        final Snapshot oldSnapshot = this.submitted;
        MutableTreeRevision builder = new MutableTreeRevision(this.submitted);
        builder.apply(changes.getCommands());
        final Snapshot newSnapshot = new Snapshot(builder);
        return new SignalTree.PendingCommit(){

            @Override
            public boolean canCommit() {
                assert (AsynchronousSignalTree.this.hasLock());
                return true;
            }

            @Override
            public void applyChanges() {
                assert (AsynchronousSignalTree.this.hasLock());
                AsynchronousSignalTree.this.unconfirmedCommands.add(changes);
                AsynchronousSignalTree.this.submitted = newSnapshot;
            }

            @Override
            public void publishChanges() {
                assert (AsynchronousSignalTree.this.hasLock());
                AsynchronousSignalTree.this.notifyObservers(oldSnapshot, newSnapshot);
                AsynchronousSignalTree.this.submit(changes.getCommands());
            }

            @Override
            public void markAsAborted() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Snapshot confirmed() {
        return this.getWithLock(() -> this.confirmed);
    }

    @Override
    public Snapshot submitted() {
        return this.getWithLock(() -> this.submitted);
    }
}

