/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.function.IntMapper;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class SharedNumberSignal
extends SharedValueSignal<Double> {
    public SharedNumberSignal() {
        super(0.0);
    }

    public SharedNumberSignal(double initialValue) {
        super(initialValue);
    }

    protected SharedNumberSignal(SignalTree tree, Id id, CommandValidator validator) {
        super(tree, id, validator, Double.class);
    }

    public SignalOperation<Double> incrementBy(double delta) {
        return this.submit(new SignalCommand.IncrementCommand(Id.random(), this.id(), delta), success -> SharedNumberSignal.nodeValue(success.onlyUpdate().newNode(), Double.class));
    }

    @Override
    public Double get() {
        Double value = (Double)super.get();
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public int valueAsInt() {
        return this.get().intValue();
    }

    @Override
    public SignalOperation<Double> set(int value) {
        return this.set(Double.valueOf(value));
    }

    public SharedNumberSignal withValidator(CommandValidator validator) {
        return new SharedNumberSignal(this.tree(), this.id(), this.mergeValidators(validator));
    }

    @Override
    public SharedNumberSignal asReadonly() {
        return this.withValidator(anything -> false);
    }

    public <C> Signal<C> mapIntValue(IntMapper<C> mapper) {
        return this.map(doubleValue -> mapper.apply(doubleValue.intValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedNumberSignal)) return false;
        SharedNumberSignal other = (SharedNumberSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator());
    }

    @Override
    public String toString() {
        return "SharedNumberSignal[" + String.valueOf(this.peek()) + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LoggerFactory.getLogger(SharedNumberSignal.class).warn("Serializing SharedNumberSignal. Sharing signals across a cluster is not yet implemented.");
        out.defaultWriteObject();
    }
}

