/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.operations.InsertOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class SharedListSignal<T>
extends AbstractSignal<List<SharedValueSignal<T>>> {
    private final Class<T> elementType;

    public SharedListSignal(Class<T> elementType) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, elementType);
    }

    protected SharedListSignal(SignalTree tree, Id id, CommandValidator validator, Class<T> elementType) {
        super(tree, id, validator);
        this.elementType = Objects.requireNonNull(elementType);
    }

    private SharedValueSignal<T> child(Id childId) {
        return new SharedValueSignal<T>(this.tree(), childId, this.validator(), this.elementType);
    }

    @Override
    protected List<SharedValueSignal<T>> extractValue(Node.Data data) {
        if (data == null) {
            return List.of();
        }
        return SharedListSignal.children(data, this::child);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.listChildren();
    }

    public InsertOperation<SharedValueSignal<T>> insertFirst(T value) {
        return this.insertAt(value, ListPosition.first());
    }

    static <T extends Signal<?>> List<T> children(Node.Data node, SerializableFunction<Id, T> factory) {
        return node.listChildren().stream().map(factory).toList();
    }

    public InsertOperation<SharedValueSignal<T>> insertLast(T value) {
        return this.insertAt(value, ListPosition.last());
    }

    public InsertOperation<SharedValueSignal<T>> insertAt(T value, ListPosition at) {
        return this.submitInsert(new SignalCommand.InsertCommand(Id.random(), this.id(), null, SharedListSignal.toJson(value), Objects.requireNonNull(at)), this::child);
    }

    public SignalOperation<Void> moveTo(AbstractSignal<T> child, ListPosition to) {
        SignalCommand.PositionCondition verifyChild = new SignalCommand.PositionCondition(Id.random(), this.id(), child.id(), new ListPosition(null, null));
        SignalCommand.AdoptAtCommand adopt = new SignalCommand.AdoptAtCommand(Id.random(), this.id(), child.id(), Objects.requireNonNull(to));
        return this.submit(new SignalCommand.TransactionCommand(Id.random(), List.of(verifyChild, adopt)));
    }

    @Override
    public SignalOperation<Void> remove(SharedValueSignal<T> child) {
        return super.remove(child);
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    public SignalOperation<Void> verifyPosition(AbstractSignal<?> child, ListPosition expectedPosition) {
        return this.submit(new SignalCommand.PositionCondition(Id.random(), this.id(), child.id(), Objects.requireNonNull(expectedPosition)));
    }

    public SignalOperation<Void> verifyChild(AbstractSignal<?> child) {
        return this.verifyPosition(child, new ListPosition(null, null));
    }

    public SharedListSignal<T> withValidator(CommandValidator validator) {
        return new SharedListSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.elementType);
    }

    public SharedListSignal<T> asReadonly() {
        return this.withValidator(anything -> false);
    }

    @Override
    public SharedNodeSignal asNode() {
        return super.asNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedListSignal)) return false;
        SharedListSignal other = (SharedListSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.elementType, other.elementType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.elementType);
    }

    public String toString() {
        return ((List)this.peek()).stream().map(AbstractSignal::peek).map(Objects::toString).collect(Collectors.joining(", ", "SharedListSignal[", "]"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LoggerFactory.getLogger(SharedListSignal.class).warn("Serializing SharedListSignal. Sharing signals across a cluster is not yet implemented.");
        out.defaultWriteObject();
    }

    public record ListPosition(Id after, Id before) {
        public static ListPosition first() {
            return new ListPosition(Id.EDGE, null);
        }

        public static ListPosition last() {
            return new ListPosition(null, Id.EDGE);
        }

        public static ListPosition after(AbstractSignal<?> after) {
            return new ListPosition(ListPosition.idOf(after), null);
        }

        public static ListPosition before(AbstractSignal<?> before) {
            return new ListPosition(null, ListPosition.idOf(before));
        }

        public static ListPosition between(AbstractSignal<?> after, AbstractSignal<?> before) {
            return new ListPosition(ListPosition.idOf(after), ListPosition.idOf(before));
        }

        private static Id idOf(AbstractSignal<?> signal) {
            if (signal == null) {
                return Id.EDGE;
            }
            return signal.id();
        }
    }
}

