/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class UploadEvent {
    private final VaadinRequest request;
    private final VaadinResponse response;
    private final VaadinSession session;
    private final String fileName;
    private final String contentType;
    private final long fileSize;
    private final Element owningElement;
    private final Part part;
    private boolean rejected = false;
    private String rejectionMessage;

    public UploadEvent(VaadinRequest request, VaadinResponse response, VaadinSession session, String fileName, long contentLength, String contentType, Element owningElement, Part part) {
        this.request = request;
        this.response = response;
        this.session = session;
        this.fileName = fileName;
        this.fileSize = contentLength;
        this.owningElement = owningElement;
        this.contentType = contentType;
        this.part = part;
    }

    public InputStream getInputStream() {
        if (this.rejected) {
            throw new IllegalStateException("Cannot access input stream of rejected upload: " + this.rejectionMessage);
        }
        try {
            if (this.part != null) {
                return this.part.getInputStream();
            }
            return this.request.getInputStream();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(UploadEvent.class).error("Error getting input stream", (Throwable)e);
            throw new UncheckedIOException("Error getting input stream", e);
        }
    }

    public VaadinRequest getRequest() {
        return this.request;
    }

    public VaadinResponse getResponse() {
        return this.response;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Component getOwningComponent() {
        return this.owningElement.getComponent().orElse(null);
    }

    public Element getOwningElement() {
        return this.owningElement;
    }

    public UI getUI() {
        Optional<Component> component = this.owningElement.getComponent();
        return component.map(value -> value.getUI().orElseGet(() -> this.getUiFromSession((Component)value))).orElseGet(UI::getCurrent);
    }

    private UI getUiFromSession(Component value) {
        try {
            this.session.lock();
            UI uI = this.session.getUIById(Integer.parseInt((String)ComponentUtil.getData(value, "uiid")));
            return uI;
        }
        finally {
            this.session.unlock();
        }
    }

    public void reject() {
        this.reject("File rejected");
    }

    public void reject(String message) {
        this.rejected = true;
        this.rejectionMessage = message;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }
}

