/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalEnvironment;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.impl.Effect;
import java.io.Serializable;
import java.util.Objects;

public final class ElementEffect
implements Serializable {
    private final SerializableRunnable effectFunction;
    private boolean closed = false;
    private Effect effect = null;
    private Registration detachRegistration;

    public ElementEffect(Element owner, SerializableRunnable effectFunction) {
        Objects.requireNonNull(owner, "Owner element cannot be null");
        Objects.requireNonNull(effectFunction, "Effect function cannot be null");
        this.effectFunction = effectFunction;
        owner.addAttachListener(attach -> {
            this.enableEffect(attach.getSource());
            this.detachRegistration = owner.addDetachListener(detach -> {
                this.disableEffect();
                this.detachRegistration.remove();
                this.detachRegistration = null;
            });
        });
        if (owner.getNode().isAttached()) {
            this.enableEffect(owner);
            this.detachRegistration = owner.addDetachListener(detach -> {
                this.disableEffect();
                this.detachRegistration.remove();
                this.detachRegistration = null;
            });
        }
    }

    public static Registration effect(Element owner, SerializableRunnable effectFunction) {
        ElementEffect effect = new ElementEffect(owner, effectFunction);
        return effect::close;
    }

    public static <T> Registration bind(Element owner, Signal<T> signal, SerializableBiConsumer<Element, T> setter) {
        return ElementEffect.effect(owner, () -> setter.accept(owner, signal.get()));
    }

    private void enableEffect(Element owner) {
        if (this.closed) {
            return;
        }
        Component parentComponent = ComponentUtil.findParentComponent(owner).get();
        UI ui = parentComponent.getUI().get();
        EffectAction errorHandlingEffectFunction = () -> {
            try {
                this.effectFunction.run();
            }
            catch (Exception e) {
                ui.getSession().getErrorHandler().error(new ErrorEvent(e, owner.getNode()));
            }
        };
        assert (this.effect == null);
        this.effect = new Effect(errorHandlingEffectFunction, command -> {
            if (UI.getCurrent() == ui) {
                command.run();
            } else {
                SignalEnvironment.getDefaultEffectDispatcher().execute(() -> {
                    try {
                        if (this.effect != null) {
                            ui.access(command::run);
                        }
                    }
                    catch (UIDetachedException uIDetachedException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    private void disableEffect() {
        if (this.effect != null) {
            this.effect.dispose();
            this.effect = null;
        }
    }

    public void close() {
        this.disableEffect();
        this.closed = true;
    }
}

