/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Direction;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ModalityMode;
import com.vaadin.flow.component.PollNotifier;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.PushConfigurationImpl;
import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.internal.JavaScriptNavigationStateRenderer;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.LoadingIndicatorConfiguration;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandlingCommand;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;

@JsModule(value="@vaadin/common-frontend/ConnectionIndicator.js")
public class UI
extends Component
implements PollNotifier,
HasComponents,
RouterLayout {
    private static final String NULL_LISTENER = "Listener can not be 'null'";
    private int uiId = -1;
    private boolean closing = false;
    private PushConfiguration pushConfiguration;
    private final ValueSignal<Locale> localeSignal = new ValueSignal<Locale>(Locale.getDefault());
    private final UIInternals internals;
    private final Page page = new Page(this);
    private final String csrfToken = UUID.randomUUID().toString();
    static final String SERVER_CONNECTED = "this.serverConnected($0)";
    public static final String CLIENT_NAVIGATE_TO = "const url = new URL($0, document.baseURI);\nurl[\"clientNavigation\"] = true;\nwindow.dispatchEvent(new CustomEvent('vaadin-router-go', { detail: url}));\n";
    private NavigationState clientViewNavigationState;
    private boolean navigationInProgress = false;
    private String forwardToClientUrl = null;
    private boolean firstNavigation = true;

    public UI() {
        this(new UIInternalUpdater(){});
    }

    protected UI(UIInternalUpdater internalsHandler) {
        super(null);
        this.internals = new UIInternals(this, internalsHandler);
        this.getNode().getFeature(ElementData.class).setTag("body");
        Component.setElement(this, Element.get(this.getNode()));
        this.pushConfiguration = new PushConfigurationImpl(this);
    }

    public VaadinSession getSession() {
        return this.internals.getSession();
    }

    public int getUIId() {
        return this.uiId;
    }

    public void doInit(VaadinRequest request, int uiId, String appId) {
        if (this.uiId != -1) {
            String message = "This UI instance is already initialized (as UI id " + this.uiId + ") and can therefore not be initialized again (as UI id " + uiId + "). ";
            if (this.getSession() != null && !this.getSession().equals(VaadinSession.getCurrent())) {
                message = message + "Furthermore, it is already attached to another VaadinSession. ";
            }
            message = message + "Please make sure you are not accidentally reusing an old UI instance.";
            throw new IllegalStateException(message);
        }
        this.uiId = uiId;
        this.getInternals().setFullAppId(appId);
        if (this.isNavigationSupported()) {
            this.internals.createWrapperElement();
            this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), this.internals.getWrapperElement(), "@id", appId);
            this.getEventBus().addListener(BrowserLeaveNavigationEvent.class, this::leaveNavigation);
            this.getEventBus().addListener(BrowserNavigateEvent.class, this::browserNavigate);
            this.getEventBus().addListener(BrowserRefreshEvent.class, this::browserRefresh);
        }
        this.getInternals().addComponentDependencies(this.getClass());
        this.init(request);
    }

    protected void init(VaadinRequest request) {
    }

    public static void setCurrent(UI ui) {
        CurrentInstance.set(UI.class, ui);
    }

    public static UI getCurrent() {
        return CurrentInstance.get(UI.class);
    }

    public static UI getCurrentOrThrow() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("No currently active UI found. This code must be run within a UI context. If you are running this from a background thread, wrap the call in UI.access().");
        }
        return ui;
    }

    public void close() {
        this.closing = true;
        PushConnection pushConnection = this.getInternals().getPushConnection();
        if (pushConnection != null) {
            if (this.getSession() != null) {
                this.getSession().getService().runPendingAccessTasks(this.getSession());
            }
            pushConnection.push();
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
    }

    public void accessSynchronously(Command command) throws UIDetachedException {
        this.accessSynchronously(command, null);
    }

    private static void handleAccessDetach(SerializableRunnable detachHandler) {
        if (detachHandler == null) {
            throw new UIDetachedException();
        }
        detachHandler.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessSynchronously(Command command, SerializableRunnable detachHandler) {
        Map<Class<?>, CurrentInstance> old = null;
        VaadinSession session = this.getSession();
        if (session == null) {
            UI.handleAccessDetach(detachHandler);
            return;
        }
        VaadinService.verifyNoOtherSessionLocked(session);
        session.lock();
        try {
            if (this.getSession() == null) {
                UI.handleAccessDetach(detachHandler);
                return;
            }
            old = CurrentInstance.setCurrent(this);
            command.execute();
        }
        finally {
            session.unlock();
            if (old != null) {
                CurrentInstance.restoreInstances(old);
            }
        }
    }

    public Future<Void> access(Command command) {
        return this.access(command, null);
    }

    private Future<Void> access(final Command command, final SerializableRunnable detachHandler) {
        VaadinSession session = this.getSession();
        if (session == null) {
            UI.handleAccessDetach(detachHandler);
            return null;
        }
        return session.access(new ErrorHandlingCommand(){

            @Override
            public void execute() {
                UI.this.accessSynchronously(command, detachHandler);
            }

            @Override
            public void handleError(Exception exception) {
                block9: {
                    try {
                        if (command instanceof ErrorHandlingCommand) {
                            ErrorHandlingCommand errorHandlingCommand = (ErrorHandlingCommand)command;
                            errorHandlingCommand.handleError(exception);
                            break block9;
                        }
                        if (UI.this.getSession() != null) {
                            Map<Class<?>, CurrentInstance> map = CurrentInstance.setCurrent(UI.this);
                            try {
                                UI.this.getSession().getErrorHandler().error(new ErrorEvent(exception));
                                break block9;
                            }
                            finally {
                                CurrentInstance.restoreInstances(map);
                            }
                        }
                        if (exception instanceof ExecutionException && exception.getCause() instanceof UIDetachedException) {
                            UI.this.getLogger().debug(exception.getMessage(), (Throwable)exception);
                        } else {
                            UI.this.getLogger().error(exception.getMessage(), (Throwable)exception);
                        }
                    }
                    catch (Exception e) {
                        UI.this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    public SerializableRunnable accessLater(SerializableRunnable accessTask, SerializableRunnable detachHandler) {
        Objects.requireNonNull(accessTask, "Access task cannot be null");
        return () -> this.access(accessTask::run, detachHandler);
    }

    public <T> SerializableConsumer<T> accessLater(SerializableConsumer<T> accessTask, SerializableRunnable detachHandler) {
        Objects.requireNonNull(accessTask, "Access task cannot be null");
        return value -> this.access(() -> accessTask.accept(value), detachHandler);
    }

    public void setPollInterval(int intervalInMillis) {
        this.getNode().getFeature(PollConfigurationMap.class).setPollInterval(intervalInMillis);
    }

    public int getPollInterval() {
        return this.getNode().getFeature(PollConfigurationMap.class).getPollInterval();
    }

    public LoadingIndicatorConfiguration getLoadingIndicatorConfiguration() {
        return this.getNode().getFeature(LoadingIndicatorConfigurationMap.class);
    }

    public void push() {
        VaadinSession session = this.getSession();
        if (session == null) {
            throw new UIDetachedException("Cannot push a detached UI");
        }
        session.checkHasLock();
        if (!this.getPushConfiguration().getPushMode().isEnabled()) {
            throw new IllegalStateException("Push not enabled");
        }
        PushConnection pushConnection = this.getInternals().getPushConnection();
        assert (pushConnection != null);
        session.getService().runPendingAccessTasks(session);
        if (!this.getInternals().isDirty() || this.getInternals().getStateTree().isPreparingForResync()) {
            return;
        }
        pushConnection.push();
    }

    public PushConfiguration getPushConfiguration() {
        return this.pushConfiguration;
    }

    public ReconnectDialogConfiguration getReconnectDialogConfiguration() {
        return this.getNode().getFeature(ReconnectDialogConfigurationMap.class);
    }

    Logger getLogger() {
        return LoggerFactory.getLogger((String)UI.class.getName());
    }

    @Override
    public Locale getLocale() {
        return (Locale)this.localeSignal.peek();
    }

    public WritableSignal<Locale> localeSignal() {
        return this.localeSignal;
    }

    public void setLocale(Locale locale) {
        assert (locale != null) : "Null locale is not supported!";
        if (!this.getLocale().equals(locale)) {
            this.localeSignal.set(locale);
            EventUtil.informLocaleChangeObservers(this);
        }
    }

    public void setDirection(Direction direction) {
        Objects.requireNonNull(direction, "Direction cannot be null");
        this.getPage().executeJs("document.dir = $0", direction.getClientName());
    }

    @Override
    public Element getElement() {
        return Element.get(this.getNode());
    }

    private StateNode getNode() {
        return this.getInternals().getStateTree().getRootNode();
    }

    public UIInternals getInternals() {
        return this.internals;
    }

    public Page getPage() {
        return this.page;
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget) {
        return this.navigate(navigationTarget, RouteParameters.empty());
    }

    private <T extends Component> Optional<T> findCurrentNavigationTarget(Class<T> navigationTarget) {
        List<HasElement> activeRouterTargetsChain = this.getInternals().getActiveRouterTargetsChain();
        for (HasElement element : activeRouterTargetsChain) {
            if (!navigationTarget.isAssignableFrom(element.getClass())) continue;
            return Optional.of((Component)element);
        }
        return Optional.empty();
    }

    public <T, C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, T parameter) {
        this.navigate(navigationTarget, HasUrlParameterFormat.getParameters(parameter));
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget, RouteParameters parameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        this.navigate(configuration.getUrl(navigationTarget, parameters));
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget, RouteParam ... parameters) {
        return this.navigate(navigationTarget, new RouteParameters(parameters));
    }

    public <T, C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, T parameter, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        RouteParameters parameters = HasUrlParameterFormat.getParameters(parameter);
        String url = configuration.getUrl(navigationTarget, parameters);
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, RouteParameters routeParameter, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        String url = configuration.getUrl(navigationTarget, routeParameter);
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<? extends T> navigationTarget, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        String url = configuration.getUrl(navigationTarget, RouteParameters.empty());
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public void navigate(String location) {
        this.navigate(location, QueryParameters.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(String locationString, QueryParameters queryParameters) {
        Objects.requireNonNull(locationString, "Location must not be null");
        Objects.requireNonNull(queryParameters, "Query parameters must not be null");
        Location location = new Location(locationString, queryParameters);
        if (this.navigationInProgress || this.getInternals().hasLastHandledLocation() && this.sameLocation(this.getInternals().getLastHandledLocation(), location)) {
            return;
        }
        this.navigationInProgress = true;
        try {
            Optional<NavigationState> navigationState = this.getInternals().getRouter().resolveNavigationTarget(location);
            if (navigationState.isPresent()) {
                this.handleNavigation(location, navigationState.get(), NavigationTrigger.UI_NAVIGATE);
                if (this.getForwardToClientUrl() != null) {
                    this.navigateToClient(this.getForwardToClientUrl());
                }
            } else {
                this.navigateToClient(location.getPathWithQueryParameters());
            }
        }
        finally {
            this.navigationInProgress = false;
        }
    }

    public void refreshCurrentRoute(boolean refreshRouteChain) {
        this.getInternals().refreshCurrentRoute(refreshRouteChain);
    }

    private void browserRefresh(BrowserRefreshEvent event) {
        this.refreshCurrentRoute(event.refreshRouteChain);
    }

    public boolean isNavigationSupported() {
        return true;
    }

    public Component getCurrentView() {
        if (this.getInternals().getActiveRouterTargetsChain().isEmpty()) {
            throw new IllegalStateException("Routing is not in use or not yet initialized. If you are not using embedded UI, try postponing the call to an onAttach method or to an AfterNavigationEvent listener.");
        }
        return (Component)this.getInternals().getActiveRouterTargetsChain().get(0);
    }

    public StateTree.ExecutionRegistration beforeClientResponse(Component component, SerializableConsumer<ExecutionContext> execution) throws IllegalArgumentException {
        if (component == null) {
            throw new IllegalArgumentException("The 'component' parameter may not be null");
        }
        if (execution == null) {
            throw new IllegalArgumentException("The 'execution' parameter may not be null");
        }
        Optional<UI> componentUi = component.getUI();
        if (componentUi.isPresent() && componentUi.get() != this) {
            throw new IllegalArgumentException("The given component doesn't belong to the UI the task to be executed on");
        }
        return this.internals.getStateTree().beforeClientResponse(component.getElement().getNode(), execution);
    }

    @Override
    public void add(Component ... components) {
        HasComponents.super.add(components);
    }

    @Override
    public Optional<UI> getUI() {
        return Optional.of(this);
    }

    public Registration addBeforeEnterListener(BeforeEnterListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addBeforeEnterListener(listener);
    }

    public Registration addBeforeLeaveListener(BeforeLeaveListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addBeforeLeaveListener(listener);
    }

    public Registration addAfterNavigationListener(AfterNavigationListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addAfterNavigationListener(listener);
    }

    public <E> List<E> getNavigationListeners(Class<E> navigationHandler) {
        return this.internals.getListeners(navigationHandler);
    }

    public ShortcutRegistration addShortcutListener(Command command, Key key, KeyModifier ... keyModifiers) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "command"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        return new ShortcutRegistration(this, () -> new Component[]{this}, event -> command.execute(), key).withModifiers(keyModifiers);
    }

    public ShortcutRegistration addShortcutListener(ShortcutEventListener listener, Key key, KeyModifier ... keyModifiers) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "listener"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        return new ShortcutRegistration(this, () -> new Component[]{this}, listener, key).withModifiers(keyModifiers);
    }

    public Registration addHeartbeatListener(HeartbeatListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addHeartbeatListener(listener);
    }

    public Component getActiveDragSourceComponent() {
        return this.getInternals().getActiveDragSourceComponent();
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    public void addModal(Component component) {
        this.add(component);
        this.setChildComponentModal(component, true);
    }

    public void setChildComponentModal(Component childComponent, boolean modal) {
        this.setChildComponentModal(childComponent, modal ? ModalityMode.STRICT : ModalityMode.MODELESS);
    }

    public void setChildComponentModal(Component childComponent, ModalityMode mode) {
        Objects.requireNonNull(childComponent, "Given child component may not be null");
        Objects.requireNonNull(mode, "Given modality mode may not be null");
        Optional<UI> ui = childComponent.getUI();
        if (ui.isPresent() && !ui.get().equals(this)) {
            throw new IllegalStateException("Given component is not a child in this UI. Add it first as a child of the UI so it is attached or just use addModal(component) when using ModalityMode.STRICT.");
        }
        if (mode == ModalityMode.STRICT) {
            this.getInternals().setChildModal(childComponent);
        } else {
            this.getInternals().setChildModeless(childComponent);
        }
    }

    public boolean hasModalComponent() {
        return this.getInternals().hasModalComponent();
    }

    public void addToModalComponent(Component component) {
        if (this.hasModalComponent()) {
            Component activeModalComponent = this.getInternals().getActiveModalComponent();
            if (activeModalComponent instanceof HasComponents) {
                ((HasComponents)((Object)activeModalComponent)).add(component);
            } else {
                activeModalComponent.getElement().appendChild(component.getElement());
            }
        } else {
            this.add(component);
        }
    }

    @Override
    public Stream<Component> getChildren() {
        if (this.internals.getWrapperElement() == null) {
            return super.getChildren();
        }
        Stream.Builder childComponents = Stream.builder();
        this.internals.getWrapperElement().getChildren().forEach(childElement -> ComponentUtil.findComponents(childElement, childComponents::add));
        super.getChildren().forEach(childComponents::add);
        return childComponents.build();
    }

    public Location getActiveViewLocation() {
        return this.getInternals().getActiveViewLocation();
    }

    public List<HasElement> getActiveRouterTargetsChain() {
        return this.getInternals().getActiveRouterTargetsChain();
    }

    public String getForwardToClientUrl() {
        return this.forwardToClientUrl;
    }

    public void browserNavigate(BrowserNavigateEvent event) {
        if (event.appShellTitle != null && !event.appShellTitle.isEmpty()) {
            this.getInternals().setAppShellTitle(event.appShellTitle);
        }
        String trimmedRoute = PathUtil.trimPath(event.route);
        Location location = new Location(trimmedRoute, QueryParameters.fromString(event.query));
        NavigationTrigger navigationTrigger = event.trigger.isEmpty() ? NavigationTrigger.PAGE_LOAD : (event.trigger.equalsIgnoreCase("link") ? NavigationTrigger.ROUTER_LINK : (event.trigger.equalsIgnoreCase("client") ? NavigationTrigger.CLIENT_SIDE : NavigationTrigger.HISTORY));
        if (this.firstNavigation) {
            this.firstNavigation = false;
            this.getPage().getHistory().setHistoryStateChangeHandler(e -> this.renderViewForRoute(e.getLocation(), e.getTrigger()));
            if (this.getInternals().getActiveRouterTargetsChain().isEmpty()) {
                this.renderViewForRoute(location, navigationTrigger);
            }
        } else {
            History.HistoryStateChangeHandler handler = this.getPage().getHistory().getHistoryStateChangeHandler();
            BaseJsonNode state = event.historyState == null ? null : (BaseJsonNode)event.historyState;
            handler.onHistoryStateChange(new History.HistoryStateChangeEvent(this.getPage().getHistory(), state, location, navigationTrigger));
        }
        if (this.getForwardToClientUrl() != null) {
            this.navigateToClient(this.getForwardToClientUrl());
            this.acknowledgeClient();
        } else if (this.isPostponed()) {
            this.serverPaused();
        } else {
            this.serverConnected(!this.getSession().getState().equals((Object)VaadinSessionState.OPEN));
            this.replaceStateIfDiffersAndNoReplacePending(event.route, location);
        }
    }

    private void replaceStateIfDiffersAndNoReplacePending(String route, Location location) {
        boolean containsPendingReplace;
        boolean locationChanged = !location.getPath().equals(route) && route.startsWith("/") && !location.getPath().equals(route.substring(1));
        boolean bl = containsPendingReplace = !this.getInternals().containsPendingJavascript("window.history.replaceState") && !this.getInternals().containsPendingJavascript("'vaadin-navigate', { detail: { state: $0, url: $1, replace: true } }");
        if (locationChanged && containsPendingReplace) {
            this.getPage().getHistory().replaceState(null, location);
        }
    }

    public void leaveNavigation(BrowserLeaveNavigationEvent event) {
        this.navigateToPlaceholder(new Location(PathUtil.trimPath(event.route), QueryParameters.fromString(event.query)));
        if (this.isPostponed()) {
            this.cancelClient();
        } else {
            this.acknowledgeClient();
        }
    }

    public void navigateToClient(String clientRoute) {
        this.getPage().executeJs(CLIENT_NAVIGATE_TO, clientRoute);
    }

    private void acknowledgeClient() {
        this.serverConnected(false);
    }

    private void cancelClient() {
        this.serverConnected(true);
    }

    private void serverPaused() {
        this.internals.getWrapperElement().executeJs("this.serverPaused()", new Object[0]);
    }

    private void serverConnected(boolean cancel) {
        this.internals.getWrapperElement().executeJs(SERVER_CONNECTED, cancel);
    }

    private void navigateToPlaceholder(Location location) {
        if (this.clientViewNavigationState == null) {
            this.clientViewNavigationState = new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(ClientViewPlaceholder.class).build();
        }
        this.handleNavigation(location, this.clientViewNavigationState, NavigationTrigger.CLIENT_SIDE);
    }

    private void renderViewForRoute(Location location, NavigationTrigger trigger) {
        if (!this.shouldHandleNavigation(location)) {
            return;
        }
        this.getInternals().setLastHandledNavigation(location);
        Optional<NavigationState> navigationState = this.getInternals().getRouter().resolveNavigationTarget(location);
        if (navigationState.isPresent()) {
            this.handleNavigation(location, navigationState.get(), trigger);
        } else {
            this.navigateToPlaceholder(location);
            if (!this.isPostponed()) {
                NotFoundException notFoundException = new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
                this.getInternals().getRouter().handleExceptionNavigation(this, location, notFoundException, NavigationTrigger.CLIENT_SIDE, null);
            }
        }
    }

    private boolean shouldHandleNavigation(Location location) {
        return !this.getInternals().hasLastHandledLocation() || !this.sameLocation(this.getInternals().getLastHandledLocation(), location);
    }

    private boolean sameLocation(Location oldLocation, Location newLocation) {
        return PathUtil.trimPath(newLocation.getPathWithQueryParameters()).equals(PathUtil.trimPath(oldLocation.getPathWithQueryParameters()));
    }

    private void handleNavigation(Location location, NavigationState navigationState, NavigationTrigger trigger) {
        NavigationEvent navigationEvent = new NavigationEvent(this.getInternals().getRouter(), location, this, trigger);
        JavaScriptNavigationStateRenderer renderer = new JavaScriptNavigationStateRenderer(navigationState);
        this.getInternals().getRouter().executeNavigation(this, location, navigationEvent, renderer, httpStatus -> {
            this.forwardToClientUrl = renderer.getClientForwardRoute();
            this.adjustPageTitle();
        });
    }

    private boolean isPostponed() {
        return this.getInternals().getContinueNavigationAction() != null;
    }

    private void adjustPageTitle() {
        String newTitle = this.getInternals().getTitle();
        String appShellTitle = this.getInternals().getAppShellTitle();
        if ((newTitle == null || newTitle.isEmpty()) && appShellTitle != null && !appShellTitle.isEmpty()) {
            this.getInternals().cancelPendingTitleUpdate();
            this.getInternals().setTitle(appShellTitle);
        }
    }

    private NavigationState getDefaultNavigationError() {
        return new NavigationStateBuilder(this.getInternals().getRouter()).withTarget(RouteNotFoundError.class).build();
    }

    @DomEvent(value="ui-leave-navigation")
    public static class BrowserLeaveNavigationEvent
    extends ComponentEvent<UI> {
        public static final String EVENT_NAME = "ui-leave-navigation";
        private final String route;
        private final String query;

        public BrowserLeaveNavigationEvent(UI source, boolean fromClient, @EventData(value="route") String route, @EventData(value="query") String query) {
            super(source, true);
            this.route = route;
            this.query = query;
        }
    }

    @DomEvent(value="ui-navigate")
    public static class BrowserNavigateEvent
    extends ComponentEvent<UI> {
        public static final String EVENT_NAME = "ui-navigate";
        private final String route;
        private final String query;
        private final String appShellTitle;
        private final JsonNode historyState;
        private final String trigger;

        public BrowserNavigateEvent(UI source, boolean fromClient, @EventData(value="route") String route, @EventData(value="query") String query, @EventData(value="appShellTitle") String appShellTitle, @EventData(value="historyState") JsonNode historyState, @EventData(value="trigger") String trigger) {
            super(source, true);
            this.route = route;
            this.query = query;
            this.appShellTitle = appShellTitle;
            this.historyState = historyState;
            this.trigger = trigger;
        }
    }

    @DomEvent(value="ui-refresh")
    public static class BrowserRefreshEvent
    extends ComponentEvent<UI> {
        public static final String EVENT_NAME = "ui-refresh";
        private final boolean refreshRouteChain;

        public BrowserRefreshEvent(UI source, boolean fromClient, @EventData(value="fullRefresh") boolean refreshRouteChain) {
            super(source, true);
            this.refreshRouteChain = refreshRouteChain;
        }
    }

    @Tag(value="div")
    @AnonymousAllowed
    public static class ClientViewPlaceholder
    extends Component {
    }
}

