/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEffect;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.Objects;

public class SignalPropertySupport<T>
implements Serializable {
    private final SerializableConsumer<T> valueChangeConsumer;
    private final Component owner;
    private Registration registration;
    private Signal<T> signal;
    private T value;

    private SignalPropertySupport(Component owner, SerializableConsumer<T> valueChangeConsumer) {
        this.owner = Objects.requireNonNull(owner, "Owner component cannot be null");
        this.valueChangeConsumer = Objects.requireNonNull(valueChangeConsumer, "Value change consumer cannot be null");
    }

    public static <T> SignalPropertySupport<T> create(Component owner, SerializableConsumer<T> valueChangeConsumer) {
        return new SignalPropertySupport<T>(owner, valueChangeConsumer);
    }

    public void bind(Signal<T> signal) {
        Objects.requireNonNull(signal, "Signal cannot be null");
        if (this.signal != null) {
            throw new BindingActiveException();
        }
        this.signal = signal;
        this.registration = ComponentEffect.effect(this.owner, () -> {
            this.value = signal.get();
            this.valueChangeConsumer.accept(this.value);
        });
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        if (this.signal != null) {
            throw new BindingActiveException();
        }
        this.value = value;
        this.valueChangeConsumer.accept(value);
    }
}

