/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.PropertyChangeDeniedException;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.testutil.ClassesSerializableTest;
import com.vaadin.tests.server.component.SerializedLocalSignalComponent;
import com.vaadin.tests.server.component.SerializedSharedSignalComponent;
import com.vaadin.tests.util.MockUI;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FlowClassesSerializableTest
extends ClassesSerializableTest {
    @Test
    public void htmlComponentAndHtmlContainer() throws Throwable {
        Component[] components;
        for (Component component : components = new Component[]{new HtmlComponent("dummy-tag"), new HtmlContainer("dummy-tag")}) {
            Component componentCopy = (Component)this.serializeAndDeserialize(component);
            Assert.assertEquals((Object)component.getElement().getTag(), (Object)componentCopy.getElement().getTag());
            Assert.assertNotSame((Object)component.getElement(), (Object)componentCopy.getElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void streamResource() throws Throwable {
        UI ui = new UI();
        UI.setCurrent((UI)ui);
        try {
            Element element = new Element("dummy-element");
            StreamReceiver streamReceiver = new StreamReceiver(element.getNode(), "upload", (StreamVariable)new MyStreamVariable());
            Assert.assertEquals((Object)ui, (Object)UI.getCurrent());
            element.setAttribute("target", (AbstractStreamResource)streamReceiver);
            this.serializeAndDeserialize(element);
            Assert.assertTrue((String)"Basic smoke test with ", (element.getAttribute("target").length() > 10 ? 1 : 0) != 0);
        }
        finally {
            UI.setCurrent(null);
        }
    }

    private MockUI setupForSignalSerializationTest() {
        CurrentInstance.clearAll();
        MockVaadinServletService service = new MockVaadinServletService(){
            private final Lock lock = new ReentrantLock();
            {
                this.lock.lock();
            }

            protected Lock getSessionLock(WrappedSession wrappedSession) {
                return this.lock;
            }

            @Override
            public void init() {
                super.init();
                ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
                Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)this.getDeploymentConfiguration().isProductionMode());
                Mockito.when((Object)configuration.isDevModeSessionSerializationEnabled()).thenReturn((Object)true);
                this.getContext().setAttribute(ApplicationConfiguration.class, (Object)configuration);
            }
        };
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        session.refreshTransients(null, (VaadinService)service);
        MockUI ui = new MockUI(session);
        ui.doInit(null, 42, "foo");
        session.addUI(ui);
        return ui;
    }

    @Test
    public void localSignalSerializable() {
        MockUI ui = this.setupForSignalSerializationTest();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        ValueSignal signal = new ValueSignal((Object)"initial");
        SerializedLocalSignalComponent component = new SerializedLocalSignalComponent((ValueSignal<String>)signal);
        ui.add(new Component[]{component});
        Assert.assertEquals((long)1L, (long)component.effectExecutionCounter);
        signal.set((Object)"changed");
        Assert.assertEquals((long)2L, (long)component.effectExecutionCounter);
        VaadinSession deserializedSession = null;
        session.unlock();
        try {
            deserializedSession = (VaadinSession)this.serializeAndDeserialize(session);
            Assert.assertNotNull((Object)deserializedSession);
            Assert.assertNotSame((Object)deserializedSession, (Object)session);
        }
        catch (Throwable e) {
            Assert.fail((String)("SerializedLocalSignalComponent should be serializable: " + String.valueOf(e.getClass()) + ": " + e.getMessage()));
        }
        deserializedSession.refreshTransients(null, service);
        deserializedSession.lock();
        UI deserializedUi = (UI)deserializedSession.getUIs().iterator().next();
        SerializedLocalSignalComponent deserializedComponent = deserializedUi.getChildren().filter(SerializedLocalSignalComponent.class::isInstance).map(SerializedLocalSignalComponent.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)"SerializedLocalSignalComponent has not been deserialized"));
        Assert.assertNotSame((Object)((Object)deserializedComponent), (Object)((Object)component));
        UI.setCurrent((UI)deserializedUi);
        deserializedComponent.signal.set((Object)"changed after deserialization");
        Assert.assertEquals((long)3L, (long)deserializedComponent.effectExecutionCounter);
        deserializedComponent.signal.set((Object)"changed");
        Assert.assertEquals((long)4L, (long)deserializedComponent.effectExecutionCounter);
        signal.set((Object)"changed in original signal");
        Assert.assertEquals((long)4L, (long)deserializedComponent.effectExecutionCounter);
        deserializedComponent.registration.remove();
        deserializedComponent.signal.set((Object)"foo");
        Assert.assertEquals((long)4L, (long)deserializedComponent.effectExecutionCounter);
        Assert.assertEquals((Object)"foo", (Object)deserializedComponent.getElement().getText());
        Assert.assertEquals((Object)"foo", (Object)deserializedComponent.getElement().getAttribute("attr"));
        Assert.assertEquals((Object)"foo", (Object)deserializedComponent.getElement().getProperty("prop"));
        Assert.assertEquals((Object)"foo!!!", (Object)deserializedComponent.getElement().getProperty("two-way-prop"));
        this.emulateClientUpdate(deserializedComponent.getElement(), "two-way-prop", "bar!!!");
        Assert.assertEquals((Object)"bar!!!", (Object)deserializedComponent.getElement().getProperty("two-way-prop"));
        Assert.assertEquals((Object)"bar", (Object)deserializedComponent.signal.peek());
        Assert.assertTrue((boolean)deserializedComponent.getElement().isEnabled());
        Assert.assertTrue((boolean)deserializedComponent.getElement().isVisible());
        deserializedComponent.signal.set(null);
        Assert.assertFalse((boolean)deserializedComponent.getElement().isEnabled());
        Assert.assertFalse((boolean)deserializedComponent.getElement().isVisible());
        deserializedSession.unlock();
        VaadinService.setCurrent(null);
    }

    @Test
    public void sharedSignalSerializable() {
        MockUI ui = this.setupForSignalSerializationTest();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SerializedSharedSignalComponent component = new SerializedSharedSignalComponent((SharedValueSignal<String>)signal);
        ui.add(new Component[]{component});
        Assert.assertEquals((long)1L, (long)component.effectExecutionCounter);
        signal.set((Object)"changed");
        Assert.assertEquals((long)2L, (long)component.effectExecutionCounter);
        VaadinSession deserializedSession = null;
        session.unlock();
        try {
            deserializedSession = (VaadinSession)this.serializeAndDeserialize(session);
            Assert.assertNotNull((Object)deserializedSession);
            Assert.assertNotSame((Object)deserializedSession, (Object)session);
        }
        catch (Throwable e) {
            Assert.fail((String)("SerializedSharedSignalComponent should be serializable: " + String.valueOf(e.getClass()) + ": " + e.getMessage()));
        }
        deserializedSession.refreshTransients(null, service);
        deserializedSession.lock();
        UI deserializedUi = (UI)deserializedSession.getUIs().iterator().next();
        SerializedSharedSignalComponent deserializedComponent = deserializedUi.getChildren().filter(SerializedSharedSignalComponent.class::isInstance).map(SerializedSharedSignalComponent.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)"SerializedSharedSignalComponent has not been deserialized"));
        Assert.assertNotSame((Object)((Object)deserializedComponent), (Object)((Object)component));
        UI.setCurrent((UI)deserializedUi);
        deserializedComponent.signal.set((Object)"changed after deserialization");
        Assert.assertEquals((long)3L, (long)deserializedComponent.effectExecutionCounter);
        deserializedComponent.signal.set((Object)"changed");
        Assert.assertEquals((long)4L, (long)deserializedComponent.effectExecutionCounter);
        signal.set((Object)"changed in original signal");
        Assert.assertEquals((long)4L, (long)deserializedComponent.effectExecutionCounter);
        deserializedComponent.registration.remove();
        deserializedComponent.signal.set((Object)"foo");
        Assert.assertEquals((long)4L, (long)deserializedComponent.effectExecutionCounter);
        deserializedSession.unlock();
        VaadinService.setCurrent(null);
    }

    private void emulateClientUpdate(Element element, String property, String value) {
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)element.getNode());
        try {
            childModel.deferredUpdateFromClient(property, (Serializable)((Object)value));
        }
        catch (PropertyChangeDeniedException e) {
            Assert.fail((String)("Failed to update property from client: " + e.getMessage()));
        }
    }

    private static class MyStreamVariable
    implements StreamVariable {
        private MyStreamVariable() {
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public boolean listenProgress() {
            return false;
        }

        public void onProgress(StreamVariable.StreamingProgressEvent event) {
        }

        public void streamingStarted(StreamVariable.StreamingStartEvent event) {
        }

        public void streamingFinished(StreamVariable.StreamingEndEvent event) {
        }

        public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
        }

        public boolean isInterrupted() {
            return false;
        }
    }
}

