/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.MutableTreeRevision;
import com.vaadin.flow.signals.shared.impl.Snapshot;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.StringNode;

public class MutableTreeRevisionTest {
    private final MutableTreeRevision revision = new MutableTreeRevision((TreeRevision)new Snapshot(Id.random(), false));
    private final Id commandId = Id.random();

    @Test
    void constructor_modifyBase_copyNotUpdated() {
        MutableTreeRevision copy = new MutableTreeRevision((TreeRevision)this.revision);
        this.revision.nodes().put(Id.random(), Node.EMPTY);
        this.revision.originalInserts().put(Id.random(), null);
        Assertions.assertEquals(Map.of(Id.ZERO, Node.EMPTY), (Object)copy.nodes());
        Assertions.assertEquals(Map.of(), (Object)copy.originalInserts());
    }

    @Test
    void constructor_modifyCopy_baseNotUpdated() {
        MutableTreeRevision copy = new MutableTreeRevision((TreeRevision)this.revision);
        copy.nodes().put(Id.random(), Node.EMPTY);
        copy.originalInserts().put(Id.random(), null);
        Assertions.assertEquals(Map.of(Id.ZERO, Node.EMPTY), (Object)this.revision.nodes());
        Assertions.assertEquals(Map.of(), (Object)this.revision.originalInserts());
    }

    @Test
    void setCommand_existingTarget_valueIsSet() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.SetCommand(this.commandId, Id.ZERO, (JsonNode)new StringNode("value")));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        CommandResult.NodeModification modification = accept.onlyUpdate();
        Assertions.assertEquals((Object)Node.EMPTY, (Object)modification.oldNode());
        Node.Data newDataNode = (Node.Data)modification.newNode();
        Assertions.assertEquals((Object)new StringNode("value"), (Object)newDataNode.value());
        this.assertValue(Id.ZERO, "value");
    }

    @Test
    void setCommand_missingTarget_rejected() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.SetCommand(this.commandId, Id.random(), (JsonNode)new StringNode("value")));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertNullValue(Id.ZERO);
    }

    @Test
    void setCommand_aliasTarget_dataNodeUpdated() {
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.SetCommand(this.commandId, alias, (JsonNode)new StringNode("value")));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals(Set.of(Id.ZERO), accept.updates().keySet());
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertValue(Id.ZERO, "value");
        this.assertValue(alias, "value");
    }

    @Test
    void incrementCommand_nullValue_incrementsFromZero() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.IncrementCommand(this.commandId, Id.ZERO, 3.0));
        Node.Data newData = MutableTreeRevisionTest.assertSingleDataChange(result);
        Assertions.assertEquals((int)3, (int)newData.value().asInt());
        this.assertValue(Id.ZERO, 3.0);
    }

    @Test
    void incrementCommand_numericValue_incremented() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(2.0)));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.IncrementCommand(this.commandId, Id.ZERO, 3.0));
        Node.Data newData = MutableTreeRevisionTest.assertSingleDataChange(result);
        Assertions.assertEquals((int)5, (int)newData.value().asInt());
        this.assertValue(Id.ZERO, 5.0);
    }

    @Test
    void incrementCommand_textValue_reject() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new StringNode("value")));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.IncrementCommand(this.commandId, Id.ZERO, 3.0));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertValue(Id.ZERO, "value");
    }

    @Test
    void incrementCommand_alias_dataUpdated() {
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.IncrementCommand(this.commandId, alias, 3.0));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals(Set.of(Id.ZERO), accept.updates().keySet());
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertValue(Id.ZERO, 3.0);
    }

    @Test
    void insertCommand_emptyNode_onlyChild() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(this.commandId, Id.ZERO, null, (JsonNode)new StringNode("value"), SharedListSignal.ListPosition.first()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)2, (int)accept.updates().size());
        CommandResult.NodeModification parentUpdate = (CommandResult.NodeModification)accept.updates().get(Id.ZERO);
        Assertions.assertEquals(List.of(this.commandId), (Object)((Node.Data)parentUpdate.newNode()).listChildren());
        CommandResult.NodeModification childUpdate = (CommandResult.NodeModification)accept.updates().get(this.commandId);
        Assertions.assertNull((Object)childUpdate.oldNode());
        Assertions.assertEquals((Object)"value", (Object)((Node.Data)childUpdate.newNode()).value().asString());
        this.assertListChildren(Id.ZERO, this.commandId);
        this.assertValue(this.commandId, "value");
    }

    @Test
    void insertCommandFirst_otherEntry_insertedFirst() {
        Id other = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other, Id.ZERO, null, null, SharedListSignal.ListPosition.first()));
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, SharedListSignal.ListPosition.first()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        CommandResult.NodeModification parentUpdate = (CommandResult.NodeModification)accept.updates().get(Id.ZERO);
        Assertions.assertEquals(List.of(other), (Object)((Node.Data)parentUpdate.oldNode()).listChildren());
        Assertions.assertEquals(List.of(inserted, other), (Object)((Node.Data)parentUpdate.newNode()).listChildren());
        this.assertListChildren(Id.ZERO, inserted, other);
    }

    @Test
    void insertCommandLast_otherEntry_insertedLast() {
        Id other = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other, Id.ZERO, null, null, SharedListSignal.ListPosition.first()));
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, other, inserted);
    }

    @Test
    void insertCommand_afterOther_insertedAfter() {
        Id other = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other, Id.ZERO, null, null, SharedListSignal.ListPosition.first()));
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, new SharedListSignal.ListPosition(other, null)));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, other, inserted);
    }

    @Test
    void insertCommand_beforeOther_insertedBefore() {
        Id other = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other, Id.ZERO, null, null, SharedListSignal.ListPosition.first()));
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, new SharedListSignal.ListPosition(null, other)));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, inserted, other);
    }

    @Test
    void insertCommand_beforeMissing_reject() {
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, new SharedListSignal.ListPosition(null, Id.random())));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void insertCommand_afterMissing_reject() {
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, new SharedListSignal.ListPosition(Id.random(), null)));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void insertCommand_betweenAdjacent_insertedBetween() {
        Id other1 = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other1, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id other2 = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other2, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, new SharedListSignal.ListPosition(other1, other2)));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, other1, inserted, other2);
    }

    @Test
    void insertCommand_betweenNonAdjacent_reject() {
        Id other1 = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other1, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id other2 = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other2, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id inserted = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(inserted, Id.ZERO, null, null, new SharedListSignal.ListPosition(other2, other1)));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, other1, other2);
    }

    @Test
    void insertCommand_emptyPosition_reject() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(this.commandId, Id.ZERO, null, null, new SharedListSignal.ListPosition(null, null)));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void insertCommand_parentAlias_dataUpdated() {
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(this.commandId, alias, null, null, SharedListSignal.ListPosition.first()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertListChildren(Id.ZERO, this.commandId);
    }

    @Test
    void insertCommand_afterAlias_afterAliasTarget() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        Id alias = this.createAlias(child);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(this.commandId, Id.ZERO, null, null, new SharedListSignal.ListPosition(alias, null)));
        MutableTreeRevisionTest.assertAccepted(result);
        this.assertListChildren(Id.ZERO, child, this.commandId);
    }

    @Test
    void insertCommand_beforeAlias_beforeAliasTarget() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        Id alias = this.createAlias(child);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.InsertCommand(this.commandId, Id.ZERO, null, null, new SharedListSignal.ListPosition(null, alias)));
        MutableTreeRevisionTest.assertAccepted(result);
        this.assertListChildren(Id.ZERO, this.commandId, child);
    }

    @Test
    void putCommand_emptyTarget_nodeInserted() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PutCommand(this.commandId, Id.ZERO, "key", (JsonNode)new StringNode("value")));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)2, (int)accept.updates().size());
        CommandResult.NodeModification rootModification = (CommandResult.NodeModification)accept.updates().get(Id.ZERO);
        Assertions.assertEquals(Map.of("key", this.commandId), (Object)((Node.Data)rootModification.newNode()).mapChildren());
        CommandResult.NodeModification childModification = (CommandResult.NodeModification)accept.updates().get(this.commandId);
        Assertions.assertNull((Object)childModification.oldNode());
        Assertions.assertEquals((Object)"value", (Object)((Node.Data)childModification.newNode()).value().asString());
        this.assertMapChildren(Id.ZERO, Map.of("key", this.commandId));
        this.assertValue(this.commandId, "value");
    }

    @Test
    void putCommand_multiplePuts_orderPreserved() {
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "firstKey", (JsonNode)new StringNode("first")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "secondKey", (JsonNode)new StringNode("second")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "thirdKey", (JsonNode)new StringNode("third")));
        this.assertMapKeys(Id.ZERO, "firstKey", "secondKey", "thirdKey");
    }

    @Test
    void putCommand_replaceExisting_nodeUpdated() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", (JsonNode)new StringNode("1")));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PutCommand(this.commandId, Id.ZERO, "key", (JsonNode)new StringNode("2")));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        CommandResult.NodeModification childUpdate = accept.onlyUpdate();
        Assertions.assertEquals((Object)"1", (Object)((Node.Data)childUpdate.oldNode()).value().asString());
        Assertions.assertEquals((Object)"2", (Object)((Node.Data)childUpdate.newNode()).value().asString());
        this.assertMapChildren(Id.ZERO, Map.of("key", child));
        this.assertValue(child, "2");
    }

    @Test
    void putCommand_aliasTarget_dataNodeUpdated() {
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PutCommand(this.commandId, alias, "key", null));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertMapChildren(Id.ZERO, Map.of("key", this.commandId));
    }

    @Test
    void putIfAbsentCommand_absent_nodeCreated() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(this.commandId, Id.ZERO, null, "key", (JsonNode)new StringNode("value")));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)2, (int)accept.updates().size());
        this.assertMapChildren(Id.ZERO, Map.of("key", this.commandId));
        Assertions.assertInstanceOf(Node.Data.class, this.revision.nodes().get(this.commandId));
        this.assertValue(this.commandId, "value");
    }

    @Test
    void putIfAbsentCommand_present_aliasCreated() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", (JsonNode)new StringNode("1")));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(this.commandId, Id.ZERO, null, "key", (JsonNode)new StringNode("2")));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)1, (int)accept.updates().size(), (String)"Only alias is updated");
        CommandResult.NodeModification modification = (CommandResult.NodeModification)accept.updates().get(this.commandId);
        Assertions.assertNull((Object)modification.oldNode());
        Assertions.assertInstanceOf(Node.Alias.class, (Object)modification.newNode());
        Assertions.assertEquals((Object)child, (Object)((Node.Alias)modification.newNode()).target());
        this.assertMapChildren(Id.ZERO, Map.of("key", child));
        this.assertValue(child, "1");
        this.assertValue(this.commandId, "1");
        Assertions.assertInstanceOf(Node.Data.class, this.revision.nodes().get(child));
        Assertions.assertInstanceOf(Node.Alias.class, this.revision.nodes().get(this.commandId));
    }

    @Test
    void putIfAbsentCommand_aliasTarget_dataNodeUpdated() {
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(this.commandId, alias, null, "key", null));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertMapChildren(Id.ZERO, Map.of("key", this.commandId));
    }

    @Test
    void putIfAbsentCommand_multiplePuts_orderPreserved() {
        this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(Id.random(), Id.ZERO, null, "firstKey", (JsonNode)new StringNode("first")));
        this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(Id.random(), Id.ZERO, null, "secondKey", (JsonNode)new StringNode("second")));
        this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(Id.random(), Id.ZERO, null, "thirdKey", (JsonNode)new StringNode("third")));
        this.assertMapKeys(Id.ZERO, "firstKey", "secondKey", "thirdKey");
    }

    @Test
    void adoptAtCommand_childMissing_reject() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, Id.ZERO, Id.random(), SharedListSignal.ListPosition.last()));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void adoptAtCommand_childAdoptsItsParent_reject() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, child, Id.ZERO, SharedListSignal.ListPosition.last()));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, child);
    }

    @Test
    void adoptAtCommand_childAlreadyInParent_orderChanged() {
        Id other = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(other, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, Id.ZERO, child, SharedListSignal.ListPosition.first()));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, child, other);
    }

    @Test
    void adoptAtCommand_childInAnotherParent_adopted() {
        Id target = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(target, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, target, child, SharedListSignal.ListPosition.first()));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, target);
        this.assertListChildren(target, child);
    }

    @Test
    void adoptAtCommand_mapChild_removedFromMap() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, Id.ZERO, child, SharedListSignal.ListPosition.first()));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, child);
        this.assertMapChildren(Id.ZERO, Map.of());
    }

    @Test
    void adoptAtCommand_aliasParent_dataNodeUpdated() {
        Id alias = this.createAlias(Id.ZERO);
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, alias, children.get(0), SharedListSignal.ListPosition.last()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertListChildren(Id.ZERO, children.get(1), children.get(0));
    }

    @Test
    void adoptAtCommand_moveAlias_dataNodeMoved() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        Id alias = this.createAlias(children.get(0));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAtCommand(this.commandId, Id.ZERO, alias, SharedListSignal.ListPosition.last()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(children.get(0)));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertListChildren(Id.ZERO, children.get(1), children.get(0));
    }

    @Test
    void adoptAsCommand_childMissing_reject() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, Id.ZERO, Id.random(), "key"));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void adoptAsCommand_childAdoptsItsParent_reject() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, child, Id.ZERO, "key"));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertMapChildren(Id.ZERO, Map.of("key", child));
    }

    @Test
    void adoptAsCommand_childAlreadyInParent_keyChanged() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, Id.ZERO, child, "key2"));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertMapChildren(Id.ZERO, Map.of("key2", child));
    }

    @Test
    void adoptAsCommand_childInAnotherParent_adopted() {
        Id target = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(target, Id.ZERO, "key", null));
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key2", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, target, child, "key"));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertMapChildren(Id.ZERO, Map.of("key", target));
        this.assertMapChildren(target, Map.of("key", child));
    }

    @Test
    void adoptAsCommand_listChild_removedFromList() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, Id.ZERO, child, "key"));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, new Id[0]);
        this.assertMapChildren(Id.ZERO, Map.of("key", child));
    }

    @Test
    void adoptAsCommand_existingKey_reject() {
        Id other = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(other, Id.ZERO, "key", null));
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key2", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, Id.ZERO, child, "key"));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertMapChildren(Id.ZERO, Map.of("key", other, "key2", child));
    }

    @Test
    void adoptAsCommand_aliasParent_dataNodeUpdated() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, alias, child, "key2"));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertMapChildren(Id.ZERO, Map.of("key2", child));
    }

    @Test
    void adoptAsCommand_moveAlias_dataNodeUpdated() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        Id alias = this.createAlias(child);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(this.commandId, Id.ZERO, alias, "key2"));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(child));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertMapChildren(Id.ZERO, Map.of("key2", child));
    }

    @Test
    void adoptAsCommand_existingKeys_orderPreserved() {
        Id firstId = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(firstId, Id.ZERO, "firstKey", (JsonNode)new StringNode("first")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "secondKey", (JsonNode)new StringNode("second")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(this.commandId, firstId, "key", (JsonNode)new StringNode("value")));
        this.applySingle((SignalCommand)new SignalCommand.AdoptAsCommand(Id.random(), Id.ZERO, this.commandId, "thirdKey"));
        this.assertMapKeys(Id.ZERO, "firstKey", "secondKey", "thirdKey");
    }

    @Test
    void removeCommand_rootNode_reject() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(this.commandId, Id.ZERO, null));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void removeCommand_childWithGrandchild_recursivelyRemoved() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id grandChild = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(grandChild, child, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(this.commandId, child, null));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)3, (int)accept.updates().size());
        Node.Data newRootData = (Node.Data)((CommandResult.NodeModification)accept.updates().get(Id.ZERO)).newNode();
        Assertions.assertEquals(List.of(), (Object)newRootData.listChildren());
        CommandResult.NodeModification childUpdate = (CommandResult.NodeModification)accept.updates().get(child);
        Assertions.assertNull((Object)childUpdate.newNode());
        CommandResult.NodeModification grandchildUpdate = (CommandResult.NodeModification)accept.updates().get(grandChild);
        Assertions.assertNull((Object)grandchildUpdate.newNode());
        this.assertListChildren(Id.ZERO, new Id[0]);
        Assertions.assertEquals((int)1, (int)this.revision.nodes().size());
    }

    @Test
    void removeCommand_expectedParentNotParent_reject() {
        Id expectedParent = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(expectedParent, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(this.commandId, child, expectedParent));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, expectedParent, child);
    }

    @Test
    void removeCommand_expectedParentIsParent_childRemoved() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(this.commandId, child, Id.ZERO));
        Assertions.assertTrue((boolean)result.accepted());
        this.assertListChildren(Id.ZERO, new Id[0]);
    }

    @Test
    void removeCommand_parentAlias_dataNodeUpdated() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(this.commandId, child, alias));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertListChildren(Id.ZERO, new Id[0]);
    }

    @Test
    void removeCommand_childAlias_dataNodeUpdated() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        Id alias = this.createAlias(child);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(this.commandId, alias, Id.ZERO));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(child));
        Assertions.assertTrue((boolean)accept.updates().containsKey(alias), (String)"Alias was also removed");
        this.assertListChildren(Id.ZERO, new Id[0]);
        Assertions.assertFalse((boolean)this.revision.nodes().containsKey(alias));
    }

    @Test
    void removeCommand_multipleMapChildren_orderPreserved() {
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "firstKey", (JsonNode)new StringNode("first")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(this.commandId, Id.ZERO, "secondKey", (JsonNode)new StringNode("second")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "thirdKey", (JsonNode)new StringNode("third")));
        this.applySingle((SignalCommand)new SignalCommand.RemoveCommand(Id.random(), this.commandId, null));
        this.assertMapKeys(Id.ZERO, "firstKey", "thirdKey");
    }

    @Test
    void removeByKeyCommand_missingKey_reject() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveByKeyCommand(this.commandId, Id.ZERO, "key"));
        Assertions.assertFalse((boolean)result.accepted());
        this.assertUnchanged();
    }

    @Test
    void removeByKeyCommand_existingKey_removed() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveByKeyCommand(this.commandId, Id.ZERO, "key"));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)2, (int)accept.updates().size());
        CommandResult.NodeModification childUpdate = (CommandResult.NodeModification)accept.updates().get(child);
        Assertions.assertNull((Object)childUpdate.newNode());
        CommandResult.NodeModification parentUpdate = (CommandResult.NodeModification)accept.updates().get(Id.ZERO);
        Assertions.assertEquals(Map.of(), (Object)((Node.Data)parentUpdate.newNode()).mapChildren());
        this.assertMapChildren(Id.ZERO, Map.of());
    }

    @Test
    void removeByKeyCommand_parentAlias_dataNodeUpdated() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.RemoveByKeyCommand(this.commandId, alias, "key"));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertMapChildren(Id.ZERO, Map.of());
    }

    @Test
    void removeByKeyCommand_multipleMapChildren_orderPreserved() {
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "firstKey", (JsonNode)new StringNode("first")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "secondKey", (JsonNode)new StringNode("second")));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "thirdKey", (JsonNode)new StringNode("third")));
        this.applySingle((SignalCommand)new SignalCommand.RemoveByKeyCommand(Id.random(), Id.ZERO, "secondKey"));
        this.assertMapKeys(Id.ZERO, "firstKey", "thirdKey");
    }

    @Test
    void clearCommand_nodeWithChildren_childrenRemoved() {
        Id listChild = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(listChild, Id.ZERO, null, null, SharedListSignal.ListPosition.last()));
        Id mapChild = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(mapChild, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearCommand(this.commandId, Id.ZERO));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)3, (int)accept.updates().size());
        CommandResult.NodeModification listChildUpdate = (CommandResult.NodeModification)accept.updates().get(listChild);
        Assertions.assertNull((Object)listChildUpdate.newNode());
        CommandResult.NodeModification mapChildUpdate = (CommandResult.NodeModification)accept.updates().get(mapChild);
        Assertions.assertNull((Object)mapChildUpdate.newNode());
        CommandResult.NodeModification parentUpdate = (CommandResult.NodeModification)accept.updates().get(Id.ZERO);
        Assertions.assertEquals(Map.of(), (Object)((Node.Data)parentUpdate.newNode()).mapChildren());
        this.assertMapChildren(Id.ZERO, Map.of());
    }

    @Test
    void clearCommand_emptyNode_noChange() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearCommand(this.commandId, Id.ZERO));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals(Map.of(), (Object)accept.updates());
        this.assertUnchanged();
    }

    @Test
    void clearCommand_alias_dataNodeUpdated() {
        this.insertChildren(Id.ZERO, 1);
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearCommand(alias, Id.ZERO));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertTrue((boolean)accept.updates().containsKey(Id.ZERO));
        Assertions.assertFalse((boolean)accept.updates().containsKey(alias));
        this.assertListChildren(Id.ZERO, new Id[0]);
    }

    @Test
    void positionConditionNoPosition_listChild_accepted() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, child, new SharedListSignal.ListPosition(null, null)));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionConditionNoPosition_missingChild_rejected() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, Id.random(), new SharedListSignal.ListPosition(null, null)));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionNoPosition_mapChild_rejected() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, child, new SharedListSignal.ListPosition(null, null)));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionNoPosition_otherParent_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, children.get(0), children.get(1), new SharedListSignal.ListPosition(null, null)));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionFirst_isFirst_accepted() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(0), SharedListSignal.ListPosition.first()));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionConditionFirst_isNotFirst_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), SharedListSignal.ListPosition.first()));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionLast_isNotLast_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(0), SharedListSignal.ListPosition.last()));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionLast_isLast_accepted() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), SharedListSignal.ListPosition.last()));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionConditionAfter_isAfter_accepted() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), new SharedListSignal.ListPosition(children.get(0), null)));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionConditionAfter_itself_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(0), new SharedListSignal.ListPosition(children.get(0), null)));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionAfter_isNotAfter_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(0), new SharedListSignal.ListPosition(children.get(1), null)));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionBefore_isBefore_accepted() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(0), new SharedListSignal.ListPosition(null, children.get(1))));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionConditionBefore_itself_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(0), new SharedListSignal.ListPosition(null, children.get(0))));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionBefore_isNotBefore_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 2);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), new SharedListSignal.ListPosition(null, children.get(0))));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionConditionBetween_isBetween_accepted() {
        List<Id> children = this.insertChildren(Id.ZERO, 3);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), new SharedListSignal.ListPosition(children.get(0), children.get(2))));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionConditionBetween_notBetween_rejected() {
        List<Id> children = this.insertChildren(Id.ZERO, 3);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), new SharedListSignal.ListPosition(children.get(2), children.get(1))));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void positionCondition_parentAlias_checksAliasTarget() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, alias, child, new SharedListSignal.ListPosition(null, null)));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionCondition_childAlias_checkAliasTarget() {
        Id child = this.insertChildren(Id.ZERO, 1).get(0);
        Id alias = this.createAlias(child);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, alias, new SharedListSignal.ListPosition(null, null)));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void positionCondition_aliasSiblings_checkAliasTargets() {
        List<Id> children = this.insertChildren(Id.ZERO, 3);
        Id first = this.createAlias(children.get(0));
        Id last = this.createAlias(children.get(2));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.PositionCondition(this.commandId, Id.ZERO, children.get(1), new SharedListSignal.ListPosition(first, last)));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void valueCondition_sameValue_accepted() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new StringNode("value")));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ValueCondition(this.commandId, Id.ZERO, (JsonNode)new StringNode("value")));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void valueCondition_alias_dataNodeChecked() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new StringNode("value")));
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ValueCondition(this.commandId, alias, (JsonNode)new StringNode("value")));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void valueCondition_otherValue_rejected() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new StringNode("other")));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ValueCondition(this.commandId, Id.ZERO, (JsonNode)new StringNode("value")));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void valueConditiontNull_jsonNullValue_accepted() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)NullNode.getInstance()));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ValueCondition(this.commandId, Id.ZERO, null));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void valueConditionJsonNull_nullValue_accepted() {
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ValueCondition(this.commandId, Id.ZERO, (JsonNode)NullNode.getInstance()));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void lastUpdateCondition_sameValue_accepted() {
        Id update = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(update, Id.ZERO, null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.LastUpdateCondition(this.commandId, Id.ZERO, update));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void lastUpdateCondition_alias_targetNodeChecked() {
        Id update = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(update, Id.ZERO, null));
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.LastUpdateCondition(this.commandId, alias, update));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void lastUpdateCondition_differentValue_rejected() {
        Id update = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.SetCommand(update, Id.ZERO, null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.LastUpdateCondition(this.commandId, Id.ZERO, Id.random()));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void keyConditionNoKey_noKey_accepted() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", Id.ZERO));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void keyConditionNoKey_keyPresent_rejected() {
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", Id.ZERO));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void keyConditionKeyPresent_keyPresent_accepted() {
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", null));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void keyConditionKeyPresent_noKey_rejected() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", null));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void keyConditionSpecificNode_nodePresent_accepted() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", child));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void keyConditionSpecificNode_noNode_rejected() {
        Id child = Id.random();
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", child));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void keyConditionSpecificNode_otherKey_rejected() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "other", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", child));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void keyConditionSpecificNode_otherNode_rejected() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "other", null));
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(Id.random(), Id.ZERO, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", child));
        MutableTreeRevisionTest.assertTestResult(false, result);
    }

    @Test
    void keyCondition_aliasParent_targetChecked() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        Id alias = this.createAlias(Id.ZERO);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, alias, "key", child));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void keyCondition_aliasChild_targetChecked() {
        Id child = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null));
        Id alias = this.createAlias(child);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.KeyCondition(this.commandId, Id.ZERO, "key", alias));
        MutableTreeRevisionTest.assertTestResult(true, result);
    }

    @Test
    void transactionCommand_empty_noChange() {
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.TransactionCommand(this.commandId, List.of()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals(Map.of(), (Object)accept.updates());
        this.assertUnchanged();
    }

    @Test
    void transactionCommand_allAccepted_changesApplied() {
        Id command1 = Id.random();
        Id command2 = Id.random();
        Map results = this.revision.applyAndGetResults(List.of(new SignalCommand.TransactionCommand(this.commandId, List.of(new SignalCommand.SetCommand(command1, Id.ZERO, (JsonNode)new StringNode("value")), new SignalCommand.PutCommand(command2, Id.ZERO, "key", null)))));
        CommandResult.Accept transaction = MutableTreeRevisionTest.assertAccepted((CommandResult)results.get(this.commandId));
        Assertions.assertEquals((int)2, (int)transaction.updates().size());
        CommandResult.NodeModification rootModification = (CommandResult.NodeModification)transaction.updates().get(Id.ZERO);
        Assertions.assertEquals((Object)Node.EMPTY, (Object)rootModification.oldNode());
        Assertions.assertEquals(this.revision.nodes().get(Id.ZERO), (Object)rootModification.newNode());
        CommandResult.Accept set = MutableTreeRevisionTest.assertAccepted((CommandResult)results.get(command1));
        Node.Data setModificationNode = (Node.Data)set.onlyUpdate().newNode();
        Assertions.assertEquals((Object)"value", (Object)setModificationNode.value().asString());
        Assertions.assertEquals(Map.of(), (Object)setModificationNode.mapChildren());
        this.assertValue(Id.ZERO, "value");
        this.assertMapChildren(Id.ZERO, Map.of("key", command2));
    }

    @Test
    void transactionCommand_lastRejected_allRejected() {
        Id command1 = Id.random();
        Id command2 = Id.random();
        Map results = this.revision.applyAndGetResults(List.of(new SignalCommand.TransactionCommand(this.commandId, List.of(new SignalCommand.SetCommand(command1, Id.ZERO, (JsonNode)new StringNode("value")), new SignalCommand.ValueCondition(command2, Id.ZERO, null)))));
        Assertions.assertEquals(Set.of(command1, command2, this.commandId), results.keySet());
        for (CommandResult subResult : results.values()) {
            Assertions.assertFalse((boolean)subResult.accepted());
        }
        this.assertUnchanged();
    }

    @Test
    void transactionCommand_nestedTransactions_allApplied() {
        Id set = Id.random();
        Id innerTransaction = Id.random();
        Map results = this.revision.applyAndGetResults(List.of(new SignalCommand.TransactionCommand(this.commandId, List.of(new SignalCommand.TransactionCommand(innerTransaction, List.of(new SignalCommand.SetCommand(set, Id.ZERO, (JsonNode)new StringNode("value"))))))));
        Assertions.assertEquals((int)3, (int)results.size());
        MutableTreeRevisionTest.assertAccepted((CommandResult)results.get(this.commandId));
        MutableTreeRevisionTest.assertAccepted((CommandResult)results.get(innerTransaction));
        MutableTreeRevisionTest.assertAccepted((CommandResult)results.get(set));
        this.assertValue(Id.ZERO, "value");
    }

    @Test
    void snapshotEvent_withNodes_loaded() {
        MutableTreeRevision copy = new MutableTreeRevision((TreeRevision)this.revision);
        Id child = Id.random();
        copy.apply((SignalCommand)new SignalCommand.PutCommand(child, Id.ZERO, "key", null), null);
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.SnapshotCommand(this.commandId, copy.nodes()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)2, (int)accept.updates().size());
        this.assertMapChildren(Id.ZERO, Map.of("key", child));
    }

    @Test
    void clearOwnerEvent_ownedListNode_removed() {
        Id node = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.InsertCommand(node, Id.ZERO, this.revision.ownerId(), null, SharedListSignal.ListPosition.last()));
        Assertions.assertEquals((Object)node, (Object)((SignalCommand.ScopeOwnerCommand)this.revision.originalInserts().get(node)).commandId());
        Id childOfOwned = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutCommand(childOfOwned, node, "key", null));
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearOwnerCommand(this.commandId, this.revision.ownerId()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)3, (int)accept.updates().size());
        this.assertListChildren(Id.ZERO, new Id[0]);
        Assertions.assertEquals(Set.of(Id.ZERO), this.revision.nodes().keySet());
        Assertions.assertEquals(Map.of(), (Object)this.revision.originalInserts());
    }

    @Test
    void clearOwnerEvent_ownedMapNode_removed() {
        Id node = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(node, Id.ZERO, this.revision.ownerId(), "key", null));
        Assertions.assertEquals((Object)node, (Object)((SignalCommand.ScopeOwnerCommand)this.revision.originalInserts().get(node)).commandId());
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearOwnerCommand(this.commandId, this.revision.ownerId()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)2, (int)accept.updates().size());
        this.assertMapChildren(Id.ZERO, Map.of());
        Assertions.assertEquals(Map.of(), (Object)this.revision.originalInserts());
    }

    @Test
    void clearOwnerEvent_ownedByOther_retained() {
        Id node = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(node, Id.ZERO, Id.random(), "key", null));
        Assertions.assertEquals(Map.of(), (Object)this.revision.originalInserts());
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearOwnerCommand(this.commandId, this.revision.ownerId()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)0, (int)accept.updates().size());
        this.assertMapChildren(Id.ZERO, Map.of("key", node));
    }

    @Test
    void clearOwnerEvent_ownedByNone_retained() {
        Id node = Id.random();
        this.applySingle((SignalCommand)new SignalCommand.PutIfAbsentCommand(node, Id.ZERO, null, "key", null));
        Assertions.assertEquals(Map.of(), (Object)this.revision.originalInserts());
        CommandResult result = this.applySingle((SignalCommand)new SignalCommand.ClearOwnerCommand(this.commandId, this.revision.ownerId()));
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        Assertions.assertEquals((int)0, (int)accept.updates().size());
        this.assertMapChildren(Id.ZERO, Map.of("key", node));
    }

    @Test
    void apply_listOfCommands_appliesAllCommands() {
        SignalCommand.SetCommand setA = new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new StringNode("a"));
        SignalCommand.ValueCondition testB = new SignalCommand.ValueCondition(Id.random(), Id.ZERO, (JsonNode)new StringNode("b"));
        SignalCommand.InsertCommand insertC = new SignalCommand.InsertCommand(Id.random(), Id.ZERO, null, (JsonNode)new StringNode("c"), SharedListSignal.ListPosition.first());
        this.revision.apply(List.of(setA, testB, insertC));
        this.assertValue(Id.ZERO, "a");
        this.assertListChildren(Id.ZERO, insertC.commandId());
    }

    private CommandResult applySingle(SignalCommand command) {
        Map results = this.revision.applyAndGetResults(List.of(command));
        Assertions.assertEquals((int)1, (int)results.size());
        return (CommandResult)results.get(command.commandId());
    }

    private void assertNullValue(Id nodeId) {
        Assertions.assertNull((Object)((Node.Data)this.revision.data(nodeId).get()).value());
    }

    private void assertValue(Id nodeId, String expectedValue) {
        Assertions.assertEquals((Object)new StringNode(expectedValue), (Object)((Node.Data)this.revision.data(nodeId).get()).value());
    }

    private void assertValue(Id nodeId, double expectedValue) {
        Assertions.assertEquals((Object)new DoubleNode(expectedValue), (Object)((Node.Data)this.revision.data(nodeId).get()).value());
    }

    private void assertListChildren(Id nodeId, Id ... expectedChildren) {
        Assertions.assertEquals(List.of(expectedChildren), (Object)((Node.Data)this.revision.data(nodeId).get()).listChildren());
        for (Id child : expectedChildren) {
            Assertions.assertEquals((Object)nodeId, (Object)((Node.Data)this.revision.data(child).get()).parent());
        }
    }

    private void assertMapChildren(Id nodeId, Map<String, Id> expectedChildren) {
        Assertions.assertEquals(expectedChildren, (Object)((Node.Data)this.revision.data(nodeId).get()).mapChildren());
        for (Id child : expectedChildren.values()) {
            Assertions.assertEquals((Object)nodeId, (Object)((Node.Data)this.revision.data(child).get()).parent());
        }
    }

    private void assertMapKeys(Id nodeId, String ... expectedKeys) {
        Assertions.assertEquals(List.of(expectedKeys), List.copyOf(((Node.Data)this.revision.data(nodeId).get()).mapChildren().keySet()));
    }

    private void assertUnchanged() {
        Assertions.assertEquals(Map.of(Id.ZERO, Node.EMPTY), (Object)this.revision.nodes());
    }

    private static void assertTestResult(boolean expectedResult, CommandResult result) {
        Assertions.assertEquals((Object)expectedResult, (Object)result.accepted());
        if (result.accepted()) {
            Assertions.assertEquals((int)0, (int)((CommandResult.Accept)result).updates().size());
        }
    }

    private static CommandResult.Accept assertAccepted(CommandResult result) {
        Assertions.assertTrue((boolean)result.accepted());
        return (CommandResult.Accept)result;
    }

    private static Node.Data assertSingleDataChange(CommandResult result) {
        CommandResult.Accept accept = MutableTreeRevisionTest.assertAccepted(result);
        CommandResult.NodeModification onlyUpdate = accept.onlyUpdate();
        return (Node.Data)onlyUpdate.newNode();
    }

    private List<Id> insertChildren(Id parent, int count) {
        return IntStream.range(0, count).mapToObj(ignore -> Id.random()).peek(id -> this.applySingle((SignalCommand)new SignalCommand.InsertCommand(id, parent, null, null, SharedListSignal.ListPosition.last()))).toList();
    }

    private Id createAlias(Id target) {
        Id alias = Id.random();
        this.revision.nodes().put(alias, new Node.Alias(target));
        return alias;
    }
}

