/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.ValueModifier;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MappedModifySignalTest
extends SignalTestBase {
    @Test
    void map_readValue_returnsMappedValue() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        Assertions.assertFalse((boolean)((Boolean)doneSignal.get()));
        todoSignal.modify((ValueModifier & Serializable)t -> t.setDone(true));
        Assertions.assertTrue((boolean)((Boolean)doneSignal.get()));
    }

    @Test
    void map_peek_returnsMappedValue() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        Assertions.assertFalse((boolean)((Boolean)doneSignal.peek()));
    }

    @Test
    void map_setValue_modifiesParentValueInPlace() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        doneSignal.set((Object)true);
        Assertions.assertTrue((boolean)todo.isDone());
        Assertions.assertSame((Object)todo, (Object)todoSignal.get());
    }

    @Test
    void map_setValue_returnsPreviousValue() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        SignalOperation operation = doneSignal.set((Object)true);
        Boolean oldValue = (Boolean)TestUtil.assertSuccess(operation);
        Assertions.assertFalse((boolean)oldValue);
    }

    @Test
    void map_setValuePreservesOtherFields() {
        MutableTodo todo = new MutableTodo("Original text", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        doneSignal.set((Object)true);
        Assertions.assertEquals((Object)"Original text", (Object)todo.getText());
    }

    @Test
    void map_replaceWithExpectedValue_updatesSignal() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        SignalOperation operation = doneSignal.replace((Object)false, (Object)true);
        TestUtil.assertSuccess(operation);
        Assertions.assertTrue((boolean)((Boolean)doneSignal.get()));
        Assertions.assertTrue((boolean)todo.isDone());
    }

    @Test
    void map_replaceWithUnexpectedValue_fails() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        SignalOperation operation = doneSignal.replace((Object)true, (Object)false);
        TestUtil.assertFailure(operation);
        Assertions.assertFalse((boolean)((Boolean)doneSignal.get()));
        Assertions.assertFalse((boolean)todo.isDone());
    }

    @Test
    void map_update_modifiesInPlace() {
        MutableTodo todo = new MutableTodo("Task", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        CancelableOperation operation = doneSignal.update((SignalUpdater & Serializable)value -> value == false);
        Boolean oldValue = (Boolean)TestUtil.assertSuccess(operation);
        Assertions.assertFalse((boolean)oldValue);
        Assertions.assertTrue((boolean)((Boolean)doneSignal.get()));
        Assertions.assertTrue((boolean)todo.isDone());
        Assertions.assertSame((Object)todo, (Object)todoSignal.get());
    }

    @Test
    void map_update_preservesOtherFields() {
        MutableTodo todo = new MutableTodo("Task", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        doneSignal.update((SignalUpdater & Serializable)value -> value == false);
        Assertions.assertEquals((Object)"Task", (Object)todo.getText());
    }

    @Test
    void map_effectTracking_tracksChanges() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        AtomicInteger effectCount = new AtomicInteger();
        Signal.effect((EffectAction & Serializable)() -> {
            doneSignal.get();
            effectCount.incrementAndGet();
        });
        Assertions.assertEquals((int)1, (int)effectCount.get());
        doneSignal.set((Object)true);
        Assertions.assertEquals((int)2, (int)effectCount.get());
    }

    @Test
    void map_asReadonly_createsReadonlyView() {
        MutableTodo todo = new MutableTodo("Buy milk", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        Signal readonlySignal = doneSignal.asReadonly();
        Assertions.assertFalse((boolean)(readonlySignal instanceof WritableSignal));
        doneSignal.set((Object)true);
        Assertions.assertTrue((boolean)((Boolean)readonlySignal.get()));
    }

    @Test
    void map_multipleFieldMappings_independent() {
        MutableTodo todo = new MutableTodo("Task", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal textSignal = todoSignal.mapMutable(MutableTodo::getText, MutableTodo::setText);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        textSignal.set((Object)"Updated task");
        Assertions.assertEquals((Object)"Updated task", (Object)todo.getText());
        Assertions.assertFalse((boolean)todo.isDone());
        doneSignal.set((Object)true);
        Assertions.assertEquals((Object)"Updated task", (Object)todo.getText());
        Assertions.assertTrue((boolean)todo.isDone());
    }

    @Test
    void map_sameInstanceMaintained_afterModification() {
        MutableTodo todo = new MutableTodo("Task", false);
        ValueSignal todoSignal = new ValueSignal((Object)todo);
        WritableSignal doneSignal = todoSignal.mapMutable(MutableTodo::isDone, MutableTodo::setDone);
        doneSignal.set((Object)true);
        Assertions.assertSame((Object)todo, (Object)todoSignal.get());
        doneSignal.set((Object)false);
        Assertions.assertSame((Object)todo, (Object)todoSignal.get());
        doneSignal.update((SignalUpdater & Serializable)d -> d == false);
        Assertions.assertSame((Object)todo, (Object)todoSignal.get());
    }

    static class MutableTodo {
        private String text;
        private boolean done;

        MutableTodo(String text, boolean done) {
            this.text = text;
            this.done = done;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }
    }
}

