/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MappedWritableSignalTest
extends SignalTestBase {
    @Test
    void map_readValue_returnsMappedValue() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        Assertions.assertFalse((boolean)((Boolean)doneSignal.get()));
        todoSignal.set((Object)new Todo("Buy milk", true));
        Assertions.assertTrue((boolean)((Boolean)doneSignal.get()));
    }

    @Test
    void map_peek_returnsMappedValue() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        Assertions.assertFalse((boolean)((Boolean)doneSignal.peek()));
    }

    @Test
    void map_setValue_updatesParentSignal() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        doneSignal.set((Object)true);
        Assertions.assertEquals((Object)new Todo("Buy milk", true), (Object)todoSignal.get());
    }

    @Test
    void map_setValue_returnsPreviousValue() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        SignalOperation operation = doneSignal.set((Object)true);
        Boolean oldValue = (Boolean)TestUtil.assertSuccess(operation);
        Assertions.assertFalse((boolean)oldValue);
    }

    @Test
    void map_setValuePreservesOtherFields() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Original text", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        doneSignal.set((Object)true);
        Assertions.assertEquals((Object)"Original text", (Object)((Todo)todoSignal.get()).text());
    }

    @Test
    void map_replaceWithExpectedValue_updatesSignal() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        SignalOperation operation = doneSignal.replace((Object)false, (Object)true);
        TestUtil.assertSuccess(operation);
        Assertions.assertTrue((boolean)((Boolean)doneSignal.get()));
    }

    @Test
    void map_replaceWithUnexpectedValue_fails() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        SignalOperation operation = doneSignal.replace((Object)true, (Object)false);
        TestUtil.assertFailure(operation);
        Assertions.assertFalse((boolean)((Boolean)doneSignal.get()));
    }

    @Test
    void map_update_updatesValue() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Task", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        CancelableOperation operation = doneSignal.update((SignalUpdater & Serializable)value -> value == false);
        Boolean oldValue = (Boolean)TestUtil.assertSuccess(operation);
        Assertions.assertFalse((boolean)oldValue);
        Assertions.assertTrue((boolean)((Boolean)doneSignal.get()));
        Assertions.assertEquals((Object)new Todo("Task", true), (Object)todoSignal.get());
    }

    @Test
    void map_update_preservesOtherFields() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Task", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        doneSignal.update((SignalUpdater & Serializable)value -> value == false);
        Assertions.assertEquals((Object)"Task", (Object)((Todo)todoSignal.get()).text());
    }

    @Test
    void map_nestedMapping_works() {
        record Outer(Todo inner) {
            Outer withInner(Todo inner) {
                return new Outer(inner);
            }
        }
        ValueSignal outerSignal = new ValueSignal((Object)new Outer(new Todo("Task", false)));
        WritableSignal todoSignal = outerSignal.map(Outer::inner, Outer::withInner);
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        doneSignal.set((Object)true);
        Assertions.assertTrue((boolean)((Outer)outerSignal.get()).inner().done());
        Assertions.assertEquals((Object)"Task", (Object)((Outer)outerSignal.get()).inner().text());
    }

    @Test
    void map_effectTracking_tracksChanges() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        AtomicInteger effectCount = new AtomicInteger();
        Signal.effect((EffectAction & Serializable)() -> {
            doneSignal.get();
            effectCount.incrementAndGet();
        });
        Assertions.assertEquals((int)1, (int)effectCount.get());
        doneSignal.set((Object)true);
        Assertions.assertEquals((int)2, (int)effectCount.get());
        todoSignal.set((Object)new Todo("Changed", true));
        Assertions.assertEquals((int)3, (int)effectCount.get());
    }

    @Test
    void map_asReadonly_createsReadonlyView() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Buy milk", false));
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        Signal readonlySignal = doneSignal.asReadonly();
        Assertions.assertFalse((boolean)(readonlySignal instanceof WritableSignal));
        doneSignal.set((Object)true);
        Assertions.assertTrue((boolean)((Boolean)readonlySignal.get()));
    }

    @Test
    void map_multipleFieldMappings_independent() {
        ValueSignal todoSignal = new ValueSignal((Object)new Todo("Task", false));
        WritableSignal textSignal = todoSignal.map(Todo::text, Todo::withText);
        WritableSignal doneSignal = todoSignal.map(Todo::done, Todo::withDone);
        textSignal.set((Object)"Updated task");
        Assertions.assertEquals((Object)"Updated task", (Object)((Todo)todoSignal.get()).text());
        Assertions.assertFalse((boolean)((Todo)todoSignal.get()).done());
        doneSignal.set((Object)true);
        Assertions.assertEquals((Object)"Updated task", (Object)((Todo)todoSignal.get()).text());
        Assertions.assertTrue((boolean)((Todo)todoSignal.get()).done());
    }

    record Todo(String text, boolean done) {
        Todo withText(String text) {
            return new Todo(text, this.done);
        }

        Todo withDone(boolean done) {
            return new Todo(this.text, done);
        }
    }
}

