/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.MockServletContext;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

@NotThreadSafe
public class MenuRegistryTest {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();
    private ApplicationRouteRegistry registry;
    @Mock
    private MockService vaadinService;
    private VaadinSession session;
    private ServletContext servletContext;
    private VaadinServletContext vaadinContext;
    @Mock
    private DeploymentConfiguration deploymentConfiguration;
    @Mock
    private VaadinRequest request;
    private AutoCloseable closeable;
    private MockedStatic<FrontendUtils> frontendUtils;
    public static String testClientRouteFile = "[\n  {\n    \"route\": \"\",\n    \"params\": {},\n    \"title\": \"Layout\",\n    \"children\": [\n      {\n        \"route\": \"\",\n        \"params\": {},\n        \"title\": \"Public\"\n      },\n      {\n        \"route\": \"about\",\n        \"loginRequired\": true,\n        \"params\": {},\n        \"title\": \"About\"\n      },\n      {\n        \"route\": \"hilla\",\n        \"loginRequired\": true,\n        \"rolesAllowed\": [\n          \"ROLE_USER\"\n        ],\n        \"params\": {},\n        \"title\": \"Hilla\",\n        \"children\": [\n          {\n            \"route\": \"sub\",\n            \"params\": {},\n            \"title\": \"Hilla Sub\"\n          }\n        ]\n      },\n      {\n        \"route\": \"wc_params/:param?\",\n        \"loginRequired\": false,\n        \"params\": {\n           \":param\": \"*\"\n        },\n        \"title\": \"wc_params path is included in menu\"\n      },\n      {\n        \"route\": \"opt_params/:param?\",\n        \"loginRequired\": false,\n        \"params\": {\n           \":param\": \"opt\"\n        },\n        \"title\": \"opt_params path is included in menu\"\n      },\n      {\n        \"route\": \"params_with_opt_children\",\n        \"loginRequired\": false,\n        \"children\": [\n            {\n                \"route\": \":param?\",\n                \"loginRequired\": false,\n                \"params\": {\n                   \":param\": \"opt\"\n                },\n                \"title\": \"params_with_opt_children/:param? path is included in menu\"\n            }\n        ]\n      },\n      {\n        \"route\": \"req_params/:param\",\n        \"loginRequired\": false,\n        \"params\": {\n           \":param\": \"req\"\n        },\n        \"title\": \"req_params path is excluded from menu\"\n      },\n      {\n        \"route\": \"params\",\n        \"loginRequired\": false,\n        \"title\": null,\n        \"children\": [\n          {\n            \"route\": \":param\",\n            \"loginRequired\": false,\n            \"params\": {\n               \":param\": \"req\"\n            },\n            \"title\": \"params/:param path is excluded from menu\",\n            \"children\": [\n              {\n                \"route\": \"sub\",\n                \"loginRequired\": false,\n                \"title\": \"params/:param/sub path is excluded from menu\"\n              }\n            ]\n          }\n        ]\n      },\n      {\n        \"route\": \"login\",\n        \"menu\": {\n          \"exclude\": true\n        },\n        \"params\": {},\n        \"title\": \"Login\"\n      }\n    ]\n  }\n]\n";
    String nestedLoginRequiredRouteFile = "[\n  {\n    \"route\": \"\",\n    \"params\": {},\n    \"title\": \"current Title\",\n    \"children\": [\n      {\n        \"route\": \"\",\n        \"loginRequired\": true,\n        \"params\": {},\n        \"title\": \"navigate\"\n      },\n      {\n        \"route\": \"admin\",\n        \"loginRequired\": true,\n        \"title\": \"Admin\",\n        \"params\": {},\n        \"children\": [\n          {\n            \"route\": \"planets\",\n            \"loginRequired\": true,\n            \"title\": \"Planets\",\n            \"params\": {},\n            \"children\": [\n              {\n                \"route\": \"\",\n                \"loginRequired\": true,\n                \"title\": \"Planets\",\n                \"params\": {}\n              }\n            ]\n          }\n        ]\n      }\n    ]\n  }\n]\n";
    String emptyChildren = "[\n  {\n    \"route\": \"\",\n    \"title\": \"Main Layout\",\n    \"children\": []\n  }\n]\n";
    String nonEmptyRoute = "[\n  {\n    \"route\": \"foo\",\n    \"title\": \"Main Layout\",\n    \"children\": [\n      {\n        \"route\": \"hilla\",\n        \"flowLayout\": false,\n        \"params\": {},\n        \"title\": \"Hilla view\"\n      }\n    ]\n  }\n]\n";
    String singleRoute = "[\n  {\n    \"route\": \"\",\n    \"menu\": {\n      \"title\": \"Public page\",\n      \"icon\": \"vaadin:group\"\n    },\n    \"flowLayout\": false,\n    \"params\": {},\n    \"title\": \"Public\"\n  }\n]\n";
    String multipleRootRoutes = "[\n  {\n    \"route\": \"hilla\",\n    \"flowLayout\": false,\n    \"params\": {},\n    \"children\": [\n      {\n        \"route\": \"\",\n        \"flowLayout\": false,\n        \"params\": {},\n        \"title\": \"Layout\"\n      }\n    ]\n  },\n  {\n    \"route\": \"\",\n    \"flowLayout\": false,\n    \"params\": {},\n    \"title\": \"Layout\",\n    \"children\": [\n      {\n        \"route\": \"components\",\n        \"menu\": {\n          \"title\": \"React Components\"\n        },\n        \"flowLayout\": false,\n        \"params\": {},\n        \"title\": \"Components\"\n      }\n    ]\n  }\n]\n";

    @Before
    public void init() {
        this.closeable = MockitoAnnotations.openMocks((Object)this);
        this.servletContext = new MockServletContext();
        this.vaadinContext = new MockVaadinContext(this.servletContext);
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getRouteRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getInstantiator()).thenReturn((Object)new DefaultInstantiator((VaadinService)this.vaadinService));
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        Mockito.when((Object)this.deploymentConfiguration.getFrontendFolder()).thenReturn((Object)this.tmpDir.getRoot());
        Mockito.when((Object)this.deploymentConfiguration.getProjectFolder()).thenReturn((Object)this.tmpDir.getRoot());
        Mockito.when((Object)this.deploymentConfiguration.getBuildFolder()).thenReturn((Object)"build");
        this.frontendUtils = Mockito.mockStatic(FrontendUtils.class);
        this.frontendUtils.when(() -> FrontendUtils.isHillaUsed((File)((File)Mockito.any()))).thenReturn((Object)true);
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        this.session = new MockVaadinSession((VaadinService)this.vaadinService){

            public VaadinService getService() {
                return MenuRegistryTest.this.vaadinService;
            }
        };
        VaadinSession.setCurrent((VaadinSession)this.session);
        Mockito.when((Object)this.request.getService()).thenReturn((Object)this.vaadinService);
        CurrentInstance.set(VaadinRequest.class, (Object)this.request);
    }

    @After
    public void cleanup() throws Exception {
        this.frontendUtils.close();
        this.closeable.close();
        CurrentInstance.clearAll();
    }

    @Test
    public void getMenuItemsContainsExpectedClientPaths() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        Map menuItems = MenuRegistry.getMenuItems((boolean)true);
        Assert.assertEquals((long)10L, (long)menuItems.size());
        this.assertClientRoutes(menuItems);
    }

    @Test
    public void getMenuItemsWithNestedFiltering_doesNotThrow() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)this.nestedLoginRequiredRouteFile, new OpenOption[0]);
        Map menuItems = MenuRegistry.getMenuItems((boolean)true);
        Assert.assertEquals((long)0L, (long)menuItems.size());
    }

    @Test
    public void getMenuItemsNoFilteringContainsAllClientPaths() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        Map menuItems = MenuRegistry.getMenuItems((boolean)false);
        Assert.assertEquals((long)13L, (long)menuItems.size());
        this.assertClientRoutes(menuItems, true, true, false);
    }

    @Test
    public void testNonCollidingServerAndClientRoutesDoesNotThrow() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MyRoute.class, MyInfo.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        Map menuItems = MenuRegistry.getMenuItems((boolean)false);
        Assert.assertEquals((long)15L, (long)menuItems.size());
        RouteUtil.checkForClientRouteCollisions((VaadinService)this.vaadinService, (List)routeConfiguration.getAvailableRoutes());
    }

    @Test(expected=InvalidRouteConfigurationException.class)
    public void testCollidingServerAndClientRouteDoesThrow() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MyRoute.class, MyInfo.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        routeConfiguration.setAnnotatedRoute(ConflictRoute.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void productionMode_getMenuItemsContainsExpectedClientPaths() throws IOException {
        Mockito.when((Object)this.deploymentConfiguration.isProductionMode()).thenReturn((Object)true);
        MenuRegistry.clearFileRoutesCache();
        this.tmpDir.newFolder(new String[]{"META-INF", "VAADIN"});
        File clientFiles = new File(this.tmpDir.getRoot(), "META-INF/VAADIN/file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        ClassLoader mockClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)mockClassLoader.getResource("META-INF/VAADIN/file-routes.json")).thenReturn((Object)clientFiles.toURI().toURL());
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            menuRegistry.when(() -> MenuRegistry.getClassLoader()).thenReturn((Object)mockClassLoader);
            Map menuItems = MenuRegistry.getMenuItems((boolean)true);
            Assert.assertEquals((long)10L, (long)menuItems.size());
            this.assertClientRoutes(menuItems);
        }
        finally {
            MenuRegistry.clearFileRoutesCache();
        }
    }

    @Test
    public void getMenuItemsContainsExpectedServerPaths() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MyRoute.class, MyInfo.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        Map menuItems = MenuRegistry.getMenuItems((boolean)true);
        Assert.assertEquals((long)2L, (long)menuItems.size());
        this.assertServerRoutes(menuItems);
    }

    @Test
    public void getMenuItemsContainBothClientAndServerPaths() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MyRoute.class, MyInfo.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        Map menuItems = MenuRegistry.getMenuItems((boolean)true);
        Assert.assertEquals((long)12L, (long)menuItems.size());
        this.assertClientRoutes(menuItems);
        this.assertServerRoutes(menuItems);
    }

    @Test
    public void collectMenuItems_returnsCorrectPaths() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MyRoute.class, MyInfo.class, MyRequiredParamRoute.class, MyRequiredAndOptionalParamRoute.class, MyOptionalParamRoute.class, MyVarargsParamRoute.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        Map menuItems = MenuRegistry.collectMenuItems();
        Assert.assertEquals((long)8L, (long)menuItems.size());
        this.assertClientRoutes(menuItems, false, false, true);
        this.assertServerRoutes(menuItems);
        this.assertServerRoutesWithParameters(menuItems, true);
    }

    @Test
    public void testWithLoggedInUser_userHasRoles() throws IOException {
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)((Principal)Mockito.mock(Principal.class)));
        Mockito.when((Object)this.request.isUserInRole(Mockito.anyString())).thenReturn((Object)true);
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        Map menuItems = MenuRegistry.getMenuItems((boolean)true);
        Assert.assertEquals((long)13L, (long)menuItems.size());
        this.assertClientRoutes(menuItems, true, true, false);
        List menuItemsList = MenuRegistry.collectMenuItemsList();
        Assert.assertEquals((String)"List of menu items has incorrect size. Excluded menu item like /login is not expected.", (long)7L, (long)menuItemsList.size());
        this.assertOrder(menuItemsList, new String[]{"/", "/about", "/hilla", "/hilla/sub", "/opt_params", "/params_with_opt_children", "/wc_params"});
    }

    @Test
    public void testWithLoggedInUser_noMatchingRoles() throws IOException {
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)((Principal)Mockito.mock(Principal.class)));
        Mockito.when((Object)this.request.isUserInRole(Mockito.anyString())).thenReturn((Object)false);
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        Map menuItems = MenuRegistry.getMenuItems((boolean)true);
        Assert.assertEquals((long)11L, (long)menuItems.size());
        this.assertClientRoutes(menuItems, true, false, false);
    }

    @Test
    public void getMenuItemsList_returnsCorrectPaths() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MyRoute.class, MyInfo.class, MyRequiredParamRoute.class, MyRequiredAndOptionalParamRoute.class, MyOptionalParamRoute.class, MyVarargsParamRoute.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        List menuItems = MenuRegistry.collectMenuItemsList();
        Assert.assertEquals((long)8L, (long)menuItems.size());
        this.assertOrder(menuItems, new String[]{"/", "/home", "/info", "/opt_params", "/param", "/param/varargs", "/params_with_opt_children", "/wc_params"});
        Map<String, AvailableViewInfo> mapMenuItems = menuItems.stream().collect(Collectors.toMap(AvailableViewInfo::route, item -> item));
        this.assertClientRoutes(mapMenuItems, false, false, true, "/");
        this.assertServerRoutes(mapMenuItems);
        this.assertServerRoutesWithParameters(mapMenuItems, true);
    }

    @Test
    public void getMenuItemsList_assertOrder() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(TestRouteA.class, TestRouteB.class, TestRouteC.class, TestRouteD.class, TestRouteDA.class, TestRouteDB.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        List menuItems = MenuRegistry.collectMenuItemsList();
        Assert.assertEquals((long)4L, (long)menuItems.size());
        this.assertOrder(menuItems, new String[]{"/d", "/c", "/a", "/b", "/d/a", "/d/b"});
    }

    @Test
    public void hasHillaAutoLayout_fileRoutesHasSingleRootLayout_true() throws IOException {
        ArrayNode fileRoutes = (ArrayNode)JacksonUtils.getMapper().readTree(testClientRouteFile);
        JsonNode layout = fileRoutes.get(0);
        ArrayNode children = (ArrayNode)layout.get("children");
        Assert.assertNotNull((Object)children);
        this.assertHasHillaMainLayout(testClientRouteFile, true);
    }

    @Test
    public void hasHillaAutoLayout_fileRoutesHasEmptyChildren_true() throws IOException {
        ArrayNode fileRoutes = (ArrayNode)JacksonUtils.getMapper().readTree(this.emptyChildren);
        JsonNode layout = fileRoutes.get(0);
        ArrayNode children = (ArrayNode)layout.get("children");
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
        this.assertHasHillaMainLayout(this.emptyChildren, true);
    }

    @Test
    public void hasHillaAutoLayout_fileRoutesHasSingleRootRoute_false() throws IOException {
        Assert.assertFalse((boolean)this.singleRoute.contains("\"children\""));
        this.assertHasHillaMainLayout(this.singleRoute, false);
    }

    @Test
    public void hasHillaAutoLayout_fileRoutesHasMultipleRootRoutes_false() throws IOException {
        this.assertHasHillaMainLayout(this.multipleRootRoutes, false);
    }

    @Test
    public void hasHillaAutoLayout_fileRoutesHasNonEmptyRoute_false() throws IOException {
        this.assertHasHillaMainLayout(this.nonEmptyRoute, false);
    }

    private void assertHasHillaMainLayout(String fileRoutes, boolean expected) throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)fileRoutes, new OpenOption[0]);
        boolean hasHillaMainLayout = MenuRegistry.hasHillaMainLayout((AbstractConfiguration)this.vaadinService.getDeploymentConfiguration());
        Assert.assertEquals((Object)expected, (Object)hasHillaMainLayout);
    }

    private void assertOrder(List<AvailableViewInfo> menuItems, String[] expectedOrder) {
        for (int i = 0; i < menuItems.size(); ++i) {
            Assert.assertEquals((Object)expectedOrder[i], (Object)menuItems.get(i).route());
        }
    }

    private void assertClientRoutes(Map<String, AvailableViewInfo> menuItems) {
        this.assertClientRoutes(menuItems, false, false, false);
    }

    private void assertClientRoutes(Map<String, AvailableViewInfo> menuItems, boolean authenticated, boolean hasRole, boolean excludeExpected) {
        this.assertClientRoutes(menuItems, authenticated, hasRole, excludeExpected, "");
    }

    private void assertClientRoutes(Map<String, AvailableViewInfo> menuItems, boolean authenticated, boolean hasRole, boolean excludeExpected, String expectedRootPath) {
        Assert.assertTrue((String)("Client route '" + expectedRootPath + "' missing"), (boolean)menuItems.containsKey(expectedRootPath));
        Assert.assertEquals((Object)"Public", (Object)menuItems.get(expectedRootPath).title());
        Assert.assertNotNull((String)"Public should contain default menu data", (Object)menuItems.get(expectedRootPath).menu());
        if (authenticated) {
            Assert.assertTrue((String)"Client route 'about' missing", (boolean)menuItems.containsKey("/about"));
            Assert.assertEquals((Object)"About", (Object)menuItems.get("/about").title());
            Assert.assertTrue((String)"Login should be required", (boolean)menuItems.get("/about").loginRequired());
            Assert.assertNotNull((String)"About should contain default menu data", (Object)menuItems.get("/about").menu());
            if (hasRole) {
                Assert.assertTrue((String)"Client route 'hilla' missing", (boolean)menuItems.containsKey("/hilla"));
                Assert.assertEquals((Object)"Hilla", (Object)menuItems.get("/hilla").title());
                Assert.assertTrue((String)"Login should be required", (boolean)menuItems.get("/hilla").loginRequired());
                Assert.assertArrayEquals((String)"Faulty roles fo hilla", (Object[])new String[]{"ROLE_USER"}, (Object[])menuItems.get("/hilla").rolesAllowed());
                Assert.assertNotNull((String)"Hilla should contain default menu data", (Object)menuItems.get("/hilla").menu());
                Assert.assertTrue((String)"Client child route 'hilla/sub' missing", (boolean)menuItems.containsKey("/hilla/sub"));
                Assert.assertEquals((Object)"Hilla Sub", (Object)menuItems.get("/hilla/sub").title());
            } else {
                Assert.assertFalse((String)"Roles do not match no hilla should be available", (boolean)menuItems.containsKey("/hilla"));
            }
        } else {
            Assert.assertFalse((String)"Not authenticated about view should not be available", (boolean)menuItems.containsKey("/about"));
            Assert.assertFalse((String)"Not authenticated hilla view should not be available", (boolean)menuItems.containsKey("/hilla"));
        }
        if (excludeExpected) {
            Assert.assertFalse((String)"Client route 'login' should be excluded", (boolean)menuItems.containsKey("/login"));
        } else {
            Assert.assertTrue((String)"Client route 'login' missing", (boolean)menuItems.containsKey("/login"));
            Assert.assertEquals((Object)"Login", (Object)menuItems.get("/login").title());
            Assert.assertNull((Object)menuItems.get("/login").menu().title());
            Assert.assertTrue((String)"Login view should be excluded", (boolean)menuItems.get("/login").menu().exclude());
        }
    }

    private void assertServerRoutes(Map<String, AvailableViewInfo> menuItems) {
        Assert.assertTrue((String)"Server route 'home' missing", (boolean)menuItems.containsKey("/home"));
        Assert.assertEquals((Object)"MyRoute", (Object)menuItems.get("/home").title());
        Assert.assertEquals((Object)"Home", (Object)menuItems.get("/home").menu().title());
        Assert.assertTrue((String)"Server route 'info' missing", (boolean)menuItems.containsKey("/info"));
        Assert.assertEquals((Object)"MyInfo", (Object)menuItems.get("/info").title());
        Assert.assertEquals((Object)"MyInfo", (Object)menuItems.get("/info").menu().title());
    }

    private void assertServerRoutesWithParameters(Map<String, AvailableViewInfo> menuItems) {
        this.assertServerRoutesWithParameters(menuItems, false);
    }

    private void assertServerRoutesWithParameters(Map<String, AvailableViewInfo> menuItems, boolean excludeExpected) {
        if (excludeExpected) {
            Assert.assertFalse((String)"Server route '/param/:param' should be excluded", (boolean)menuItems.containsKey("/param/:param"));
            Assert.assertFalse((String)"Server route '/param/:param1' should be excluded", (boolean)menuItems.containsKey("/param/:param1"));
        } else {
            Assert.assertTrue((String)"Server route '/param/:param' missing", (boolean)menuItems.containsKey("/param/:param"));
            Assert.assertTrue((String)"Server route '/param/:param' should be excluded from menu", (boolean)menuItems.get("/param/:param").menu().exclude());
            Assert.assertTrue((String)"Server route '/param/:param1' missing", (boolean)menuItems.containsKey("/param/:param1"));
            Assert.assertTrue((String)"Server route '/param/:param1' should be excluded from menu", (boolean)menuItems.get("/param/:param1").menu().exclude());
        }
        Assert.assertTrue((String)"Server route with optional parameters '/param' missing", (boolean)menuItems.containsKey("/param"));
        Assert.assertFalse((String)"Server route '/param' should be included in the menu", (boolean)menuItems.get("/param").menu().exclude());
        Assert.assertTrue((String)"Server route with optional parameters '/param/varargs' missing", (boolean)menuItems.containsKey("/param/varargs"));
        Assert.assertFalse((String)"Server route '/param/varargs' should be included in the menu", (boolean)menuItems.get("/param/varargs").menu().exclude());
    }

    public static class MockService
    extends VaadinServletService {
        public RouteRegistry getRouteRegistry() {
            return super.getRouteRegistry();
        }

        public Instantiator getInstantiator() {
            return new DefaultInstantiator((VaadinService)this);
        }
    }

    @Tag(value="div")
    @Route(value="home")
    @Menu(title="Home")
    public static class MyRoute
    extends Component {
    }

    @Tag(value="div")
    @Route(value="info")
    @Menu
    public static class MyInfo
    extends Component {
    }

    @Tag(value="div")
    @Route(value="about")
    @Menu(title="about")
    public static class ConflictRoute
    extends Component {
    }

    @Tag(value="div")
    @Route(value="param/:param")
    @Menu
    public static class MyRequiredParamRoute
    extends Component {
    }

    @Tag(value="div")
    @Route(value="param/:param1/:param2?")
    @Menu
    public static class MyRequiredAndOptionalParamRoute
    extends Component {
    }

    @Tag(value="div")
    @Route(value="param/:param1?/:param2?(edit)")
    @Menu
    public static class MyOptionalParamRoute
    extends Component {
    }

    @Tag(value="div")
    @Route(value="param/varargs/:param*")
    @Menu
    public static class MyVarargsParamRoute
    extends Component {
    }

    @Tag(value="div")
    @Route(value="a")
    @Menu(order=1.1)
    public static class TestRouteA
    extends Component {
    }

    @Tag(value="div")
    @Route(value="b")
    @Menu(order=1.2)
    public static class TestRouteB
    extends Component {
    }

    @Tag(value="div")
    @Route(value="c")
    @Menu(order=0.1)
    public static class TestRouteC
    extends Component {
    }

    @Tag(value="div")
    @Route(value="d")
    @Menu(order=0.0)
    public static class TestRouteD
    extends Component {
    }

    @Tag(value="div")
    @Route(value="d/a")
    public static class TestRouteDA
    extends Component {
    }

    @Tag(value="div")
    @Route(value="d/b")
    public static class TestRouteDB
    extends Component {
    }
}

