/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.AccessDeniedException;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteAccessDeniedError;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.auth.AccessAnnotationCheckerTest;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessControlTestClasses;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.NavigationContext;
import com.vaadin.flow.server.auth.TestNavigationResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class NavigationAccessControlTest {
    NavigationAccessControl accessControl;
    NavigationAccessChecker checker1;
    NavigationAccessChecker checker2;
    NavigationAccessChecker checker3;

    @Before
    public void setUp() throws Exception {
        this.checker1 = (NavigationAccessChecker)Mockito.mock(NavigationAccessChecker.class);
        this.checker2 = (NavigationAccessChecker)Mockito.mock(NavigationAccessChecker.class);
        this.checker3 = (NavigationAccessChecker)Mockito.mock(NavigationAccessChecker.class);
        this.accessControl = new NavigationAccessControl(List.of(this.checker1, this.checker2, this.checker3));
    }

    @Test
    public void beforeEnter_principalAndRoleCheckerProvidedToCheckers() {
        this.mockCheckerResult(this.checker2, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.ALLOW);
        ArgumentCaptor captor = ArgumentCaptor.forClass(NavigationContext.class);
        Mockito.when((Object)this.checker1.check((NavigationContext)captor.capture())).then(i -> ((NavigationContext)i.getArgument(0, NavigationContext.class)).allow());
        this.checkAccess(true, false);
        NavigationContext navigationContext = (NavigationContext)captor.getValue();
        Assert.assertNotNull((String)"Expected Principal to be provided to checkers, but was null", (Object)navigationContext.getPrincipal());
        Assert.assertTrue((String)"Wrong role checker provided to checkers", (boolean)navigationContext.hasRole("user"));
    }

    @Test
    public void beforeEnter_anonymous_allCheckersAllowAccess_allowNavigation() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.ALLOW);
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertTrue((boolean)result.wasTargetViewRendered());
    }

    @Test
    public void beforeEnter_anonymous_allowAndNeutralCheckers_allowNavigation() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertTrue((boolean)result.wasTargetViewRendered());
    }

    @Test
    public void beforeEnter_anonymous_allCheckersDenyAccess_rerouteToNotFound() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)String.join((CharSequence)System.lineSeparator(), NavigationAccessControlTest.accessDeniedReason(this.checker1), NavigationAccessControlTest.accessDeniedReason(this.checker2), NavigationAccessControlTest.accessDeniedReason(this.checker3)), (Object)result.getRerouteErrorMessage());
    }

    @Test
    public void beforeEnter_anonymous_denyAndNeutralCheckers_allowNavigation() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)String.join((CharSequence)System.lineSeparator(), NavigationAccessControlTest.accessDeniedReason(this.checker1)), (Object)result.getRerouteErrorMessage());
    }

    @Test
    public void beforeEnter_anonymous_allCheckersNeutral_rerouteToNotFound() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)"Access denied because navigation checkers did not take any decision.", (Object)result.getRerouteErrorMessage());
    }

    @Test
    public void beforeEnter_developmentMode_anonymous_mixedCheckersConsensus_exceptionThrown() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        IllegalStateException failure = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.checkAccess(false, false));
        Assert.assertTrue((String)("Expected exception because of mixed consensus, but reason was " + failure.getMessage()), (boolean)failure.getMessage().startsWith("Mixed consensus from navigation checkers"));
        Assert.assertTrue((String)("Expected exception message to contain deny reasons" + failure.getMessage()), (boolean)failure.getMessage().contains(NavigationAccessControlTest.accessDeniedReason(this.checker3)));
        Mockito.reset((Object[])new NavigationAccessChecker[]{this.checker1, this.checker2, this.checker3});
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        failure = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.checkAccess(false, false));
        Assert.assertTrue((String)("Expected exception because of mixed consensus, but reason was " + failure.getMessage()), (boolean)failure.getMessage().startsWith("Mixed consensus from navigation checkers"));
        Assert.assertTrue((String)("Expected exception message to contain deny reasons" + failure.getMessage()), (boolean)failure.getMessage().contains(NavigationAccessControlTest.accessDeniedReason(this.checker1)));
    }

    @Test
    public void beforeEnter_productionMode_mixedCheckersConsensus_routeNotFoundWithNoReasonsExposed() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        TestNavigationResult result = this.checkAccess(false, true);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)"", (Object)result.getRerouteErrorMessage());
        Mockito.reset((Object[])new NavigationAccessChecker[]{this.checker1, this.checker2, this.checker3});
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.ALLOW);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        result = this.checkAccess(false, true);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)"", (Object)result.getRerouteErrorMessage());
    }

    @Test
    public void beforeEnter_productionMode_allCheckersDenyAccess_routeNotFoundWithNoReasonsExposed() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        TestNavigationResult result = this.checkAccess(false, true);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)"", (Object)result.getRerouteErrorMessage());
    }

    @Test
    public void beforeEnter_productionMode_allCheckersNeutral_routeNotFoundWithNoReasonsExposed() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        TestNavigationResult result = this.checkAccess(false, true);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(NotFoundException.class, result.getRerouteError());
        Assert.assertEquals((Object)"", (Object)result.getRerouteErrorMessage());
    }

    @Test
    public void beforeEnter_errorHandlingViewReroute_allCheckersNeutral_allowNavigation() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.NEUTRAL);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.NEUTRAL);
        TestNavigationResult result = this.checkAccess(RouteAccessDeniedError.class, false, false, true);
        Assert.assertTrue((boolean)result.wasTargetViewRendered());
        Assert.assertNull(result.getRerouteError());
        Assert.assertNull((String)"", (Object)result.getRerouteErrorMessage());
    }

    @Test(expected=IllegalStateException.class)
    public void setLoginViewStringCannotBeCalledAfterSettingClass() {
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        this.accessControl.setLoginView("/foo");
    }

    @Test(expected=IllegalStateException.class)
    public void setLoginViewClassCannotBeCalledAfterSettingClass() {
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        this.accessControl.setLoginView(AccessControlTestClasses.NoAnnotationView.class);
    }

    @Test(expected=IllegalStateException.class)
    public void setLoginViewStringCannotBeCalledAfterSettingString() {
        this.accessControl.setLoginView("/foo");
        this.accessControl.setLoginView("/bar");
    }

    @Test(expected=IllegalStateException.class)
    public void setLoginViewClassCannotBeCalledAfterSettingString() {
        this.accessControl.setLoginView("/foo");
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
    }

    @Test
    public void setLoginViewStringShouldNotThrowWithSameString() {
        this.accessControl.setLoginView("/foo");
        this.accessControl.setLoginView("/foo");
        this.accessControl.setLoginView(new String("/foo"));
        Assert.assertEquals((Object)"/foo", (Object)this.accessControl.getLoginUrl());
    }

    @Test
    public void beforeEnter_loginView_accessToLoginViewAlwaysAllowed() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        TestNavigationResult result = this.checkAccess(AccessControlTestClasses.TestLoginView.class, false, true, false);
        Assert.assertTrue((String)"Expecting navigation to login view to be allowed, but was not", (boolean)result.wasTargetViewRendered());
        result = this.checkAccess(AccessControlTestClasses.TestLoginView.class, true, true, false);
        Assert.assertTrue((String)"Expecting navigation to login view to be allowed, but was not", (boolean)result.wasTargetViewRendered());
    }

    @Test
    public void beforeEnter_loginUrl_accessToLoginUrlAlwaysAllowed() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView("/login");
        TestNavigationResult result = this.checkAccess(AccessControlTestClasses.TestLoginView.class, false, true, false);
        Assert.assertTrue((String)"Expecting navigation to login view to be allowed, but was not", (boolean)result.wasTargetViewRendered());
        result = this.checkAccess(AccessControlTestClasses.TestLoginView.class, true, true, false);
        Assert.assertTrue((String)"Expecting navigation to login view to be allowed, but was not", (boolean)result.wasTargetViewRendered());
    }

    @Test
    public void beforeEnter_loginView_anonymousUser_accessDenied_forwardToLoginView() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(AccessControlTestClasses.TestLoginView.class, result.getForwardedTo());
    }

    @Test
    public void beforeEnter_loginUrl_anonymousUser_accessDenied_forwardToLoginUrl() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView("/log-in");
        TestNavigationResult result = this.checkAccess(false, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals((Object)"/log-in", (Object)result.getExternalForwardUrl());
    }

    @Test
    public void beforeEnter_loginView_authenticatedUser_accessDenied() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        TestNavigationResult result = this.checkAccess(true, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(AccessDeniedException.class, result.getRerouteError());
    }

    @Test
    public void beforeEnter_loginUrl_authenticatedUser_accessDenied() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView("/log-in");
        TestNavigationResult result = this.checkAccess(true, false);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals(AccessDeniedException.class, result.getRerouteError());
    }

    @Test
    public void beforeEnter_redirectUrlStoredForAnonymousUsers() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        TestNavigationResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, false, false, true);
        String routePath = RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), AccessControlTestClasses.PermitAllView.class);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertEquals((Object)("http://localhost:8080/myapp/" + routePath), (Object)result.sessionAttributes.get(NavigationAccessControl.SESSION_STORED_REDIRECT_ABSOLUTE));
        Assert.assertEquals((Object)routePath, (Object)result.sessionAttributes.get(NavigationAccessControl.SESSION_STORED_REDIRECT));
    }

    @Test
    public void beforeEnter_redirectUrlNotStoredForLoggedInUsers() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        TestNavigationResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, true, false, true);
        Assert.assertFalse((boolean)result.wasTargetViewRendered());
        Assert.assertNull((Object)result.sessionAttributes.get(NavigationAccessControl.SESSION_STORED_REDIRECT));
        Assert.assertNull((Object)result.sessionAttributes.get(NavigationAccessControl.SESSION_STORED_REDIRECT_ABSOLUTE));
    }

    @Test
    public void beforeEnter_disabledNavigationControl_alwaysPasses_rejectsWhenEnabled() {
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setLoginView(AccessControlTestClasses.TestLoginView.class);
        this.accessControl.setEnabled(false);
        TestNavigationResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, false, false, false);
        Assert.assertTrue((String)"Expected navigation to target view to be allowed when access control is disabled", (boolean)result.wasTargetViewRendered());
        Mockito.reset((Object[])new NavigationAccessChecker[]{this.checker1, this.checker2, this.checker3});
        this.mockCheckerResult(this.checker1, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker2, AccessCheckDecision.DENY);
        this.mockCheckerResult(this.checker3, AccessCheckDecision.DENY);
        this.accessControl.setEnabled(true);
        result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, false, false, true);
        Assert.assertFalse((String)"Expected navigation to target view to be denied when access control is enabled", (boolean)result.wasTargetViewRendered());
    }

    @Test
    public void beforeEnter_noCheckersConfigured_alwaysPasses() {
        this.accessControl = new NavigationAccessControl(List.of());
        TestNavigationResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, false, false, false);
        Assert.assertTrue((boolean)result.wasTargetViewRendered());
    }

    private TestNavigationResult checkAccess(boolean authenticated, boolean productionMode) {
        return this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, authenticated, productionMode, true);
    }

    private TestNavigationResult checkAccess(Class<?> navigationTarget, boolean authenticated, boolean productionMode, boolean expectCheckersUsed) {
        TestNavigationResult result = NavigationAccessControlTest.setupRequest(navigationTarget, authenticated ? User.NORMAL_USER : null, productionMode);
        this.accessControl.beforeEnter(result.event);
        this.verifyAllCheckersUsed(expectCheckersUsed);
        return result;
    }

    private void verifyAllCheckersUsed(boolean used) {
        if (used) {
            ((NavigationAccessChecker)Mockito.verify((Object)this.checker1)).check((NavigationContext)ArgumentMatchers.any());
            ((NavigationAccessChecker)Mockito.verify((Object)this.checker2)).check((NavigationContext)ArgumentMatchers.any());
            ((NavigationAccessChecker)Mockito.verify((Object)this.checker3)).check((NavigationContext)ArgumentMatchers.any());
        } else {
            Mockito.verifyNoInteractions((Object[])new Object[]{this.checker1, this.checker2, this.checker3});
        }
    }

    private void mockCheckerResult(NavigationAccessChecker checker, AccessCheckDecision decision) {
        String denyReason = NavigationAccessControlTest.accessDeniedReason(checker);
        Mockito.when((Object)checker.check((NavigationContext)ArgumentMatchers.any())).then(i -> {
            NavigationContext ctx = (NavigationContext)i.getArgument(0, NavigationContext.class);
            return switch (decision) {
                default -> throw new MatchException(null, null);
                case AccessCheckDecision.ALLOW -> ctx.allow();
                case AccessCheckDecision.NEUTRAL -> ctx.neutral();
                case AccessCheckDecision.DENY -> ctx.deny(denyReason);
                case AccessCheckDecision.REJECT -> ctx.reject(denyReason);
            };
        });
    }

    private static String accessDeniedReason(NavigationAccessChecker checker) {
        return "Access denied by " + String.valueOf(checker);
    }

    static TestNavigationResult setupRequest(Class navigationTarget, User user, boolean productionMode) {
        String[] roles;
        Principal principal;
        CurrentInstance.clearAll();
        if (user == User.USER_NO_ROLES) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles = new String[]{};
        } else if (user == User.NORMAL_USER) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles = new String[]{"user"};
        } else if (user == User.ADMIN) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles = new String[]{"admin"};
        } else {
            principal = null;
            roles = new String[]{};
        }
        VaadinServletRequest vaadinServletRequest = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        HttpServletRequest httpServletRequest = AccessAnnotationCheckerTest.createRequest(principal, roles);
        Mockito.when((Object)vaadinServletRequest.getHttpServletRequest()).thenReturn((Object)httpServletRequest);
        Mockito.when((Object)vaadinServletRequest.getUserPrincipal()).thenAnswer(answer -> httpServletRequest.getUserPrincipal());
        Mockito.when((Object)vaadinServletRequest.getSession()).thenAnswer(answer -> httpServletRequest.getSession());
        Mockito.when((Object)vaadinServletRequest.getSession(ArgumentMatchers.anyBoolean())).thenAnswer(answer -> httpServletRequest.getSession(((Boolean)answer.getArgument(0)).booleanValue()));
        Mockito.when((Object)vaadinServletRequest.isUserInRole((String)Mockito.any())).thenAnswer(answer -> httpServletRequest.isUserInRole((String)answer.getArgument(0)));
        Mockito.when((Object)vaadinServletRequest.getRequestURL()).thenReturn((Object)new StringBuffer("http://localhost:8080/myapp/"));
        Mockito.when((Object)vaadinServletRequest.getWrappedSession()).thenCallRealMethod();
        Mockito.when((Object)vaadinServletRequest.getWrappedSession(ArgumentMatchers.anyBoolean())).thenCallRealMethod();
        CurrentInstance.set(VaadinRequest.class, (Object)vaadinServletRequest);
        Router router = (Router)Mockito.mock(Router.class);
        UI ui = (UI)Mockito.mock(UI.class);
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)ui.getPage()).thenReturn((Object)page);
        VaadinSession vaadinSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)ui.getSession()).thenReturn((Object)vaadinSession);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)vaadinSession.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)productionMode);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Mockito.when((Object)ui.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getRouter()).thenReturn((Object)router);
        Mockito.when((Object)router.getErrorNavigationTarget((Exception)Mockito.any())).thenAnswer(invocation -> {
            Class<?> exceptionClass = invocation.getArguments()[0].getClass();
            if (exceptionClass == NotFoundException.class) {
                return Optional.of(new ErrorTargetEntry(RouteNotFoundError.class, NotFoundException.class));
            }
            if (exceptionClass == AccessDeniedException.class) {
                return Optional.of(new ErrorTargetEntry(RouteAccessDeniedError.class, AccessDeniedException.class));
            }
            return Optional.empty();
        });
        Location location = new Location(NavigationAccessControlTest.getRoute(navigationTarget));
        Object navigationEvent = HasErrorParameter.class.isAssignableFrom(navigationTarget) ? new ErrorNavigationEvent(router, location, ui, NavigationTrigger.ROUTER_LINK, new ErrorParameter(Exception.class, new Exception())) : new NavigationEvent(router, location, ui, NavigationTrigger.ROUTER_LINK);
        BeforeEnterEvent event = new BeforeEnterEvent(navigationEvent, navigationTarget, new ArrayList());
        RouteRegistry routeRegistry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        Mockito.when((Object)router.getRegistry()).thenReturn((Object)routeRegistry);
        Mockito.when((Object)routeRegistry.getNavigationTarget(Mockito.anyString())).thenAnswer(invocation -> {
            String url = (String)invocation.getArguments()[0];
            if (location.getPath().equals(url)) {
                return Optional.of(navigationTarget);
            }
            return Optional.empty();
        });
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        Mockito.when((Object)httpServletRequest.getSession()).thenReturn((Object)session);
        Mockito.when((Object)httpServletRequest.getSession(ArgumentMatchers.anyBoolean())).thenReturn((Object)session);
        ((HttpSession)Mockito.doAnswer(invocation -> {
            String key = (String)invocation.getArguments()[0];
            Object value = invocation.getArguments()[1];
            sessionAttributes.put(key, value);
            return null;
        }).when((Object)session)).setAttribute(Mockito.anyString(), Mockito.any());
        TestNavigationResult info = new TestNavigationResult();
        info.event = event;
        info.sessionAttributes = sessionAttributes;
        return info;
    }

    static String getRoute(Class<?> navigationTarget) {
        if (HasErrorParameter.class.isAssignableFrom(navigationTarget)) {
            return "some-path";
        }
        return RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), navigationTarget);
    }

    static enum User {
        USER_NO_ROLES,
        NORMAL_USER,
        ADMIN;

    }
}

