/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.SessionLockCheckStrategy;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class DefaultDeploymentConfigurationTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    VaadinContext context;

    @Before
    public void setup() {
        this.context = new MockVaadinContext();
    }

    @Test
    public void testGetSystemPropertyForDefaultPackage() throws ClassNotFoundException {
        Class<?> clazz = Class.forName("ClassInDefaultPackage");
        String value = "value";
        String prop = "prop";
        System.setProperty(prop, value);
        Properties initParameters = new Properties();
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        DefaultDeploymentConfiguration config = new DefaultDeploymentConfiguration(appConfig, clazz, initParameters);
        Assert.assertEquals((Object)value, (Object)config.getSystemProperty(prop));
    }

    @Test
    public void testGetSystemProperty() {
        String value = "value";
        String prop = "prop";
        System.setProperty(DefaultDeploymentConfigurationTest.class.getPackage().getName() + "." + prop, value);
        Properties initParameters = new Properties();
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        DefaultDeploymentConfiguration config = new DefaultDeploymentConfiguration(appConfig, DefaultDeploymentConfigurationTest.class, initParameters);
        Assert.assertEquals((Object)value, (Object)config.getSystemProperty(prop));
    }

    @Test
    public void booleanValueReadIgnoreTheCase_true() {
        Properties initParameters = new Properties();
        initParameters.setProperty("sendUrlsAsParameters", "tRUe");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertTrue((String)"Boolean value equal to 'true' ignoring case should be interpreted as 'true'", (boolean)config.isSendUrlsAsParameters());
    }

    @Test
    public void booleanValueReadIgnoreTheCase_false() {
        Properties initParameters = new Properties();
        initParameters.setProperty("sendUrlsAsParameters", "FaLsE");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertFalse((String)"Boolean value equal to 'false' ignoring case should be interpreted as 'false'", (boolean)config.isSendUrlsAsParameters());
    }

    @Test
    public void booleanValueRead_emptyIsTrue() {
        Properties initParameters = new Properties();
        initParameters.setProperty("sendUrlsAsParameters", "");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertTrue((String)"Empty boolean value should be interpreted as 'true'", (boolean)config.isSendUrlsAsParameters());
    }

    @Test
    public void defaultPushServletMapping() {
        Properties initParameters = new Properties();
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertThat((Object)config.getPushServletMapping(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void pushUrl() {
        Properties initParameters = new Properties();
        initParameters.setProperty("pushServletMapping", "/foo/*");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertThat((Object)config.getPushServletMapping(), (Matcher)Matchers.is((Object)"/foo/*"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void booleanValueRead_exceptionOnNonBooleanValue() {
        Properties initParameters = new Properties();
        initParameters.setProperty("sendUrlsAsParameters", "incorrectValue");
        this.createDeploymentConfig(initParameters);
    }

    @Test
    public void maxMessageSuspendTimeout_validValue_accepted() {
        Properties initParameters = new Properties();
        initParameters.setProperty("maxMessageSuspendTimeout", "2700");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertEquals((long)2700L, (long)config.getMaxMessageSuspendTimeout());
    }

    @Test
    public void maxMessageSuspendTimeout_invalidValue_defaultValue() {
        Properties initParameters = new Properties();
        initParameters.setProperty("maxMessageSuspendTimeout", "kk");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(initParameters);
        Assert.assertEquals((long)5000L, (long)config.getMaxMessageSuspendTimeout());
    }

    @Test
    public void isProductionMode_productionModeIsSetViaParentOnly_productionModeIsTakenFromParent() {
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.isProductionMode()).thenReturn((Object)true);
        Assert.assertNull((Object)appConfig.getStringProperty("productionMode", null));
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(appConfig, new Properties());
        Assert.assertTrue((boolean)config.isProductionMode());
        Assert.assertTrue((boolean)config.getProperties().isEmpty());
    }

    @Test
    public void isProductionMode_productionModeIsSetViaPropertiesAndViaParent_productionModeIsTakenFromProperties() {
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.isProductionMode()).thenReturn((Object)false);
        Properties initParameters = new Properties();
        initParameters.setProperty("productionMode", Boolean.TRUE.toString());
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(appConfig, initParameters);
        Assert.assertTrue((boolean)config.isProductionMode());
    }

    @Test
    public void isXsrfProtectionEnabled_valueIsSetViaParentOnly_valueIsTakenFromParent() {
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.isXsrfProtectionEnabled()).thenReturn((Object)true);
        Assert.assertNull((Object)appConfig.getStringProperty("disable-xsrf-protection", null));
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(appConfig, new Properties());
        Assert.assertTrue((boolean)config.isXsrfProtectionEnabled());
        Assert.assertTrue((boolean)config.getProperties().isEmpty());
    }

    @Test
    public void isXsrfProtectionEnabled_valueIsSetViaParentOnlyAndViaParent_valueIsTakenFromParent() {
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.isXsrfProtectionEnabled()).thenReturn((Object)false);
        Properties initParameters = new Properties();
        initParameters.setProperty("disable-xsrf-protection", Boolean.FALSE.toString());
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(appConfig, initParameters);
        Assert.assertTrue((boolean)config.isXsrfProtectionEnabled());
    }

    @Test
    public void frontendHotdeployParameter_developmentBundle_resetsFrontendHotdeployToFalse() {
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(new Properties());
        Assert.assertEquals((String)"Expected dev server to be disabled by default", (Object)Mode.DEVELOPMENT_BUNDLE, (Object)config.getMode());
        Properties init = new Properties();
        init.put("frontend.hotdeploy", "true");
        config = this.createDeploymentConfig(init);
        Assert.assertEquals((String)"Expected dev server to be enabled when set true", (Object)Mode.DEVELOPMENT_FRONTEND_LIVERELOAD, (Object)config.getMode());
    }

    @Test
    public void frontendHotdeploy_defaultsToParentConfiguration() {
        ApplicationConfiguration appConfig = this.setupAppConfig();
        Mockito.when((Object)appConfig.getMode()).thenReturn((Object)Mode.DEVELOPMENT_FRONTEND_LIVERELOAD);
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(appConfig, new Properties());
        Assert.assertEquals((String)"Expected dev server to be enabled from parent configuration", (Object)Mode.DEVELOPMENT_FRONTEND_LIVERELOAD, (Object)config.getMode());
    }

    @Test
    public void checkLockStrategy_defaultsToAssert() {
        Properties init = new Properties();
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(init);
        Assert.assertEquals((Object)SessionLockCheckStrategy.ASSERT, (Object)config.getSessionLockCheckStrategy());
    }

    @Test
    public void checkLockStrategy_configurableViaPropertyParameter() {
        Properties init = new Properties();
        init.put("sessionLockCheckStrategy", "throw");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(init);
        Assert.assertEquals((Object)SessionLockCheckStrategy.THROW, (Object)config.getSessionLockCheckStrategy());
    }

    @Test
    public void productionModeTrue_frontendHotdeployTrue_frontendHotdeployReturnsFalse() {
        Properties init = new Properties();
        init.put("frontend.hotdeploy", "true");
        init.put("productionMode", "true");
        DefaultDeploymentConfiguration config = this.createDeploymentConfig(init);
        Assert.assertTrue((String)"ProductionMode should be enabled", (boolean)config.isProductionMode());
    }

    @Test
    public void hillaViewInLegacyFrontendFolderExists_shouldUseLegacyFolderAndHotdeploy() throws IOException {
        File projectRoot = this.tempFolder.getRoot();
        File legacyFrontend = this.tempFolder.newFolder("./frontend/");
        File legacyFrontendViews = new File(legacyFrontend, "views");
        if (!legacyFrontendViews.mkdir()) {
            Assert.fail((String)"Failed to generate legacy frontend views folder");
        }
        File viewFile = new File(legacyFrontendViews, "MyView.tsx");
        FileUtils.writeStringToFile((File)viewFile, (String)"export default function MyView(){}", (String)"UTF-8");
        try (MockedStatic util = Mockito.mockStatic(EndpointRequestUtil.class);){
            util.when(EndpointRequestUtil::isHillaAvailable).thenReturn((Object)true);
            Properties init = new Properties();
            init.put("project.basedir", projectRoot.getAbsolutePath());
            DefaultDeploymentConfiguration config = this.createDeploymentConfig(init);
            Assert.assertEquals((String)"Should use the legacy frontend folder", (Object)Mode.DEVELOPMENT_FRONTEND_LIVERELOAD, (Object)config.getMode());
        }
    }

    private DefaultDeploymentConfiguration createDeploymentConfig(Properties initParameters) {
        ApplicationConfiguration appConfig = this.setupAppConfig();
        return this.createDeploymentConfig(appConfig, initParameters);
    }

    private DefaultDeploymentConfiguration createDeploymentConfig(ApplicationConfiguration appConfig, Properties initParameters) {
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)appConfig.getBuildFolder()).thenReturn((Object)".");
        Mockito.when((Object)appConfig.getContext()).thenReturn((Object)this.context);
        return new DefaultDeploymentConfiguration(appConfig, DefaultDeploymentConfigurationTest.class, initParameters);
    }

    private ApplicationConfiguration setupAppConfig() {
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)appConfig.getFrontendFolder()).thenCallRealMethod();
        Mockito.when((Object)appConfig.getStringProperty("vaadin.frontend.folder", "./src/main/frontend/")).thenReturn((Object)"./src/main/frontend/");
        Mockito.when((Object)appConfig.getProjectFolder()).thenReturn((Object)this.tempFolder.getRoot());
        Mockito.when((Object)appConfig.getContext()).thenReturn((Object)this.context);
        return appConfig;
    }
}

