/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.QueryParameters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class QueryParametersTest {
    private final String simpleInputQueryString = "one=1&two=2&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two";
    private final String complexInputQueryString = "one=1&one=11&two=2&two=22&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two";

    private Map<String, String> getSimpleInputParameters() {
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        inputParameters.put("one", "1");
        inputParameters.put("two", "2");
        inputParameters.put("three", "3");
        return inputParameters;
    }

    private Map<String, String[]> getFullInputParameters() {
        HashMap<String, String[]> inputParameters = new HashMap<String, String[]>();
        inputParameters.put("one", new String[]{"1", "11"});
        inputParameters.put("two", new String[]{"2", "22"});
        inputParameters.put("three", new String[]{"3"});
        return inputParameters;
    }

    private void checkListsForImmutability(Collection<List<String>> lists) {
        for (List<String> list : lists) {
            try {
                list.add("whatever");
                Assert.fail((String)"No list should have been mutable");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    @Test
    public void emptyParameters() {
        QueryParameters emptyParams = QueryParameters.empty();
        Assert.assertEquals(Collections.emptyMap(), (Object)emptyParams.getParameters());
    }

    @Test
    public void emptyParametersToQueryString() {
        QueryParameters emptyParams = QueryParameters.empty();
        Assert.assertEquals((Object)"", (Object)emptyParams.getQueryString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void underlyingMapUnmodifiable_empty() {
        QueryParameters.empty().getParameters().put("one", Collections.emptyList());
    }

    @Test
    public void simpleParameters() {
        QueryParameters simpleParams = QueryParameters.simple(this.getSimpleInputParameters());
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Collections.singletonList("1"));
        expectedFullParams.put("two", Collections.singletonList("2"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        Assert.assertEquals(expectedFullParams, (Object)simpleParams.getParameters());
    }

    @Test
    public void simpleParametersFromQueryString() {
        QueryParameters simpleParams = QueryParameters.fromString((String)"one=1&two=2&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two");
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Collections.singletonList("1"));
        expectedFullParams.put("two", Collections.singletonList("2"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        expectedFullParams.put("four", Collections.singletonList(""));
        expectedFullParams.put("five", Collections.singletonList("4/5&6+7"));
        expectedFullParams.put("six", Collections.singletonList("one + one = two"));
        Assert.assertEquals(expectedFullParams, (Object)simpleParams.getParameters());
    }

    @Test
    public void simpleParametersToQueryString() {
        QueryParameters simpleParams = QueryParameters.simple(this.getSimpleInputParameters());
        String queryString = simpleParams.getQueryString();
        Assert.assertTrue((boolean)queryString.contains("one=1"));
        Assert.assertTrue((boolean)queryString.contains("two=2"));
        Assert.assertTrue((boolean)queryString.contains("three=3"));
        Assert.assertTrue((boolean)queryString.contains("&"));
        this.assertNumberOfOccurences(queryString, 2, "&");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void underlyingMapUnmodifiable_simple() {
        QueryParameters params = QueryParameters.simple(this.getSimpleInputParameters());
        params.getParameters().put("one", Collections.emptyList());
    }

    @Test
    public void underlyingListsUnmodifiable_simple() {
        this.checkListsForImmutability(QueryParameters.simple(this.getSimpleInputParameters()).getParameters().values());
    }

    @Test
    public void complexParameters() {
        QueryParameters fullParams = QueryParameters.full(this.getFullInputParameters());
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Arrays.asList("1", "11"));
        expectedFullParams.put("two", Arrays.asList("2", "22"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        Assert.assertEquals(expectedFullParams, (Object)fullParams.getParameters());
    }

    @Test
    public void complexParametersFromQueryString() {
        QueryParameters fullParams = QueryParameters.fromString((String)"one=1&one=11&two=2&two=22&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two");
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Arrays.asList("1", "11"));
        expectedFullParams.put("two", Arrays.asList("2", "22"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        expectedFullParams.put("four", Collections.singletonList(""));
        expectedFullParams.put("five", Collections.singletonList("4/5&6+7"));
        expectedFullParams.put("six", Collections.singletonList("one + one = two"));
        Assert.assertEquals(expectedFullParams, (Object)fullParams.getParameters());
    }

    @Test
    public void complexParametersToQueryString() {
        QueryParameters fullParams = QueryParameters.full(this.getFullInputParameters());
        String queryString = fullParams.getQueryString();
        Assert.assertTrue((boolean)queryString.contains("one=1"));
        Assert.assertTrue((boolean)queryString.contains("one=11"));
        Assert.assertTrue((boolean)queryString.contains("two=2"));
        Assert.assertTrue((boolean)queryString.contains("two=22"));
        Assert.assertTrue((boolean)queryString.contains("three=3"));
        this.assertNumberOfOccurences(queryString, 4, "&");
    }

    private void assertNumberOfOccurences(String stringToCheck, int expectedNumber, String element) {
        Assert.assertEquals((long)1L, (long)element.length());
        int actualNumbetOfOccurences = stringToCheck.length() - stringToCheck.replace(element, "").length();
        Assert.assertEquals((long)expectedNumber, (long)actualNumbetOfOccurences);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void underlyingMapUnmodifiable_full() {
        QueryParameters.full(this.getFullInputParameters()).getParameters().put("one", Collections.emptyList());
    }

    @Test
    public void underlyingListsUnmodifiable_full() {
        this.checkListsForImmutability(QueryParameters.full(this.getFullInputParameters()).getParameters().values());
    }

    @Test
    public void parameterWithoutValue() {
        QueryParameters params = new QueryParameters(Collections.singletonMap("foo", Collections.singletonList("")));
        Assert.assertEquals((Object)"foo", (Object)params.getQueryString());
        params = new QueryParameters(Collections.singletonMap("foo", Arrays.asList("", "bar")));
        Assert.assertEquals((Object)"foo&foo=bar", (Object)params.getQueryString());
        params = new QueryParameters(Collections.singletonMap("foo", Arrays.asList("bar", "")));
        Assert.assertEquals((Object)"foo=bar&foo", (Object)params.getQueryString());
    }

    @Test
    public void parameterWithEmptyValue() {
        QueryParameters fullParams = new QueryParameters(Collections.singletonMap("foo", Collections.singletonList("")));
        Assert.assertEquals((Object)"foo", (Object)fullParams.getQueryString());
    }

    @Test
    public void shortHands() {
        QueryParameters qp1 = QueryParameters.of((String)"foo", (String)"bar");
        Optional singleParameter = qp1.getSingleParameter("foo");
        Assert.assertEquals((Object)"bar", singleParameter.get());
        Assert.assertTrue((boolean)qp1.getSingleParameter("bar").isEmpty());
        List parameters = qp1.getParameters("foo");
        Assert.assertEquals((Object)"bar", parameters.get(0));
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertTrue((boolean)qp1.getParameters("bar").isEmpty());
    }

    @Test
    public void excluding() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.excluding(new String[]{"two"});
        Assert.assertEquals((long)2L, (long)newParams.getParameters().size());
        Assert.assertEquals(Collections.singletonList("1"), (Object)newParams.getParameters("one"));
        Assert.assertEquals(Collections.emptyList(), (Object)newParams.getParameters("two"));
        Assert.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
    }

    @Test
    public void excludingNone() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.excluding(new String[0]);
        Assert.assertEquals((Object)params, (Object)newParams);
    }

    @Test
    public void including() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.including(new String[]{"three", "two"});
        Assert.assertEquals((long)2L, (long)newParams.getParameters().size());
        Assert.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
        Assert.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
    }

    @Test
    public void includingNone() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.including(new String[0]);
        Assert.assertEquals((long)0L, (long)newParams.getParameters().size());
    }

    @Test
    public void includingNonExisting() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.including(new String[]{"four"});
        Assert.assertEquals((long)0L, (long)newParams.getParameters().size());
    }

    @Test
    public void merging() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.merging("three", new String[]{"3"}).merging("one", new String[]{"one"});
        Assert.assertEquals((long)3L, (long)newParams.getParameters().size());
        Assert.assertEquals(Collections.singletonList("one"), (Object)newParams.getParameters("one"));
        Assert.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
        Assert.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
    }

    @Test
    public void mergingMultiValue() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.merging("three", new String[]{"3", "3"});
        Assert.assertEquals((long)3L, (long)newParams.getParameters().size());
        Assert.assertEquals(Collections.singletonList("1"), (Object)newParams.getParameters("one"));
        Assert.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
        Assert.assertEquals(Arrays.asList("3", "3"), (Object)newParams.getParameters("three"));
    }

    @Test
    public void mergingAll() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.mergingAll(Map.of("three", Collections.singletonList("3"))).mergingAll(Map.of("one", Collections.singletonList("one")));
        Assert.assertEquals((long)3L, (long)newParams.getParameters().size());
        Assert.assertEquals(Collections.singletonList("one"), (Object)newParams.getParameters("one"));
        Assert.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
        Assert.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
    }

    @Test
    public void toStringValidation() {
        String toString = QueryParameters.of((String)"foo", (String)"bar").toString();
        Assert.assertEquals((Object)"QueryParameters(foo=bar)", (Object)toString);
    }

    @Test
    public void equalsAndHashCode() {
        QueryParameters qp1 = QueryParameters.of((String)"foo", (String)"bar");
        QueryParameters qp2 = QueryParameters.fromString((String)"foo=bar");
        QueryParameters qp3 = QueryParameters.fromString((String)"bar=foo");
        Assert.assertEquals((Object)qp1, (Object)qp2);
        Assert.assertNotEquals((Object)qp3, (Object)qp2);
        Assert.assertEquals((long)qp1.hashCode(), (long)qp2.hashCode());
    }

    @Test
    public void fromString_emptyString_getsEmptyParameters() {
        QueryParameters params = QueryParameters.fromString((String)"");
        Assert.assertEquals(Collections.emptyMap(), (Object)params.getParameters());
    }

    @Test
    public void fromString_blankString_getsEmptyParameters() {
        QueryParameters params = QueryParameters.fromString((String)"    ");
        Assert.assertEquals(Collections.emptyMap(), (Object)params.getParameters());
    }

    @Test
    public void fromString_nullString_getsEmptyParameters() {
        QueryParameters params = QueryParameters.fromString(null);
        Assert.assertEquals(Collections.emptyMap(), (Object)params.getParameters());
    }
}

