/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.KeyPressEvent;
import com.vaadin.flow.component.Tag;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;

public class KeyTest {
    @Test
    public void listenerWithMultipleKeyValues() {
        InputComponent input = new InputComponent();
        AtomicBoolean fired = new AtomicBoolean(false);
        input.addKeyPressListener(Key.of((String)"foo", (String[])new String[]{"bar"}), (ComponentEventListener & Serializable)event -> fired.set(true), new KeyModifier[0]);
        input.fireEvent((ComponentEvent)new KeyPressEvent((Component)input, "foo"));
        Assert.assertTrue((boolean)fired.get());
        fired.set(false);
        input.fireEvent((ComponentEvent)new KeyPressEvent((Component)input, "bar"));
        Assert.assertTrue((boolean)fired.get());
        fired.set(false);
        input.fireEvent((ComponentEvent)new KeyPressEvent((Component)input, "baz"));
        Assert.assertFalse((boolean)fired.get());
    }

    @Test
    public void of_toString_returnsKeys() {
        Key key = Key.of((String)"foo", (String[])new String[0]);
        Assert.assertEquals((Object)"foo", (Object)key.toString());
        key = Key.of((String)"foo", (String[])new String[]{"bar"});
        Assert.assertEquals((Object)"foo,  additional keys : [bar]", (Object)key.toString());
    }

    @Test
    public void of_equals_stringRepresentationsEqual_toKeysAreEqual() {
        Key key1 = Key.of((String)"foo", (String[])new String[0]);
        Key key2 = Key.of((String)"foo", (String[])new String[0]);
        Assert.assertEquals((Object)key1, (Object)key2);
    }

    @Test
    public void of_equals_stringRepresentationsNotEqual_toKeysAreNotEqual() {
        Key key1 = Key.of((String)"foo", (String[])new String[0]);
        Key key2 = Key.of((String)"bar", (String[])new String[0]);
        Assert.assertNotEquals((Object)key1, (Object)key2);
    }

    @Test
    public void of_equals_secondKeyHasAdditionalKeys_toKeysAreNotEqual() {
        Key key1 = Key.of((String)"foo", (String[])new String[0]);
        Key key2 = Key.of((String)"foo", (String[])new String[]{"bar"});
        Assert.assertNotEquals((Object)key1, (Object)key2);
    }

    @Test
    public void of_equals_differentClasses_toKeysAreNotEqual() {
        Key key1 = Key.of((String)"foo", (String[])new String[0]);
        Key key2 = new Key(){

            public List<String> getKeys() {
                return Collections.singletonList("foo");
            }
        };
        Assert.assertNotEquals((Object)key1, (Object)key2);
    }

    @Test
    public void of_equalKeys_hasSameHashCode() {
        Key key1 = Key.of((String)"foo", (String[])new String[]{"bar"});
        Key key2 = Key.of((String)"foo", (String[])new String[]{"bar"});
        Assert.assertEquals((long)key1.hashCode(), (long)key2.hashCode());
    }

    @Tag(value="input")
    public static class InputComponent
    extends Component
    implements KeyNotifier {
    }
}

