/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class HtmlBindHtmlContentTest
extends SignalsUnitTest {
    @Test
    public void bindHtmlContent_componentAttachedBefore_bindingActive() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentAttachedAfter_bindingActive() {
        Html html = new Html("<div id='a'>init</div>");
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        UI.getCurrent().add(new Component[]{html});
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentAttached_bindingActive_updatesOnChange() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>v1</div>");
        html.bindHtmlContent((Signal)signal);
        Assert.assertEquals((Object)"v1", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
        signal.set((Object)"<div id='c'>v2</div>");
        Assert.assertEquals((Object)"v2", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"c", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentNotAttached_bindingInactive() {
        Html html = new Html("<div id='a'>init</div>");
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        signal.set((Object)"<div id='c'>ignored</div>");
        Assert.assertEquals((Object)"init", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"a", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentDetached_bindingInactive() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        html.getElement().removeFromParent();
        signal.set((Object)"<div id='c'>ignored</div>");
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentReAttached_bindingActivate() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        html.getElement().removeFromParent();
        signal.set((Object)"<div id='c'>after2</div>");
        UI.getCurrent().add(new Component[]{html});
        Assert.assertEquals((Object)"after2", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"c", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_withNullValue_recordsErrorAndDoesNotChange() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        signal.set(null);
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
        Assert.assertEquals((long)1L, (long)this.events.size());
        Assert.assertEquals(NullPointerException.class, ((ErrorEvent)this.events.getFirst()).getThrowable().getClass());
        this.events.clear();
    }

    @Test
    public void bindHtmlContent_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        SignalBindingFeature feature = (SignalBindingFeature)html.getElement().getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("htmlContent");
        signal.set((Object)"<div id='c'>ignored</div>");
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
        html.setHtmlContent("<div id='d'>manual</div>");
        Assert.assertEquals((Object)"manual", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"d", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_nullSignal_throwsNPE() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        Assert.assertThrows(NullPointerException.class, () -> html.bindHtmlContent(null));
    }

    @Test
    public void bindHtmlContent_setterAndRebindWhileActive_throwException() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> html.setHtmlContent("<div id='c'>manual</div>"));
        Assert.assertThrows(BindingActiveException.class, () -> html.bindHtmlContent((Signal)new ValueSignal((Object)"<div>x</div>")));
        Assert.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assert.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }
}

