/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class HasSizeBindWidthHeightTest
extends SignalsUnitTest {
    @Test
    public void bindWidth_elementAttachedBefore_bindingActive() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        Assert.assertNull((Object)component.getWidth());
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
    }

    @Test
    public void bindWidth_elementAttachedAfter_bindingActive() {
        HasSizeComponent component = new HasSizeComponent();
        Assert.assertNull((Object)component.getWidth());
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
    }

    @Test
    public void bindWidth_elementAttached_bindingActive() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
        signal.set((Object)"300px");
        Assert.assertEquals((Object)"300px", (Object)component.getWidth());
        signal.set(null);
        Assert.assertNull((Object)component.getWidth());
    }

    @Test
    public void bindWidth_elementNotAttached_bindingInactive() {
        HasSizeComponent component = new HasSizeComponent();
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        signal.set((Object)"300px");
        Assert.assertNull((Object)component.getWidth());
    }

    @Test
    public void bindWidth_elementDetached_bindingInactive() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        component.removeFromParent();
        signal.set((Object)"300px");
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
    }

    @Test
    public void bindWidth_elementReAttached_bindingActivate() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        component.removeFromParent();
        signal.set((Object)"300px");
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"300px", (Object)component.getWidth());
    }

    @Test
    public void bindWidth_setWidthWhileBindingIsActive_throwException() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindWidth((Signal)new ValueSignal((Object)"200px"));
        Assert.assertThrows(BindingActiveException.class, () -> component.setWidth("300px"));
        Assert.assertThrows(BindingActiveException.class, () -> ((HasSizeComponent)component).setWidthFull());
        Assert.assertThrows(BindingActiveException.class, () -> component.setWidth(300.0f, Unit.PIXELS));
        Assert.assertThrows(BindingActiveException.class, () -> ((HasSizeComponent)component).setSizeFull());
        Assert.assertThrows(BindingActiveException.class, () -> component.getElement().getStyle().setWidth("300px"));
        Assert.assertThrows(BindingActiveException.class, () -> component.getElement().setAttribute("data-width-full", true));
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
    }

    @Test
    public void bindWidth_bindWidthWhileBindingIsActive_throwException() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindWidth((Signal)new ValueSignal((Object)"200px"));
        Assert.assertThrows(BindingActiveException.class, () -> component.bindWidth((Signal)new ValueSignal((Object)"300px")));
        Assert.assertThrows(BindingActiveException.class, () -> component.setWidth("300px"));
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
    }

    @Test
    public void bindWidth_nullSignal_throwsNPE() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        Assert.assertThrows(NullPointerException.class, () -> component.bindWidth(null));
    }

    @Test
    public void bindWidth_fullWidth_widthFullAttributeSet() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"100%");
        component.bindWidth((Signal)signal);
        Assert.assertEquals((Object)"100%", (Object)component.getWidth());
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("data-width-full"));
    }

    @Test
    public void bindWidth_notFullWidth_widthFullAttributeNotSet() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
        Assert.assertNull((Object)component.getElement().getAttribute("data-width-full"));
    }

    @Test
    public void bindWidth_changeFromFullWidthToOther_widthFullAttributeRemoved() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"100%");
        component.bindWidth((Signal)signal);
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("data-width-full"));
        signal.set((Object)"200px");
        Assert.assertEquals((Object)"200px", (Object)component.getWidth());
        Assert.assertNull((Object)component.getElement().getAttribute("data-width-full"));
    }

    @Test
    public void bindWidth_changeFromOtherToFullWidth_widthFullAttributeSet() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindWidth((Signal)signal);
        Assert.assertNull((Object)component.getElement().getAttribute("data-width-full"));
        signal.set((Object)"100%");
        Assert.assertEquals((Object)"100%", (Object)component.getWidth());
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("data-width-full"));
    }

    @Test
    public void bindHeight_elementAttachedBefore_bindingActive() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        Assert.assertNull((Object)component.getHeight());
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
    }

    @Test
    public void bindHeight_elementAttachedAfter_bindingActive() {
        HasSizeComponent component = new HasSizeComponent();
        Assert.assertNull((Object)component.getHeight());
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
    }

    @Test
    public void bindHeight_elementAttached_bindingActive() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
        signal.set((Object)"300px");
        Assert.assertEquals((Object)"300px", (Object)component.getHeight());
        signal.set(null);
        Assert.assertNull((Object)component.getHeight());
    }

    @Test
    public void bindHeight_elementNotAttached_bindingInactive() {
        HasSizeComponent component = new HasSizeComponent();
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        signal.set((Object)"300px");
        Assert.assertNull((Object)component.getHeight());
    }

    @Test
    public void bindHeight_elementDetached_bindingInactive() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        component.removeFromParent();
        signal.set((Object)"300px");
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
    }

    @Test
    public void bindHeight_elementReAttached_bindingActivate() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        component.removeFromParent();
        signal.set((Object)"300px");
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"300px", (Object)component.getHeight());
    }

    @Test
    public void bindHeight_setHeightWhileBindingIsActive_throwException() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindHeight((Signal)new ValueSignal((Object)"200px"));
        Assert.assertThrows(BindingActiveException.class, () -> component.setHeight("300px"));
        Assert.assertThrows(BindingActiveException.class, () -> ((HasSizeComponent)component).setHeightFull());
        Assert.assertThrows(BindingActiveException.class, () -> component.setHeight(300.0f, Unit.PIXELS));
        Assert.assertThrows(BindingActiveException.class, () -> ((HasSizeComponent)component).setSizeFull());
        Assert.assertThrows(BindingActiveException.class, () -> component.getElement().getStyle().setHeight("300px"));
        Assert.assertThrows(BindingActiveException.class, () -> component.getElement().setAttribute("data-height-full", true));
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
    }

    @Test
    public void bindHeight_bindHeightWhileBindingIsActive_throwException() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindHeight((Signal)new ValueSignal((Object)"200px"));
        Assert.assertThrows(BindingActiveException.class, () -> component.bindHeight((Signal)new ValueSignal((Object)"300px")));
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
    }

    @Test
    public void bindHeight_nullSignal_throwsNPE() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        Assert.assertThrows(NullPointerException.class, () -> component.bindHeight(null));
    }

    @Test
    public void bindHeight_fullHeight_heightFullAttributeSet() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"100%");
        component.bindHeight((Signal)signal);
        Assert.assertEquals((Object)"100%", (Object)component.getHeight());
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("data-height-full"));
    }

    @Test
    public void bindHeight_notFullHeight_heightFullAttributeNotSet() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
        Assert.assertNull((Object)component.getElement().getAttribute("data-height-full"));
    }

    @Test
    public void bindHeight_changeFromFullHeightToOther_heightFullAttributeRemoved() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"100%");
        component.bindHeight((Signal)signal);
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("data-height-full"));
        signal.set((Object)"200px");
        Assert.assertEquals((Object)"200px", (Object)component.getHeight());
        Assert.assertNull((Object)component.getElement().getAttribute("data-height-full"));
    }

    @Test
    public void bindHeight_changeFromOtherToFullHeight_heightFullAttributeSet() {
        HasSizeComponent component = new HasSizeComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"200px");
        component.bindHeight((Signal)signal);
        Assert.assertNull((Object)component.getElement().getAttribute("data-height-full"));
        signal.set((Object)"100%");
        Assert.assertEquals((Object)"100%", (Object)component.getHeight());
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("data-height-full"));
    }

    @Tag(value="div")
    public static class HasSizeComponent
    extends Component
    implements HasSize {
    }
}

