/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class HasPlaceholderBindTest
extends SignalsUnitTest {
    @Test
    public void bindPlaceholder_elementAttached_updatesWithSignal() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"first");
        component.bindPlaceholder((Signal)signal);
        Assert.assertEquals((Object)"first", (Object)component.getPlaceholder());
        signal.set((Object)"second");
        Assert.assertEquals((Object)"second", (Object)component.getPlaceholder());
        signal.set((Object)"third");
        Assert.assertEquals((Object)"third", (Object)component.getPlaceholder());
    }

    @Test
    public void bindPlaceholder_elementNotAttached_bindingInactive() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.bindPlaceholder((Signal)signal);
        Assert.assertNull((Object)component.getPlaceholder());
        signal.set((Object)"bar");
        Assert.assertNull((Object)component.getPlaceholder());
    }

    @Test
    public void bindPlaceholder_attachAfterBinding_activatesAndAppliesLatest() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.bindPlaceholder((Signal)signal);
        signal.set((Object)"bar");
        Assert.assertNull((Object)component.getPlaceholder());
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"bar", (Object)component.getPlaceholder());
    }

    @Test
    public void bindPlaceholder_elementDetached_bindingInactive_andReactivatesOnAttach() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.bindPlaceholder((Signal)signal);
        Assert.assertEquals((Object)"foo", (Object)component.getPlaceholder());
        component.removeFromParent();
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)component.getPlaceholder());
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"bar", (Object)component.getPlaceholder());
    }

    @Test
    public void bindPlaceholder_nullSignal_throwsNPE() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assert.assertThrows(NullPointerException.class, () -> component.bindPlaceholder(null));
    }

    @Test
    public void setPlaceholder_whileBindingActive_throwsBindingActiveException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.bindPlaceholder((Signal)signal);
        Assert.assertEquals((Object)"foo", (Object)component.getPlaceholder());
        Assert.assertThrows((String)"Expected BindingActiveException when setting placeholder while binding is active", BindingActiveException.class, () -> component.setPlaceholder("bar"));
    }

    @Test
    public void bindPlaceholder_againWhileActive_throwsBindingActiveException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.bindPlaceholder((Signal)signal);
        Assert.assertEquals((Object)"foo", (Object)component.getPlaceholder());
        Assert.assertThrows((String)"Expected BindingActiveException when binding a new signal while a binding is active", BindingActiveException.class, () -> component.bindPlaceholder((Signal)new ValueSignal((Object)"bar")));
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasPlaceholder {
        private TestComponent() {
        }
    }
}

