/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class HasHelperBindHelperTextTest
extends SignalsUnitTest {
    @Test
    public void bindHelperText_updatesPropertyOnSignalChange() {
        HasHelperComponent c = new HasHelperComponent();
        UI.getCurrent().add(new Component[]{c});
        ValueSignal signal = new ValueSignal((Object)"");
        c.bindHelperText((Signal)signal);
        signal.set((Object)"help-1");
        Assert.assertEquals((Object)"help-1", (Object)c.getElement().getProperty("helperText"));
        signal.set((Object)"help-2");
        Assert.assertEquals((Object)"help-2", (Object)c.getElement().getProperty("helperText"));
    }

    @Test
    public void bindHelperText_setHelperTextWhileBindingActive_throws() {
        HasHelperComponent c = new HasHelperComponent();
        UI.getCurrent().add(new Component[]{c});
        ValueSignal signal = new ValueSignal((Object)"initial");
        c.bindHelperText((Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> c.setHelperText("manual"));
    }

    @Test
    public void bindHelperText_nullSignal_throwsNPE() {
        HasHelperComponent c = new HasHelperComponent();
        UI.getCurrent().add(new Component[]{c});
        Assert.assertThrows(NullPointerException.class, () -> c.bindHelperText(null));
    }

    @Tag(value="div")
    public static class HasHelperComponent
    extends Component
    implements HasHelper {
    }
}

