/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEffect;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class AbstractFieldBindValueTest
extends SignalsUnitTest {
    @Test
    public void bindValue_elementAttachedBefore_bindingActive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((Object)"", (Object)input.getValue());
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementAttachedAfter_bindingActive() {
        TestInput input = new TestInput();
        Assert.assertEquals((Object)"", (Object)input.getValue());
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementAttached_bindingActive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        signal.set(null);
        Assert.assertNull((Object)input.getValue());
        Assert.assertEquals((long)3L, (long)input.setValueCounter);
    }

    @Test
    public void bindValue_elementNotAttached_bindingInactive() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementDetached_bindingInactive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.removeFromParent();
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementReAttached_bindingActivate() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.removeFromParent();
        signal.set((Object)"bar");
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_bindValueWhileBindingIsActive_throwException() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal1 = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal1, arg_0 -> ((ValueSignal)signal1).set(arg_0));
        ValueSignal signal2 = new ValueSignal((Object)"bar");
        Assert.assertThrows(BindingActiveException.class, () -> input.bindValue((Signal)signal2, arg_0 -> ((ValueSignal)signal2).set(arg_0)));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_setValueWhileBindingIsActive_signalUpdated() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_nullSignal_throwsNPE() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        Assert.assertThrows(NullPointerException.class, () -> input.bindValue(null, null));
    }

    @Test
    public void bindValue_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        SignalBindingFeature feature = (SignalBindingFeature)input.getElement().getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("value");
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        input.setValue("baz");
        Assert.assertEquals((Object)"baz", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_lazyInitSignalBindingFeature() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        input.setValue("foo");
        input.getValue();
        input.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assert.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindValue_addValueChangeListener_signalValueChangeTriggersEvent() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assert.assertNull(listenerValue.get());
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"bar", listenerValue.get());
    }

    @Test
    public void bindValue_addValueChangeListener_bindValueTriggersEvent() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assert.assertNull(listenerValue.get());
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assert.assertEquals((Object)"foo", listenerValue.get());
    }

    @Test
    public void bindValue_setValue_countEffectExecutions() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicInteger counter = new AtomicInteger(0);
        ComponentEffect.effect((Component)input, (SerializableRunnable & Serializable)() -> {
            signal.get();
            counter.incrementAndGet();
        });
        Assert.assertEquals((long)0L, (long)counter.get());
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((long)1L, (long)counter.get());
        input.setValue("bar");
        Assert.assertEquals((long)2L, (long)counter.get());
        input.setValue("bar");
        Assert.assertEquals((long)2L, (long)counter.get());
        input.setValue("foo");
        Assert.assertEquals((long)3L, (long)counter.get());
        signal.set((Object)"baz");
        Assert.assertEquals((long)4L, (long)counter.get());
        input.setValue("baz");
        Assert.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    public void bindValue_forElementProperty_addValueChangeListener_bindingValueChangeTriggersEvent() {
        TestPropertyInput input = new TestPropertyInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assert.assertEquals((Object)"", (Object)input.getValue());
        Assert.assertNull(listenerValue.get());
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        Assert.assertEquals((Object)"foo", listenerValue.get());
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", listenerValue.get());
        signal.set(null);
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", listenerValue.get());
        Assert.assertEquals((long)1L, (long)this.events.size());
        this.events.clear();
    }

    @Test
    public void bindValue_readOnlyBinding_setValueThrows() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, null);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        Assert.assertThrows(IllegalStateException.class, () -> input.setValue("bar"));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        Assert.assertEquals((Object)"foo", (Object)signal.peek());
    }

    @Test
    public void bindValue_readOnlyBinding_signalChangesStillWork() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, null);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        signal.set((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_readOnlyBinding_detachedSetValueDoesNotThrow() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, null);
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_noOpCallback_revertsToSignalValue() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)v -> {});
        input.setValue("bar");
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        Assert.assertEquals((Object)"foo", (Object)signal.peek());
    }

    @Test
    public void bindValue_transformingCallback_componentShowsTransformed() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)v -> signal.set((Object)v.toUpperCase()));
        input.setValue("bar");
        Assert.assertEquals((Object)"BAR", (Object)signal.peek());
        Assert.assertEquals((Object)"BAR", (Object)input.getValue());
    }

    @Test
    public void bindValue_normalCallback_setValueUpdatesBoth() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_readOnlySignal_signalToComponentDirection() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal writable = new ValueSignal((Object)"foo");
        Signal readOnly = writable.asReadonly();
        input.bindValue(readOnly, null);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        writable.set((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test(expected=RuntimeException.class)
    public void bindValue_writeCallbackThrows() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)value -> {
            throw new RuntimeException("test");
        });
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assert.fail((String)"Value change listener should not be triggered when write callback throws"));
        input.setValue("bar");
    }

    @Test
    public void bindValue_normalCallback_valueChangeEventTriggered() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference eventValue = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(0);
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            eventValue.set((String)event.getValue());
            counter.incrementAndGet();
        });
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", eventValue.get());
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void bindValue_transformingCallback_valueChangeEventTriggered() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)v -> signal.set((Object)v.toUpperCase()));
        AtomicReference eventValue = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(0);
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            eventValue.set((String)event.getValue());
            counter.incrementAndGet();
        });
        input.setValue("bar");
        Assert.assertEquals((Object)"BAR", eventValue.get());
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void bindValue_noOpCallback_valueChangeEventNotTriggered() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)value -> {});
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assert.fail((String)"Value change listener should not be triggered with a no-op callback"));
        input.setValue("bar");
    }

    @Tag(value="input")
    private static class TestInput
    extends AbstractField<TestInput, String> {
        int setValueCounter = 0;

        public TestInput() {
            this("");
        }

        public TestInput(String defaultValue) {
            super((Object)defaultValue);
        }

        protected void setPresentationValue(String newPresentationValue) {
        }

        public void setValue(String value) {
            super.setValue((Object)value);
            ++this.setValueCounter;
        }
    }

    @Tag(value="input")
    private static class TestPropertyInput
    extends AbstractSinglePropertyField<TestInput, String> {
        public TestPropertyInput() {
            super("value", (Object)"", false);
        }
    }
}

