/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import java.util.List;
import java.util.Objects;

public class SharedValueSignal<T>
extends AbstractSignal<T>
implements WritableSignal<T> {
    private final Class<T> valueType;

    public SharedValueSignal(T initialValue) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, initialValue.getClass());
        this.value(initialValue);
    }

    public SharedValueSignal(Class<T> valueType) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, Objects.requireNonNull(valueType));
    }

    protected SharedValueSignal(SignalTree tree, Id id, CommandValidator validator, Class<T> valueType) {
        super(tree, id, validator);
        this.valueType = Objects.requireNonNull(valueType);
    }

    @Override
    public SignalOperation<T> value(T value) {
        assert (value == null || this.valueType.isInstance(value));
        return this.submit(new SignalCommand.SetCommand(Id.random(), this.id(), SharedValueSignal.toJson(value)), success -> SharedValueSignal.nodeValue(success.onlyUpdate().oldNode(), this.valueType));
    }

    @Override
    protected T extractValue(Node.Data data) {
        if (data == null) {
            return null;
        }
        return SharedValueSignal.nodeValue(data, this.valueType);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.value();
    }

    @Override
    public SignalOperation<Void> replace(T expectedValue, T newValue) {
        SignalCommand.ValueCondition condition = new SignalCommand.ValueCondition(Id.random(), this.id(), SharedValueSignal.toJson(expectedValue));
        SignalCommand.SetCommand set = new SignalCommand.SetCommand(Id.random(), this.id(), SharedValueSignal.toJson(newValue));
        return this.submit(new SignalCommand.TransactionCommand(Id.random(), List.of(condition, set)));
    }

    @Override
    public CancelableOperation<T> update(SignalUpdater<T> updater) {
        CancelableOperation operation = new CancelableOperation();
        this.tryUpdate(updater, operation);
        return operation;
    }

    private void tryUpdate(SignalUpdater<T> updater, CancelableOperation<T> operation) {
        if (operation.isCancelled()) {
            operation.result().cancel(false);
            return;
        }
        SignalOperation setOperation = Transaction.runInTransaction(() -> {
            Object value = this.peek();
            this.verifyValue(value);
            Object newValue = updater.update(value);
            return this.value(newValue);
        }).returnValue();
        setOperation.result().whenComplete((result, error) -> {
            if (error != null) {
                operation.result().completeExceptionally((Throwable)error);
            } else if (result.successful()) {
                operation.result().complete((SignalOperation.ResultOrError<SignalOperation.ResultOrError>)result);
            } else {
                this.tryUpdate(updater, operation);
            }
        });
    }

    public SignalOperation<Void> verifyValue(T expectedValue) {
        return this.submit(new SignalCommand.ValueCondition(Id.random(), this.id(), SharedValueSignal.toJson(expectedValue)));
    }

    public SharedValueSignal<T> withValidator(CommandValidator validator) {
        return new SharedValueSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.valueType);
    }

    @Override
    public SharedValueSignal<T> asReadonly() {
        return this.withValidator(CommandValidator.REJECT_ALL);
    }

    @Override
    public SharedNodeSignal asNode() {
        return super.asNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedValueSignal)) return false;
        SharedValueSignal other = (SharedValueSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.valueType, other.valueType)) return false;
        if (!Objects.equals(this.getClass(), other.getClass())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.valueType);
    }

    public String toString() {
        return "SharedValueSignal[" + String.valueOf(this.peek()) + "]";
    }
}

