/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.operations.InsertOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedMapSignal;
import com.vaadin.flow.signals.shared.SharedNumberSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import tools.jackson.databind.JsonNode;

public class SharedNodeSignal
extends AbstractSignal<SharedNodeSignalState> {
    public SharedNodeSignal() {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES);
    }

    protected SharedNodeSignal(SignalTree tree, Id id, CommandValidator validator) {
        super(tree, id, validator);
    }

    private SharedNodeSignal child(Id id) {
        return new SharedNodeSignal(this.tree(), id, this.validator());
    }

    @Override
    protected SharedNodeSignalState extractValue(Node.Data data) {
        if (data == null) {
            return null;
        }
        Id parentId = data.parent();
        return new SharedNodeSignalState(data.value(), parentId != null ? this.child(parentId) : null, SharedListSignal.children(data, this::child), SharedMapSignal.children(data, this::child));
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.lastUpdate();
    }

    public <T> SharedValueSignal<T> asValue(Class<T> valueType) {
        return new SharedValueSignal<T>(this.tree(), this.id(), this.validator(), valueType);
    }

    public SharedNumberSignal asNumber() {
        return new SharedNumberSignal(this.tree(), this.id(), this.validator());
    }

    public <T> SharedListSignal<T> asList(Class<T> elementType) {
        return new SharedListSignal<T>(this.tree(), this.id(), this.validator(), elementType);
    }

    public <T> SharedMapSignal<T> asMap(Class<T> elementType) {
        return new SharedMapSignal<T>(this.tree(), this.id(), this.validator(), elementType);
    }

    public InsertOperation<SharedNodeSignal> insertChildWithValue(Object value, SharedListSignal.ListPosition at) {
        return this.submitInsert(new SignalCommand.InsertCommand(Id.random(), this.id(), null, SharedNodeSignal.toJson(value), at), this::child);
    }

    public InsertOperation<SharedNodeSignal> insertChild(SharedListSignal.ListPosition at) {
        return this.insertChildWithValue(null, at);
    }

    public SignalOperation<Void> putChildWithValue(String key, Object value) {
        return this.submit(new SignalCommand.PutCommand(Id.random(), this.id(), Objects.requireNonNull(key), SharedNodeSignal.toJson(value)));
    }

    public InsertOperation<SharedNodeSignal> putChildIfAbsent(String key) {
        return this.submitInsert(new SignalCommand.PutIfAbsentCommand(Id.random(), this.id(), null, Objects.requireNonNull(key), null), this::child);
    }

    public SignalOperation<Void> adoptAt(AbstractSignal<?> node, SharedListSignal.ListPosition at) {
        return this.submit(new SignalCommand.AdoptAtCommand(Id.random(), this.id(), node.id(), Objects.requireNonNull(at)));
    }

    public SignalOperation<Void> adoptAs(AbstractSignal<?> signal, String key) {
        return this.submit(new SignalCommand.AdoptAsCommand(Id.random(), this.id(), signal.id(), Objects.requireNonNull(key)));
    }

    public SignalOperation<Void> removeChild(SharedNodeSignal child) {
        return super.remove(child);
    }

    public SignalOperation<Void> removeChild(String key) {
        return this.submit(new SignalCommand.RemoveByKeyCommand(Id.random(), this.id(), Objects.requireNonNull(key)));
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    public SharedNodeSignal withValidator(CommandValidator validator) {
        return new SharedNodeSignal(this.tree(), this.id(), this.mergeValidators(validator));
    }

    public SharedNodeSignal asReadonly() {
        return this.withValidator(anything -> false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedNodeSignal)) return false;
        SharedNodeSignal other = (SharedNodeSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SharedNodeSignal[");
        SharedNodeSignalState value = (SharedNodeSignalState)this.peek();
        if (value != null) {
            boolean needsComma = false;
            if (value.value != null) {
                builder.append("value: ").append(value.value);
                needsComma = true;
            }
            if (!value.listChildren.isEmpty()) {
                if (needsComma) {
                    builder.append(", ");
                }
                builder.append("listChildren: ").append(value.listChildren.stream().map(SharedNodeSignal::toString).collect(Collectors.joining(", ", "[", "]")));
                needsComma = true;
            }
            if (!value.mapChildren.isEmpty()) {
                if (needsComma) {
                    builder.append(", ");
                }
                builder.append("mapChildren: ").append(value.mapChildren.entrySet().stream().map((? super T entry) -> (String)entry.getKey() + " = " + String.valueOf(entry.getValue())).collect(Collectors.joining(", ", "[", "]")));
            }
        }
        builder.append(']');
        return builder.toString();
    }

    public static class SharedNodeSignalState {
        private final JsonNode value;
        private final SharedNodeSignal parent;
        private final List<SharedNodeSignal> listChildren;
        private final Map<String, SharedNodeSignal> mapChildren;

        public SharedNodeSignalState(JsonNode value, SharedNodeSignal parent, List<SharedNodeSignal> listChildren, Map<String, SharedNodeSignal> mapChildren) {
            this.value = value;
            this.parent = parent;
            this.listChildren = listChildren;
            this.mapChildren = mapChildren;
        }

        public <T> T value(Class<T> valueType) {
            return AbstractSignal.fromJson(this.value, valueType);
        }

        public SharedNodeSignal parent() {
            return this.parent;
        }

        public List<SharedNodeSignal> listChildren() {
            return this.listChildren;
        }

        public Map<String, SharedNodeSignal> mapChildren() {
            return this.mapChildren;
        }
    }
}

