/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.operations.InsertOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SharedMapSignal<T>
extends AbstractSignal<Map<String, SharedValueSignal<T>>> {
    private Class<T> elementType;

    public SharedMapSignal(Class<T> elementType) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, elementType);
    }

    protected SharedMapSignal(SignalTree tree, Id id, CommandValidator validator, Class<T> elementType) {
        super(tree, id, validator);
        this.elementType = Objects.requireNonNull(elementType);
    }

    private SharedValueSignal<T> child(Id childId) {
        return new SharedValueSignal<T>(this.tree(), childId, this.validator(), this.elementType);
    }

    @Override
    protected Map<String, SharedValueSignal<T>> extractValue(Node.Data data) {
        if (data == null) {
            return Map.of();
        }
        return SharedMapSignal.children(data, this::child);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.mapChildren();
    }

    public SignalOperation<T> put(String key, T value) {
        return this.submit(new SignalCommand.PutCommand(Id.random(), this.id(), Objects.requireNonNull(key), SharedMapSignal.toJson(value)), success -> {
            if (success.updates().size() == 1) {
                return SharedMapSignal.nodeValue(success.onlyUpdate().oldNode(), this.elementType);
            }
            assert (success.updates().size() == 2);
            return null;
        });
    }

    public InsertOperation<SharedValueSignal<T>> putIfAbsent(String key, T value) {
        return this.submitInsert(new SignalCommand.PutIfAbsentCommand(Id.random(), this.id(), null, Objects.requireNonNull(key), SharedMapSignal.toJson(value)), this::child);
    }

    public SignalOperation<T> remove(String key) {
        return this.submit(new SignalCommand.RemoveByKeyCommand(Id.random(), this.id(), Objects.requireNonNull(key)), success -> {
            CommandResult.NodeModification removal = success.updates().values().stream().filter(update -> update.newNode() == null).findAny().get();
            return SharedMapSignal.nodeValue(removal.oldNode(), this.elementType);
        });
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    private SignalOperation<Void> submitKeyCondition(String key, Id expectedChildId) {
        return this.submit(new SignalCommand.KeyCondition(Id.random(), this.id(), key, expectedChildId));
    }

    public SignalOperation<Void> verifyKey(String key, AbstractSignal<?> expectedChild) {
        return this.submitKeyCondition(Objects.requireNonNull(key), expectedChild.id());
    }

    public SignalOperation<Void> verifyHasKey(String key) {
        return this.submitKeyCondition(key, null);
    }

    public SignalOperation<Void> verifyKeyAbsent(String key) {
        return this.submitKeyCondition(key, Id.ZERO);
    }

    public SharedMapSignal<T> withValidator(CommandValidator validator) {
        return new SharedMapSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.elementType);
    }

    public SharedMapSignal<T> asReadonly() {
        return this.withValidator(anything -> false);
    }

    @Override
    public SharedNodeSignal asNode() {
        return super.asNode();
    }

    static <T extends Signal<?>> Map<String, T> children(Node.Data node, Function<Id, T> factory) {
        LinkedHashMap children = new LinkedHashMap();
        node.mapChildren().forEach((key, id) -> children.put(key, (Signal)factory.apply((Id)id)));
        return Collections.unmodifiableMap(children);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedMapSignal)) return false;
        SharedMapSignal other = (SharedMapSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.elementType, other.elementType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.elementType);
    }

    public String toString() {
        return ((Map)this.peek()).entrySet().stream().map((? super T entry) -> (String)entry.getKey() + "=" + String.valueOf(((SharedValueSignal)entry.getValue()).value())).collect(Collectors.joining(", ", "SharedMapSignal[", "]"));
    }
}

