/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.function.SignalModifier;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.ValueModifier;
import com.vaadin.flow.signals.impl.MappedModifySignal;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.local.AbstractLocalSignal;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import java.util.ConcurrentModificationException;
import java.util.Objects;

public class ValueSignal<T>
extends AbstractLocalSignal<T>
implements WritableSignal<T> {
    private boolean modifyRunning = false;

    public ValueSignal(T initialValue) {
        super(initialValue);
    }

    public ValueSignal() {
        this(null);
    }

    @Override
    protected void checkPreconditions() {
        this.assertLockHeld();
        if (Transaction.inTransaction()) {
            throw new IllegalStateException("ValueSignal cannot be used inside signal transactions.");
        }
        if (this.modifyRunning) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalOperation<T> value(T value) {
        this.lock();
        try {
            this.checkPreconditions();
            Object oldValue = this.getSignalValue();
            this.setSignalValue(value);
            SignalOperation signalOperation = new SignalOperation(new SignalOperation.Result(oldValue));
            return signalOperation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalOperation<Void> replace(T expectedValue, T newValue) {
        this.lock();
        try {
            this.checkPreconditions();
            if (Objects.equals(expectedValue, this.getSignalValue())) {
                this.setSignalValue(newValue);
                SignalOperation<Object> signalOperation = new SignalOperation<Object>(new SignalOperation.Result<Object>(null));
                return signalOperation;
            }
            SignalOperation<Void> signalOperation = new SignalOperation<Void>(new SignalOperation.Error("Unexpected value"));
            return signalOperation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CancelableOperation<T> update(SignalUpdater<T> updater) {
        Objects.requireNonNull(updater);
        this.lock();
        try {
            this.checkPreconditions();
            Object oldValue = this.getSignalValue();
            T newValue = updater.update(oldValue);
            if (newValue != oldValue) {
                this.setSignalValue(newValue);
            }
            CancelableOperation operation = new CancelableOperation();
            operation.result().complete(new SignalOperation.Result(oldValue));
            CancelableOperation cancelableOperation = operation;
            return cancelableOperation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ValueModifier<T> modifier) {
        Objects.requireNonNull(modifier);
        if (!this.tryLock()) {
            throw new ConcurrentModificationException();
        }
        try {
            this.checkPreconditions();
            this.modifyRunning = true;
        }
        finally {
            this.unlock();
        }
        boolean completed = false;
        try {
            modifier.modify(this.getSignalValueUnsafe());
            completed = true;
        }
        finally {
            this.lock();
            try {
                this.modifyRunning = false;
                if (completed) {
                    this.setSignalValue(this.getSignalValue());
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    public <C> WritableSignal<C> mapMutable(SignalMapper<T, C> getter, SignalModifier<T, C> modifier) {
        return new MappedModifySignal<T, C>(this, getter, modifier);
    }
}

