/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.signals.local.AbstractLocalSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListSignal<T>
extends AbstractLocalSignal<List<ValueSignal<T>>> {
    public ListSignal() {
        super(List.of());
    }

    public ValueSignal<T> insertFirst(T value) {
        return this.insertAt(0, value);
    }

    public ValueSignal<T> insertLast(T value) {
        this.lock();
        try {
            ValueSignal<T> valueSignal = this.insertAtInternal(((List)this.getSignalValue()).size(), value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSignal<T> insertAt(int index, T value) {
        this.lock();
        try {
            List entries = (List)this.getSignalValue();
            if (index < 0 || index > entries.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + entries.size());
            }
            ValueSignal<T> valueSignal = this.insertAtInternal(index, value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    private ValueSignal<T> insertAtInternal(int index, T value) {
        this.assertLockHeld();
        ValueSignal<T> entry = new ValueSignal<T>(value);
        ArrayList<ValueSignal<T>> newEntries = new ArrayList<ValueSignal<T>>((Collection)this.getSignalValue());
        newEntries.add(index, entry);
        this.setSignalValue(Collections.unmodifiableList(newEntries));
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ValueSignal<T> entry) {
        this.lock();
        try {
            List entries = (List)this.getSignalValue();
            List<ValueSignal> newEntries = entries.stream().filter(e -> e != entry).toList();
            if (newEntries.size() < entries.size()) {
                this.setSignalValue(newEntries);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.lock();
        try {
            if (!((List)this.getSignalValue()).isEmpty()) {
                this.setSignalValue(List.of());
            }
        }
        finally {
            this.unlock();
        }
    }
}

