/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.function.SignalModifier;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import java.util.Objects;

public class MappedModifySignal<P, C>
implements WritableSignal<C> {
    private final ValueSignal<P> parent;
    private final SignalMapper<P, C> getter;
    private final SignalModifier<P, C> modifier;

    public MappedModifySignal(ValueSignal<P> parent, SignalMapper<P, C> getter, SignalModifier<P, C> modifier) {
        this.parent = Objects.requireNonNull(parent);
        this.getter = Objects.requireNonNull(getter);
        this.modifier = Objects.requireNonNull(modifier);
    }

    @Override
    public C value() {
        return this.getter.map(this.parent.value());
    }

    @Override
    public C peek() {
        return this.getter.map(this.parent.peek());
    }

    @Override
    public SignalOperation<C> value(C newChildValue) {
        C oldChildValue = this.getter.map(this.parent.peek());
        this.parent.modify(parentValue -> this.modifier.modify(parentValue, newChildValue));
        return new SignalOperation<C>(new SignalOperation.Result<C>(oldChildValue));
    }

    @Override
    public SignalOperation<Void> replace(C expectedValue, C newValue) {
        C currentChildValue = this.getter.map(this.parent.peek());
        if (Objects.equals(expectedValue, currentChildValue)) {
            this.parent.modify(parentValue -> this.modifier.modify(parentValue, newValue));
            return new SignalOperation<Object>(new SignalOperation.Result<Object>(null));
        }
        return new SignalOperation<Void>(new SignalOperation.Error("Unexpected child value"));
    }

    @Override
    public CancelableOperation<C> update(SignalUpdater<C> childUpdater) {
        Objects.requireNonNull(childUpdater);
        C currentChildValue = this.getter.map(this.parent.peek());
        C newChildValue = childUpdater.update(currentChildValue);
        this.parent.modify(parentValue -> this.modifier.modify(parentValue, newChildValue));
        CancelableOperation operation = new CancelableOperation();
        operation.result().complete(new SignalOperation.Result<C>(currentChildValue));
        return operation;
    }
}

