/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.dom.ThemeList;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ThemeListImpl
implements ThemeList,
Serializable {
    public static final String THEME_ATTRIBUTE_NAME = "theme";
    private static final String THEME_NAMES_DELIMITER = " ";
    private final Element element;
    private final Set<String> themes;

    public ThemeListImpl(Element element) {
        this.element = element;
        this.themes = this.readThemesFromAttribute();
    }

    private Set<String> readThemesFromAttribute() {
        return Optional.ofNullable(this.element.getAttribute(THEME_ATTRIBUTE_NAME)).map(value -> value.split(THEME_NAMES_DELIMITER)).map(Stream::of).map(stream -> stream.filter(themeName -> !themeName.isEmpty()).collect(Collectors.toSet())).orElseGet(HashSet::new);
    }

    @Override
    public void bind(String name, Signal<Boolean> signal) {
        SignalBindingFeature feature = this.element.getNode().getFeature(SignalBindingFeature.class);
        if (signal == null) {
            feature.removeBinding("themes/" + name);
        } else {
            if (feature.hasBinding("themes/" + name)) {
                throw new BindingActiveException("Theme name '" + name + "' is already bound to a signal");
            }
            Registration registration = ElementEffect.bind(Element.get(this.element.getNode()), signal, (element, value) -> this.internalSetPresence(name, Boolean.TRUE.equals(value)));
            feature.setBinding("themes/" + name, registration, signal);
        }
    }

    private void internalSetPresence(String name, boolean set) {
        this.themes.clear();
        this.themes.addAll(this.readThemesFromAttribute());
        boolean changed = set ? this.themes.add(name) : this.themes.remove(name);
        if (changed) {
            this.updateThemeAttribute();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new ThemeListIterator();
    }

    @Override
    public boolean add(String themeName) {
        this.throwIfBound(themeName);
        boolean changed = this.themes.add(themeName);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends String> themeNames) {
        themeNames.forEach(this::throwIfBound);
        boolean changed = this.themes.addAll(themeNames);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean remove(Object themeName) {
        boolean changed;
        if (themeName instanceof String) {
            String name = (String)themeName;
            this.throwIfBound(name);
        }
        if (changed = this.themes.remove(themeName)) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> themeNamesToRetain) {
        this.themes.stream().filter(name -> !themeNamesToRetain.contains(name)).forEach(this::throwIfBound);
        boolean changed = this.themes.retainAll(themeNamesToRetain);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> themeNamesToRemove) {
        themeNamesToRemove.stream().map(String.class::cast).forEach(this::throwIfBound);
        boolean changed = this.themes.removeAll(themeNamesToRemove);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public void clear() {
        this.clearBindings();
        this.themes.clear();
        this.updateThemeAttribute();
    }

    private void updateThemeAttribute() {
        if (this.themes.isEmpty()) {
            this.element.removeAttribute(THEME_ATTRIBUTE_NAME);
        } else {
            this.element.setAttribute(THEME_ATTRIBUTE_NAME, this.themes.stream().collect(Collectors.joining(THEME_NAMES_DELIMITER)));
        }
    }

    @Override
    public int size() {
        return this.themes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.themes.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.themes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.themes.toArray(a);
    }

    @Override
    public boolean contains(Object themeName) {
        return this.themes.contains(themeName);
    }

    @Override
    public boolean containsAll(Collection<?> themeNames) {
        return this.themes.containsAll(themeNames);
    }

    public String toString() {
        return this.themes.toString();
    }

    public void clearBindings() {
        this.getSignalBindingFeatureIfInitialized().ifPresent(feature -> feature.clearBindings("themes/"));
    }

    private void throwIfBound(String className) {
        this.getSignalBindingFeatureIfInitialized().ifPresent(feature -> {
            if (feature.hasBinding("themes/" + className)) {
                throw new BindingActiveException("Theme name '" + className + "' is bound and cannot be modified manually");
            }
        });
    }

    private Optional<SignalBindingFeature> getSignalBindingFeatureIfInitialized() {
        try {
            return this.element.getNode().getFeatureIfInitialized(SignalBindingFeature.class);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    private final class ThemeListIterator
    implements Iterator<String> {
        private final Iterator<String> wrappedIterator;

        private ThemeListIterator() {
            this.wrappedIterator = ThemeListImpl.this.themes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public String next() {
            return this.wrappedIterator.next();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
            ThemeListImpl.this.updateThemeAttribute();
        }
    }
}

