/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.WritableSignal;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class AbstractFieldSupport<C extends Component, T>
implements Serializable {
    private final T defaultValue;
    private final C component;
    private final SerializableBiPredicate<T, T> valueEquals;
    private final SerializableConsumer<T> setPresentationValue;
    private T bufferedValue;
    private boolean presentationUpdateInProgress;
    private boolean valueSetFromPresentationUpdate;
    private T pendingValueFromPresentation;
    private boolean valueSetFromSignal;

    public AbstractFieldSupport(C component, T defaultValue, SerializableBiPredicate<T, T> valueEquals, SerializableConsumer<T> setPresentationValue) {
        this.component = component;
        this.defaultValue = defaultValue;
        this.bufferedValue = defaultValue;
        this.valueEquals = valueEquals;
        this.setPresentationValue = setPresentationValue;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<C, T>> listener) {
        ComponentEventListener<ComponentEvent> componentListener = event -> {
            AbstractField.ComponentValueChangeEvent valueChangeEvent = (AbstractField.ComponentValueChangeEvent)event;
            listener.valueChanged(valueChangeEvent);
        };
        return ComponentUtil.addListener(this.component, AbstractField.ComponentValueChangeEvent.class, componentListener);
    }

    private AbstractField.ComponentValueChangeEvent<C, T> createValueChange(T oldValue, boolean fromClient) {
        return new AbstractField.ComponentValueChangeEvent<C, T>(this.component, (HasValue)this.component, oldValue, fromClient);
    }

    public T getValue() {
        return this.bufferedValue;
    }

    public T getEmptyValue() {
        return this.defaultValue;
    }

    public void setValue(T value) {
        this.setValue(value, false, false);
    }

    public boolean valueEquals(T value1, T value2) {
        return Objects.equals(value1, value2);
    }

    public void setModelValue(T newModelValue, boolean fromClient) {
        if (this.presentationUpdateInProgress) {
            this.valueSetFromPresentationUpdate = true;
            this.pendingValueFromPresentation = newModelValue;
            return;
        }
        this.setValue(newModelValue, true, fromClient);
    }

    public void bindValue(WritableSignal<T> valueSignal) {
        SignalBindingFeature feature = ((Component)this.component).getElement().getNode().getFeature(SignalBindingFeature.class);
        if (valueSignal == null) {
            feature.removeBinding("value");
        } else {
            if (feature.hasBinding("value")) {
                throw new BindingActiveException();
            }
            Registration registration = ElementEffect.bind(((Component)this.component).getElement(), valueSignal, (element, value) -> this.setValueFromSignal(value));
            feature.setBinding("value", registration, valueSignal);
        }
    }

    private void setValueFromSignal(T value) {
        try {
            this.valueSetFromSignal = true;
            ((HasValue)this.component).setValue(value);
        }
        finally {
            this.valueSetFromSignal = false;
        }
    }

    private void setValue(T newValue, boolean fromInternal, boolean fromClient) {
        if (fromClient && ((HasValue)this.component).isReadOnly()) {
            this.applyValue(this.bufferedValue);
            return;
        }
        T oldValue = this.getValue();
        if (this.valueEquals.test(newValue, oldValue)) {
            return;
        }
        this.bufferedValue = newValue;
        if (!fromInternal) {
            boolean pendingInternalUpdated;
            try {
                pendingInternalUpdated = this.applyValue(newValue);
            }
            catch (RuntimeException e) {
                this.bufferedValue = oldValue;
                throw e;
            }
            if (pendingInternalUpdated) {
                if (this.valueEquals.test(this.pendingValueFromPresentation, oldValue)) {
                    this.bufferedValue = oldValue;
                    return;
                }
                this.bufferedValue = this.pendingValueFromPresentation;
            }
        }
        if (!this.valueSetFromSignal) {
            this.getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> {
                if (((Component)this.component).isAttached()) {
                    feature.updateWritableSignalValue("value", newValue);
                }
            });
        }
        ComponentUtil.fireEvent(this.component, this.createValueChange(oldValue, fromClient));
    }

    private boolean applyValue(T value) {
        this.presentationUpdateInProgress = true;
        this.valueSetFromPresentationUpdate = false;
        try {
            this.setPresentationValue.accept(value);
        }
        finally {
            this.presentationUpdateInProgress = false;
        }
        return this.valueSetFromPresentationUpdate;
    }

    private <FEATURE extends NodeFeature> Optional<FEATURE> getFeatureIfInitialized(Class<FEATURE> featureClass) {
        try {
            return ((Component)this.component).getElement().getNode().getFeatureIfInitialized(featureClass);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }
}

