/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEffect;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public interface HasComponents
extends HasElement,
HasEnabled {
    default public void add(Component ... components) {
        this.throwIfChildrenBindingIsActive("add");
        Objects.requireNonNull(components, "Components should not be null");
        this.add(Arrays.asList(components));
    }

    default public void add(Collection<Component> components) {
        this.throwIfChildrenBindingIsActive("add");
        Objects.requireNonNull(components, "Components should not be null");
        components.stream().map(component -> Objects.requireNonNull(component, "Component to add cannot be null")).map(Component::getElement).forEach(arg_0 -> HasComponents.lambda$add$1(this.getElement(), arg_0));
    }

    default public void add(String text) {
        this.throwIfChildrenBindingIsActive("add");
        this.add(new Text(text));
    }

    default public void remove(Component ... components) {
        this.throwIfChildrenBindingIsActive("remove");
        Objects.requireNonNull(components, "Components should not be null");
        this.remove(Arrays.asList(components));
    }

    default public void remove(Collection<Component> components) {
        this.throwIfChildrenBindingIsActive("remove");
        Objects.requireNonNull(components, "Components should not be null");
        ArrayList<Component> toRemove = new ArrayList<Component>(components.size());
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            Element parent = component.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(HasComponents.class).debug("Remove of a component with no parent does nothing.");
                continue;
            }
            if (this.getElement().equals(parent)) {
                toRemove.add(component);
                continue;
            }
            throw new IllegalArgumentException("The given component (" + String.valueOf(component) + ") is not a child of this component");
        }
        toRemove.stream().map(Component::getElement).forEach(arg_0 -> HasComponents.lambda$remove$2(this.getElement(), arg_0));
    }

    default public void removeAll() {
        this.throwIfChildrenBindingIsActive("removeAll");
        this.getElement().removeAllChildren();
    }

    default public void addComponentAtIndex(int index, Component component) {
        this.throwIfChildrenBindingIsActive("addComponentAtIndex");
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        this.getElement().insertChild(index, component.getElement());
    }

    default public void addComponentAsFirst(Component component) {
        this.throwIfChildrenBindingIsActive("addComponentAsFirst");
        this.addComponentAtIndex(0, component);
    }

    default public <T, S extends Signal<T>> Registration bindChildren(Signal<List<S>> list, SerializableFunction<S, Component> childFactory) {
        Component self = (Component)((Object)this);
        StateNode node = self.getElement().getNode();
        SignalBindingFeature feature = node.getFeature(SignalBindingFeature.class);
        if (feature.hasBinding("children")) {
            throw new BindingActiveException();
        }
        Objects.requireNonNull(list, "Signal cannot be null");
        Objects.requireNonNull(childFactory, "Child component factory cannot be null");
        Registration binding = ComponentEffect.bindChildren(self, list, childFactory);
        feature.setBinding("children", binding, list);
        return () -> feature.removeBinding("children");
    }

    private void throwIfChildrenBindingIsActive(String methodName) {
        this.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> {
            if (feature.hasBinding("children")) {
                throw new BindingActiveException(methodName + " is not allowed while a binding for children exists.");
            }
        });
    }

    private static /* synthetic */ void lambda$remove$2(Element rec$, Element xva$0) {
        Element cfr_ignored_0 = (Element)rec$.removeChild(xva$0);
    }

    private static /* synthetic */ void lambda$add$1(Element rec$, Element xva$0) {
        Element cfr_ignored_0 = (Element)rec$.appendChild(xva$0);
    }
}

