/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.function.SerializableRunnable;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.operations.TransactionOperation;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.impl.AsynchronousSignalTreeTest;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedValueSignalTest
extends SignalTestBase {
    @Test
    void constructor_type_noValueAndTypeIsUsed() {
        SharedValueSignal signal = new SharedValueSignal(String.class);
        Assertions.assertNull((Object)signal.value());
        signal.value((Object)"a string");
        Assertions.assertEquals((Object)"a string", (Object)signal.value());
        Assertions.assertThrows(AssertionError.class, () -> {
            SharedValueSignal raw = signal;
            raw.value(new Object());
        });
        Assertions.assertEquals((Object)"a string", (Object)signal.value());
    }

    @Test
    void constructor_initialValue_valueUsedAndTypeIsInferred() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        Assertions.assertEquals((Object)"initial", (Object)signal.value());
        signal.value((Object)"a string");
        Assertions.assertEquals((Object)"a string", (Object)signal.value());
        Assertions.assertThrows(AssertionError.class, () -> {
            SharedValueSignal raw = signal;
            raw.value(new Object());
        });
        Assertions.assertEquals((Object)"a string", (Object)signal.value());
    }

    @Test
    void constructor_nullType_throws() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Class type = null;
            new SharedValueSignal(type);
        });
    }

    @Test
    void constructor_nullInitialValue_throws() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Object initial = null;
            new SharedValueSignal(initial);
        });
    }

    @Test
    void value_mutateValueInstance_signalValueUnaffected() {
        String[] array = new String[]{"initial"};
        SharedValueSignal signal = new SharedValueSignal((Object)array);
        array[0] = "modified";
        Assertions.assertEquals((Object)"initial", (Object)((String[])signal.value())[0]);
        ((String[])signal.value())[0] = "modified";
        Assertions.assertEquals((Object)"initial", (Object)((String[])signal.value())[0]);
    }

    @Test
    void value_hasPrevious_previousInResult() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SignalOperation operation = signal.value((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)signal.value());
        String resultValue = (String)TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"initial", (Object)resultValue);
    }

    @Test
    void peekConfirmed_hasUnconfirmedChange_changeIngored() {
        AsyncSharedValueSignal signal = new AsyncSharedValueSignal();
        signal.value("update");
        Assertions.assertEquals((Object)"update", (Object)signal.value());
        Assertions.assertNull((Object)signal.peekConfirmed());
        signal.tree().confirmSubmitted();
        Assertions.assertEquals((Object)"update", (Object)signal.peekConfirmed());
    }

    @Test
    void replace_expectedValue_successfulResult() {
        SharedValueSignal signal = new SharedValueSignal((Object)"expected");
        SignalOperation operation = signal.replace((Object)"expected", (Object)"update");
        Assertions.assertEquals((Object)"update", (Object)signal.value());
        TestUtil.assertSuccess(operation);
    }

    @Test
    void replace_unexpectedValue_failedlResult() {
        SharedValueSignal signal = new SharedValueSignal((Object)"unexpected");
        SignalOperation operation = signal.replace((Object)"expected", (Object)"update");
        Assertions.assertEquals((Object)"unexpected", (Object)signal.value());
        TestUtil.assertFailure(operation);
    }

    @Test
    void update_noConflict_updatedWithPreviousValueInResult() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        CancelableOperation operation = signal.update(previous -> {
            Assertions.assertEquals((Object)"initial", (Object)previous);
            return "update";
        });
        Assertions.assertEquals((Object)"initial", TestUtil.assertSuccess(operation));
    }

    @Test
    void update_cancelWithConflict_noFurtherInvocationsAndCancelledResult() {
        AsyncSharedValueSignal signal = new AsyncSharedValueSignal();
        CancelableOperation operation = signal.update(previous -> {
            Assertions.assertNull((Object)previous);
            return "update";
        });
        operation.cancel();
        signal.tree().confirm(List.of(TestUtil.writeRootValueCommand("unexpected")));
        Assertions.assertFalse((boolean)operation.result().isDone());
        signal.tree().confirmSubmitted();
        Assertions.assertTrue((boolean)operation.result().isCancelled());
    }

    @Test
    void update_cancelWithoutConflict_succeeds() {
        AsyncSharedValueSignal signal = new AsyncSharedValueSignal();
        CancelableOperation operation = signal.update(previous -> {
            Assertions.assertNull((Object)previous);
            return "update";
        });
        operation.cancel();
        signal.tree().confirmSubmitted();
        Assertions.assertNull(TestUtil.assertSuccess(operation));
        Assertions.assertEquals((Object)"update", (Object)signal.value());
    }

    @Test
    void update_conflictsNoCancel_eventuallySucceeds() {
        SharedValueSignal signal = new SharedValueSignal((Object)0);
        CancelableOperation operation = signal.update(previous -> {
            if (previous < 5) {
                Signal.runWithoutTransaction((TransactionTask & Serializable)() -> signal.value((Object)(previous + 1)));
            }
            return previous + 1;
        });
        Assertions.assertEquals((int)5, (Integer)((Integer)TestUtil.assertSuccess(operation)));
        Assertions.assertEquals((int)6, (Integer)((Integer)signal.value()));
    }

    @Test
    void verifyValue_expectedValue_operationSuccessful() {
        SharedValueSignal signal = new SharedValueSignal((Object)"expected");
        SignalOperation operation = signal.verifyValue((Object)"expected");
        TestUtil.assertSuccess(operation);
    }

    @Test
    void verifyValue_unexpectedValue_operationSuccessful() {
        SharedValueSignal signal = new SharedValueSignal((Object)"unexpected");
        SignalOperation operation = signal.verifyValue((Object)"expected");
        TestUtil.assertFailure(operation);
    }

    @Test
    void withValidator_acceptsOperation_operationAccepted() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        ArrayList validatedCommands = new ArrayList();
        SharedValueSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            validatedCommands.add(command);
            return true;
        });
        wrapper.value((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)signal.value());
        Assertions.assertEquals((int)1, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.SetCommand.class, validatedCommands.get(0));
    }

    @Test
    void withValidator_rejectsNullValues_nullRejectedAndOtherAccepted() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SharedValueSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            if (command instanceof SignalCommand.SetCommand) {
                SignalCommand.SetCommand set = (SignalCommand.SetCommand)command;
                return !set.value().isNull();
            }
            return true;
        });
        SignalOperation updateResult = wrapper.value((Object)"update");
        TestUtil.assertSuccess(updateResult);
        Assertions.assertEquals((Object)"update", (Object)wrapper.value());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> wrapper.value(null));
        Assertions.assertEquals((Object)"update", (Object)wrapper.value());
    }

    @Test
    void withValidator_changeThroughOriginal_validatorNotInvokedAndWrapperUpdated() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SharedValueSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            throw new RuntimeException();
        });
        signal.value((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)wrapper.value());
    }

    @Test
    void withValidator_verifyCommand_validatorNotInvoked() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SharedValueSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            throw new RuntimeException();
        });
        SignalOperation result = wrapper.verifyValue((Object)"initial");
        TestUtil.assertSuccess(result);
    }

    @Test
    void withValidator_inTransaction_validatorInvokedForChildren() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        ArrayList validatedCommands = new ArrayList();
        SharedValueSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            validatedCommands.add(command);
            return true;
        });
        Signal.runInTransaction((TransactionTask & Serializable)() -> wrapper.value((Object)"update"));
        Assertions.assertEquals((int)1, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.SetCommand.class, validatedCommands.get(0));
    }

    @Test
    void readonly_makeChanges_changesRejected() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SharedValueSignal readonly = signal.asReadonly();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonly.value((Object)"Update"));
        Assertions.assertEquals((Object)"initial", (Object)readonly.value());
    }

    @Test
    void usageTracking_changingSignalValue_usageDetectsValueChange() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        AtomicInteger count = new AtomicInteger();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        Assertions.assertFalse((boolean)usage.hasChanges());
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return false;
        });
        signal.value((Object)"update");
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertTrue((boolean)usage.hasChanges());
        signal.value((Object)"anohter");
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void usageTracking_repeatingChangeListener_usageDetectsFollowingValueChange() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        AtomicInteger count = new AtomicInteger();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return true;
        });
        signal.value((Object)"update");
        Assertions.assertEquals((int)1, (int)count.intValue());
        signal.value((Object)"anohter");
        Assertions.assertEquals((int)2, (int)count.intValue());
    }

    @Test
    void usageTracking_noOpChange_listenerNotNotifiedButRemainsActive() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        AtomicInteger count = new AtomicInteger();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return false;
        });
        signal.value((Object)"initial");
        Assertions.assertEquals((int)0, (int)count.intValue());
        Assertions.assertFalse((boolean)usage.hasChanges());
        signal.value((Object)"update");
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void usageTracking_unrelatedChange_listenerNotNotifiedButRemainsActive() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        AtomicInteger count = new AtomicInteger();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return false;
        });
        signal.asNode().putChildWithValue("key", (Object)"value");
        Assertions.assertEquals((int)0, (int)count.intValue());
        Assertions.assertFalse((boolean)usage.hasChanges());
        signal.value((Object)"update");
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void usageTracking_registerAfterChange_listenerCalledImmediately() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        AtomicInteger falseCount = new AtomicInteger();
        AtomicInteger trueCount = new AtomicInteger();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        signal.value((Object)"update");
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            falseCount.incrementAndGet();
            return false;
        });
        Assertions.assertEquals((int)1, (int)falseCount.intValue());
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            trueCount.incrementAndGet();
            return true;
        });
        Assertions.assertEquals((int)1, (int)trueCount.intValue());
        signal.value((Object)"again");
        Assertions.assertEquals((int)1, (int)falseCount.intValue());
        Assertions.assertEquals((int)2, (int)trueCount.intValue());
    }

    @Test
    void usageTracking_removeSignalAfterTracking_hasNoChanges() {
        SharedListSignal list = new SharedListSignal(String.class);
        SharedValueSignal signal = (SharedValueSignal)list.insertLast((Object)"value").signal();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        list.remove(signal);
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void usageTracking_removeSignalBeforeTracking_hasNoChanges() {
        SharedListSignal list = new SharedListSignal(String.class);
        SharedValueSignal signal = (SharedValueSignal)list.insertLast((Object)"value").signal();
        list.remove(signal);
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.value());
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void result_successfulOperation_resolvedThroughResultNotifier() {
        SignalTestBase.TestExecutor notifier = this.useTestResultNotifier();
        SharedValueSignal signal = new SharedValueSignal(String.class);
        SignalOperation operation = signal.value((Object)"update");
        Assertions.assertFalse((boolean)operation.result().isDone());
        Assertions.assertEquals((int)1, (int)notifier.countPendingTasks());
        notifier.runPendingTasks();
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertEquals((int)0, (int)notifier.countPendingTasks());
    }

    @Test
    void result_failingOperation_resolvedThroughResultNotifier() {
        SignalTestBase.TestExecutor notifier = this.useTestResultNotifier();
        SharedValueSignal signal = new SharedValueSignal(String.class);
        SignalOperation operation = signal.replace((Object)"other", (Object)"update");
        Assertions.assertFalse((boolean)operation.result().isDone());
        Assertions.assertEquals((int)1, (int)notifier.countPendingTasks());
        notifier.runPendingTasks();
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertEquals((int)0, (int)notifier.countPendingTasks());
    }

    @Test
    void transaction_withSupplier_supplierIsRunAndReturnValueAccessible() {
        AtomicInteger inCount = new AtomicInteger();
        AtomicInteger withoutCount = new AtomicInteger();
        TransactionOperation operation = Signal.runInTransaction((ValueSupplier & Serializable)() -> {
            Assertions.assertTrue((boolean)Transaction.inTransaction());
            inCount.incrementAndGet();
            return (String)Signal.runWithoutTransaction((ValueSupplier & Serializable)() -> {
                Assertions.assertFalse((boolean)Transaction.inTransaction());
                withoutCount.incrementAndGet();
                return "result";
            });
        });
        Assertions.assertEquals((int)1, (int)inCount.intValue());
        Assertions.assertEquals((int)1, (int)withoutCount.intValue());
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"result", (Object)operation.returnValue());
    }

    @Test
    void transaction_withRunnable_runnableIsRun() {
        AtomicInteger inCount = new AtomicInteger();
        AtomicInteger withoutCount = new AtomicInteger();
        TransactionOperation operation = Signal.runInTransaction((TransactionTask & Serializable)() -> {
            Assertions.assertTrue((boolean)Transaction.inTransaction());
            inCount.incrementAndGet();
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> {
                Assertions.assertFalse((boolean)Transaction.inTransaction());
                withoutCount.incrementAndGet();
            });
        });
        Assertions.assertEquals((int)1, (int)inCount.intValue());
        Assertions.assertEquals((int)1, (int)withoutCount.intValue());
        TestUtil.assertSuccess(operation);
        Assertions.assertNull((Object)operation.returnValue());
    }

    @Test
    void transaction_withFailingSupplier_supplierIsRunAndReturnValueAccessible() {
        AtomicInteger inCount = new AtomicInteger();
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        TransactionOperation operation = Signal.runInTransaction((ValueSupplier & Serializable)() -> {
            Assertions.assertTrue((boolean)Transaction.inTransaction());
            inCount.incrementAndGet();
            signal.verifyValue((Object)"other");
            return "result";
        });
        Assertions.assertEquals((int)1, (int)inCount.intValue());
        TestUtil.assertFailure(operation);
        Assertions.assertEquals((Object)"result", (Object)operation.returnValue());
    }

    @Test
    void transaction_readValue_readThroughTransaction() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.value();
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> signal.value((Object)"update"));
            Assertions.assertEquals((Object)"value", (Object)signal.value());
        });
        Assertions.assertEquals((Object)"update", (Object)signal.value());
    }

    @Test
    void transaction_writeValue_writtenThroughTransaction() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.value((Object)"update");
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> Assertions.assertEquals((Object)"value", (Object)signal.value()));
        });
        Assertions.assertEquals((Object)"update", (Object)signal.value());
    }

    @Test
    void transaction_readInTransactionAndChangeOutside_transactionFails() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        TransactionOperation operation = Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.value((Object)((String)signal.value() + " update"));
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> signal.value((Object)"update"));
        });
        TestUtil.assertFailure(operation);
        Assertions.assertEquals((Object)"update", (Object)signal.value());
    }

    @Test
    void transaction_peekInTransactionAndChangeOutside_transactionSuccessful() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        TransactionOperation operation = Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.value((Object)((String)signal.peek() + " update"));
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> signal.value((Object)"update"));
        });
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"value update", (Object)signal.value());
    }

    @Test
    void transaction_peekConfirmedInTransactionAndChangeOutside_transactionSuccessful() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        TransactionOperation operation = Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.value((Object)((String)signal.peekConfirmed() + " update"));
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> signal.value((Object)"update"));
        });
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"value update", (Object)signal.value());
    }

    @Test
    void equalsHashCode() {
        SharedValueSignal signal = new SharedValueSignal(String.class);
        Assertions.assertEquals((Object)signal, (Object)signal);
        SharedValueSignal copy = new SharedValueSignal(signal.tree(), signal.id(), signal.validator(), String.class);
        Assertions.assertEquals((Object)signal, (Object)copy);
        Assertions.assertEquals((int)signal.hashCode(), (int)copy.hashCode());
        SharedValueSignal asValue = signal.asNode().asValue(String.class);
        Assertions.assertEquals((Object)signal, (Object)asValue);
        Assertions.assertEquals((int)signal.hashCode(), (int)asValue.hashCode());
        Assertions.assertNotEquals((Object)signal, (Object)new SharedValueSignal(String.class));
        Assertions.assertNotEquals((Object)signal, (Object)signal.asReadonly());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode().asValue(Double.class));
    }

    @Test
    void toString_includesValue() {
        SharedValueSignal signal = new SharedValueSignal((Object)"signal value");
        Assertions.assertEquals((Object)"SharedValueSignal[signal value]", (Object)signal.toString());
    }

    public static class AsyncSharedValueSignal
    extends SharedValueSignal<String> {
        public AsyncSharedValueSignal() {
            super((SignalTree)new AsynchronousSignalTreeTest.AsyncTestTree(), Id.ZERO, ANYTHING_GOES, String.class);
        }

        public AsynchronousSignalTreeTest.AsyncTestTree tree() {
            return (AsynchronousSignalTreeTest.AsyncTestTree)super.tree();
        }
    }
}

