/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.CleanupCallback;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedMapSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.SharedValueSignalTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EffectTest
extends SignalTestBase {
    @Test
    void newEffect_actionIsRunOnce() {
        AtomicInteger count = new AtomicInteger();
        Signal.effect((EffectAction & Serializable)() -> count.incrementAndGet());
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void newEffect_closeImmediately_actionIsRunOnce() {
        AtomicInteger count = new AtomicInteger();
        Signal.effect((EffectAction & Serializable)() -> count.incrementAndGet()).cleanup();
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void changeTracking_effectReadsValue_effectRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Assertions.assertEquals(List.of(""), invocations);
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("", "update"), invocations);
        signal.value((Object)"again");
        Assertions.assertEquals(List.of("", "update", "again"), invocations);
    }

    @Test
    void changeTracking_changeListStructure_effectRunAgain() {
        SharedListSignal signal = new SharedListSignal(String.class);
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add(((List)signal.value()).size()));
        Assertions.assertEquals(List.of(Integer.valueOf(0)), invocations);
        SharedValueSignal child = (SharedValueSignal)signal.insertLast((Object)"one").signal();
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1)), invocations);
        signal.remove(child);
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0)), invocations);
    }

    @Test
    void changeTracking_changeMapStructure_effectRunAgain() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add(((Map)signal.value()).size()));
        Assertions.assertEquals(List.of(Integer.valueOf(0)), invocations);
        signal.put("key", (Object)"value");
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1)), invocations);
        signal.remove("key");
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0)), invocations);
    }

    @Test
    void changeTracking_effectStopsReadingValue_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        AtomicBoolean read = new AtomicBoolean(true);
        Signal.effect((EffectAction & Serializable)() -> {
            if (read.get()) {
                invocations.add((String)signal.value());
            } else {
                invocations.add("ignored");
            }
        });
        read.set(false);
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("", "ignored"), invocations);
        read.set(true);
        signal.value((Object)"again");
        Assertions.assertEquals(List.of("", "ignored"), invocations, (String)"The effect should no longer depend on the signal");
    }

    @Test
    void changeTracking_effectReadsThrougUntracked_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        AtomicBoolean read = new AtomicBoolean(true);
        Signal.effect((EffectAction & Serializable)() -> {
            if (read.get()) {
                invocations.add((String)signal.value());
            } else {
                invocations.add((String)Signal.untracked((ValueSupplier & Serializable)() -> "untracked: " + (String)signal.value()));
            }
        });
        read.set(false);
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("", "untracked: update"), invocations);
        read.set(true);
        signal.value((Object)"again");
        Assertions.assertEquals(List.of("", "untracked: update"), invocations, (String)"The effect should no longer depend on the signal");
    }

    @Test
    void changeTracking_failedWrite_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        signal.replace((Object)"foo", (Object)"bar");
        Assertions.assertEquals(List.of(""), invocations);
    }

    @Test
    void changeTracking_multipleWritesInTransaction_effectRunOnce() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.value((Object)"first");
            signal.value((Object)"second");
        });
        Assertions.assertEquals(List.of("", "second"), invocations);
    }

    @Test
    void changeTracking_multipleSignalsInTransaction_effectRunOnce() {
        SharedValueSignal signal1 = new SharedValueSignal((Object)"");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal1.value() + (String)signal2.value()));
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal1.value((Object)"one ");
            signal2.value((Object)"two");
        });
        Assertions.assertEquals(List.of("", "one two"), invocations);
    }

    @Test
    void changeTracking_changeOtherPartOfNode_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Assertions.assertEquals(List.of("value"), invocations);
        signal.asNode().putChildWithValue("key", (Object)"value");
        Assertions.assertEquals(List.of("value"), invocations);
    }

    @Test
    void changeTracking_asyncSignal_effectUsesSubmittedValue() {
        SharedValueSignalTest.AsyncSharedValueSignal signal = new SharedValueSignalTest.AsyncSharedValueSignal();
        signal.value("");
        signal.tree().confirmSubmitted();
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Assertions.assertEquals(List.of(""), invocations);
        signal.replace("", "update");
        Assertions.assertEquals(List.of("", "update"), invocations);
        signal.tree().confirm(List.of(TestUtil.writeRootValueCommand("conflict")));
        Assertions.assertEquals(List.of("", "update", "conflict"), invocations);
        signal.tree().confirmSubmitted();
        Assertions.assertEquals(List.of("", "update", "conflict"), invocations);
    }

    @Test
    void changeTracking_noOpChange_effectNotRunButRemainsActive() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Assertions.assertEquals(List.of("value"), invocations);
        signal.value((Object)"value");
        Assertions.assertEquals(List.of("value"), invocations);
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void changeTracking_readChildNodes_coveredByNextEffectInvocation() {
        SharedListSignal signal = new SharedListSignal(String.class);
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> {
            List<String> values = ((List)signal.value()).stream().map(Signal::value).toList();
            invocations.add(values);
        });
        Assertions.assertEquals(List.of(List.of()), invocations);
        signal.insertLast((Object)"One");
        Assertions.assertEquals(List.of(List.of(), List.of("One")), invocations);
        signal.insertLast((Object)"Two");
        Assertions.assertEquals(List.of(List.of(), List.of("One"), List.of("One", "Two")), invocations);
    }

    @Test
    void changeTracking_changeValueToNull_effectTriggered() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Assertions.assertEquals(Arrays.asList("initial"), invocations);
        signal.value(null);
        Assertions.assertEquals(Arrays.asList("initial", null), invocations);
    }

    @Test
    void changeTracking_lambdaSignal_changeTracked() {
        SharedValueSignal signal = new SharedValueSignal((Object)1);
        Signal & Serializable doubled = (Signal & Serializable)() -> (Integer)signal.value() * 2;
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((Integer)doubled.value()));
        Assertions.assertEquals(List.of(Integer.valueOf(2)), invocations);
        signal.value((Object)2);
        Assertions.assertEquals(List.of(Integer.valueOf(2), Integer.valueOf(4)), invocations);
    }

    @Test
    void close_effectReadsValue_affectNotRunAfterClose() {
        ArrayList invocations = new ArrayList();
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        CleanupCallback closer = Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        closer.cleanup();
        signal.value((Object)"update");
        Assertions.assertEquals(List.of(""), invocations);
    }

    @Test
    void dispatcher_multipleWrites_singleUpdateWhenDispatcherTriggers() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial"), invocations);
        signal.value((Object)"update1");
        signal.value((Object)"update2");
        Assertions.assertEquals(List.of("initial"), invocations);
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial", "update2"), invocations);
    }

    @Test
    void dispatcher_closeWithPendingUpdate_noUpdate() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        ArrayList invocations = new ArrayList();
        CleanupCallback closer = Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial"), invocations);
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("initial"), invocations);
        closer.cleanup();
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial"), invocations);
    }

    @Test
    void exceptionHandling_effectThrowsException_effectRemainsFunctional() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        RuntimeException exception = new RuntimeException("Expected exception");
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> {
            invocations.add((String)signal.value());
            throw exception;
        });
        this.assertUncaughtException(exception);
        signal.value((Object)"update");
        this.assertUncaughtException(exception);
        Assertions.assertEquals(List.of("initial", "update"), invocations);
    }

    @Test
    void exceptionHandling_effectThrowsException_otherEffectsWork() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        RuntimeException exception = new RuntimeException("Expected exception");
        Signal.effect((EffectAction & Serializable)() -> {
            throw exception;
        });
        this.assertUncaughtException(exception);
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("initial", "update"), invocations);
    }

    @Test
    void exceptionHandling_effectThrowsError_effectClosed() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        ArrayList invocations = new ArrayList();
        Error error = new Error("Expected error");
        Signal.effect((EffectAction & Serializable)() -> {
            invocations.add((String)signal.value());
            throw error;
        });
        Assertions.assertEquals(List.of("initial"), invocations);
        this.assertUncaughtException((Throwable caught) -> caught.getCause() == error);
        signal.value((Object)"update");
        Assertions.assertEquals(List.of("initial"), invocations);
    }

    @Test
    void infiniteLoopDetection_writeUnrelatedSignal_noError() {
        SharedValueSignal other = new SharedValueSignal((Object)"other");
        SharedValueSignal signal = new SharedValueSignal((Object)"signal");
        Signal.effect((EffectAction & Serializable)() -> other.value((Object)((String)signal.value())));
        Assertions.assertEquals((Object)"signal", (Object)other.value());
        signal.value((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)other.value());
    }

    @Test
    void infiniteLoopDetection_writeOwnSignal_loopDetected() {
        SharedValueSignal signal = new SharedValueSignal((Object)"signal");
        SharedValueSignal trigger = new SharedValueSignal((Object)"trigger");
        AtomicInteger count = new AtomicInteger();
        Signal.effect((EffectAction & Serializable)() -> {
            count.incrementAndGet();
            trigger.value();
            signal.value();
            Assertions.assertThrows(IllegalStateException.class, () -> signal.value((Object)"update"));
        });
        Assertions.assertEquals((int)1, (int)count.get());
        trigger.value((Object)"update");
        Assertions.assertEquals((int)1, (int)count.get(), (String)"Signal should have been disabled");
    }

    @Test
    void infiniteLoopDetection_loopBetweenEffects_loopDetectedFromSetter() {
        SharedValueSignal signal1 = new SharedValueSignal((Object)"signal");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"signal");
        AtomicInteger throwCount = new AtomicInteger();
        Signal.effect((EffectAction & Serializable)() -> {
            String value = (String)signal2.value() + " update";
            try {
                signal1.value((Object)value);
            }
            catch (IllegalStateException e) {
                throwCount.incrementAndGet();
            }
        });
        Assertions.assertEquals((int)0, (int)throwCount.get(), (String)"Should not fail with only one effect active");
        Signal.effect((EffectAction & Serializable)() -> signal2.value((Object)((String)signal1.value() + " update")));
        Assertions.assertEquals((int)1, (int)throwCount.get(), (String)"Should fail when the other effect is created");
    }

    @Test
    void infiniteLoopDetection_loopBetweenConditionalEffects_loopDetected() {
        SharedValueSignal signal1 = new SharedValueSignal((Object)"signal");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"signal");
        SharedValueSignal trigger = new SharedValueSignal((Object)false);
        Signal.effect((EffectAction & Serializable)() -> signal1.value((Object)((String)signal2.value() + " update")));
        Signal.effect((EffectAction & Serializable)() -> {
            if (((Boolean)trigger.value()).booleanValue()) {
                signal2.value((Object)((String)signal1.value() + " update"));
            }
        });
        this.assertNoUncaughtException();
        trigger.value((Object)true);
        this.assertUncaughtException(IllegalStateException.class);
    }

    @Test
    void infiniteLoopDetection_loopBetweenAsyncEffects_loopDetected() {
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        SharedValueSignal signal1 = new SharedValueSignal((Object)"signal");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"signal");
        Signal.effect((EffectAction & Serializable)() -> signal1.value((Object)((String)signal2.value() + " update")));
        dispatcher.runPendingTasks();
        Signal.effect((EffectAction & Serializable)() -> signal2.value((Object)((String)signal1.value() + " update")));
        dispatcher.runPendingTasks();
        this.assertNoUncaughtException();
        dispatcher.runPendingTasks();
        this.assertUncaughtException(IllegalStateException.class);
    }

    @Test
    void infiniteLoopDetection_concurrentSignalWrite_notDetectedAsLoop() {
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        ArrayList invocations = new ArrayList();
        SharedValueSignal<String> signal = new SharedValueSignal<String>("signal"){

            protected UsageTracker.Usage createUsage(Transaction transaction) {
                final UsageTracker.Usage usage = super.createUsage(transaction);
                return new UsageTracker.Usage(){

                    public boolean hasChanges() {
                        return usage.hasChanges();
                    }

                    public CleanupCallback onNextChange(TransientListener listener) {
                        this.value("update");
                        return usage.onNextChange(listener);
                    }
                };
            }
        };
        Signal.effect(() -> EffectTest.lambda$infiniteLoopDetection_concurrentSignalWrite_notDetectedAsLoop$993b51ad$1(invocations, (SharedValueSignal)signal));
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("signal"), invocations);
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("signal", "update"), invocations);
    }

    private static /* synthetic */ void lambda$infiniteLoopDetection_concurrentSignalWrite_notDetectedAsLoop$993b51ad$1(List invocations, SharedValueSignal signal) {
        invocations.add((String)signal.value());
    }
}

